/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public abstract class KernelExtensionFactoryContractTest {
    private final Class<? extends KernelExtensionFactory<?>> extClass;
    private final String key;
    @Rule
    public TestDirectory target = TestDirectory.testDirectory(this.getClass());

    public KernelExtensionFactoryContractTest(String key, Class<? extends KernelExtensionFactory<?>> extClass) {
        this.extClass = extClass;
        this.key = key;
    }

    protected GraphDatabaseAPI graphDb(int instance) {
        Map<String, String> config = this.configuration(instance);
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(config).newGraphDatabase();
    }

    protected Map<String, String> configuration(int instance) {
        return MapUtil.stringMap((String[])new String[0]);
    }

    @Test
    public void extensionShouldHavePublicNoArgConstructor() {
        KernelExtensionFactory<?> instance = null;
        try {
            instance = this.newInstance();
        }
        catch (IllegalArgumentException failure) {
            failure.printStackTrace();
            Assert.fail((String)"Contract violation: extension class must have public no-arg constructor (Exception in stderr)");
        }
        Assert.assertNotNull(instance);
    }

    @Test
    public void shouldBeAbleToLoadExtensionAsAServiceProvider() {
        KernelExtensionFactory<?> instance = null;
        try {
            instance = this.loadInstance();
        }
        catch (ClassCastException failure) {
            failure.printStackTrace();
            Assert.fail((String)"Loaded instance does not match the extension class (Exception in stderr)");
        }
        Assert.assertNotNull((String)"Could not load the kernel extension with the provided key", instance);
        Assert.assertSame((String)"Class of the loaded instance is a subclass of the extension class", instance.getClass(), this.extClass);
    }

    @Test
    public void differentInstancesShouldHaveEqualHashCodesAndBeEqual() {
        KernelExtensionFactory<?> one = this.newInstance();
        KernelExtensionFactory<?> two = this.newInstance();
        Assert.assertEquals((String)"new instances have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"new instances are not equals", one, two);
        one = this.loadInstance();
        two = this.loadInstance();
        Assert.assertEquals((String)"loaded instances have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"loaded instances are not equals", one, two);
        one = this.loadInstance();
        two = this.newInstance();
        Assert.assertEquals((String)"loaded instance and new instance have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"loaded instance and new instance are not equals", one, two);
    }

    private KernelExtensionFactory<?> newInstance() {
        try {
            return this.extClass.newInstance();
        }
        catch (Exception cause) {
            throw new IllegalArgumentException("Could not instantiate extension class", cause);
        }
    }

    private KernelExtensionFactory<?> loadInstance() {
        return this.extClass.cast(Service.load(KernelExtensionFactory.class, (String)this.key));
    }
}

