/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.Iterator;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.Value;

public abstract class KernelIntegrationTest {
    protected final TestDirectory testDir = TestDirectory.testDirectory();
    protected final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDir).around((TestRule)this.fileSystemRule);
    protected GraphDatabaseAPI db;
    ThreadToStatementContextBridge statementContextSupplier;
    protected Kernel kernel;
    protected IndexingService indexingService;
    private Transaction transaction;
    private DbmsOperations dbmsOperations;

    protected TokenWrite tokenWriteInNewTransaction() throws KernelException {
        this.transaction = this.kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.writeToken());
        return this.transaction.tokenWrite();
    }

    protected Write dataWriteInNewTransaction() throws KernelException {
        this.transaction = this.kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.write());
        return this.transaction.dataWrite();
    }

    protected SchemaWrite schemaWriteInNewTransaction() throws KernelException {
        this.transaction = this.kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
        return this.transaction.schemaWrite();
    }

    protected Procedures procs() throws TransactionFailureException {
        this.transaction = this.kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.read());
        return this.transaction.procedures();
    }

    protected Procedures procsSchema() throws TransactionFailureException {
        this.transaction = this.kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.full());
        return this.transaction.procedures();
    }

    protected Transaction newTransaction() throws TransactionFailureException {
        this.transaction = this.kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.read());
        return this.transaction;
    }

    protected Transaction newTransaction(LoginContext loginContext) throws TransactionFailureException {
        this.transaction = this.kernel.beginTransaction(Transaction.Type.implicit, loginContext);
        return this.transaction;
    }

    protected DbmsOperations dbmsOperations() {
        return this.dbmsOperations;
    }

    protected void commit() throws TransactionFailureException {
        this.transaction.success();
        try {
            this.transaction.close();
        }
        finally {
            this.transaction = null;
        }
    }

    protected void rollback() throws TransactionFailureException {
        this.transaction.failure();
        try {
            this.transaction.close();
        }
        finally {
            this.transaction = null;
        }
    }

    @Before
    public void setup() {
        this.startDb();
    }

    @After
    public void cleanup() throws Exception {
        this.stopDb();
    }

    protected void startDb() {
        this.db = (GraphDatabaseAPI)this.createGraphDatabase();
        this.kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        this.indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        this.statementContextSupplier = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.dbmsOperations = (DbmsOperations)this.db.getDependencyResolver().resolveDependency(DbmsOperations.class);
    }

    protected GraphDatabaseService createGraphDatabase() {
        GraphDatabaseBuilder graphDatabaseBuilder = this.createGraphDatabaseFactory().setFileSystem(this.fileSystemRule.get()).newEmbeddedDatabaseBuilder(this.testDir.graphDbDir());
        return this.configure(graphDatabaseBuilder).newGraphDatabase();
    }

    protected TestGraphDatabaseFactory createGraphDatabaseFactory() {
        return new TestGraphDatabaseFactory();
    }

    protected GraphDatabaseBuilder configure(GraphDatabaseBuilder graphDatabaseBuilder) {
        return graphDatabaseBuilder;
    }

    void dbWithNoCache() throws TransactionFailureException {
        this.stopDb();
        this.startDb();
    }

    private void stopDb() throws TransactionFailureException {
        if (this.transaction != null && this.transaction.isOpen()) {
            this.transaction.close();
        }
        this.db.shutdown();
    }

    void restartDb() throws TransactionFailureException {
        this.stopDb();
        this.startDb();
    }

    /*
     * Exception decompiling
     */
    Value relationshipGetProperty(Transaction transaction, long relationship, int property) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Iterator<Long> nodeGetRelationships(Transaction transaction, long node, Direction direction) {
        return this.nodeGetRelationships(transaction, node, direction, null);
    }

    Iterator<Long> nodeGetRelationships(Transaction transaction, long node, Direction direction, int[] types) {
        NodeCursor cursor = transaction.cursors().allocateNodeCursor();
        transaction.dataRead().singleNode(node, cursor);
        if (!cursor.next()) {
            return Collections.emptyIterator();
        }
        switch (direction) {
            case OUTGOING: {
                return RelationshipSelections.outgoingIterator((CursorFactory)transaction.cursors(), (NodeCursor)cursor, (int[])types, (id, startNodeId, typeId, endNodeId) -> id);
            }
            case INCOMING: {
                return RelationshipSelections.incomingIterator((CursorFactory)transaction.cursors(), (NodeCursor)cursor, (int[])types, (id, startNodeId, typeId, endNodeId) -> id);
            }
            case BOTH: {
                return RelationshipSelections.allIterator((CursorFactory)transaction.cursors(), (NodeCursor)cursor, (int[])types, (id, startNodeId, typeId, endNodeId) -> id);
            }
        }
        throw new IllegalStateException(direction + " is not a valid direction");
    }

    protected int countNodes(Transaction transaction) {
        int result = 0;
        try (NodeCursor cursor = transaction.cursors().allocateNodeCursor();){
            transaction.dataRead().allNodesScan(cursor);
            while (cursor.next()) {
                ++result;
            }
        }
        return result;
    }

    int countRelationships(Transaction transaction) {
        int result = 0;
        try (RelationshipScanCursor cursor = transaction.cursors().allocateRelationshipScanCursor();){
            transaction.dataRead().allRelationshipsScan(cursor);
            while (cursor.next()) {
                ++result;
            }
        }
        return result;
    }

    KernelImpl internalKernel() {
        return (KernelImpl)this.kernel;
    }
}

