/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.GraphTransactionRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class NodeTest {
    @ClassRule
    public static DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public GraphTransactionRule tx = new GraphTransactionRule(db);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldGiveHelpfulExceptionWhenDeletingNodeWithRels() {
        Node node = db.createNode();
        Node node2 = db.createNode();
        node.createRelationshipTo(node2, RelationshipType.withName((String)"MAYOR_OF"));
        this.tx.success();
        this.tx.begin();
        node.delete();
        this.exception.expect(ConstraintViolationException.class);
        this.exception.expectMessage("Cannot delete node<" + node.getId() + ">, because it still has relationships. To delete this node, you must first delete its relationships.");
        this.tx.success();
    }

    @Test
    public void testNodeCreateAndDelete() {
        Node node = this.getGraphDb().createNode();
        long nodeId = node.getId();
        this.getGraphDb().getNodeById(nodeId);
        node.delete();
        this.tx.success();
        this.tx.begin();
        try {
            this.getGraphDb().getNodeById(nodeId);
            Assert.fail((String)("Node[" + nodeId + "] should be deleted."));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeletedNode() {
        Node node = this.getGraphDb().createNode();
        node.delete();
        try {
            node.setProperty("key1", (Object)1);
            Assert.fail((String)"Adding stuff to deleted node should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNodeAddPropertyWithNullKey() {
        Node node1 = this.getGraphDb().createNode();
        try {
            node1.setProperty(null, (Object)"bar");
            Assert.fail((String)"Null key should result in exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNodeAddPropertyWithNullValue() {
        Node node1 = this.getGraphDb().createNode();
        try {
            node1.setProperty("foo", null);
            Assert.fail((String)"Null value should result in exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.tx.failure();
    }

    @Test
    public void testNodeAddProperty() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        String key1 = "key1";
        String key2 = "key2";
        String key3 = "key3";
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        node1.setProperty(key1, (Object)int1);
        node2.setProperty(key1, (Object)string1);
        node1.setProperty(key2, (Object)string2);
        node2.setProperty(key2, (Object)int2);
        Assert.assertTrue((boolean)node1.hasProperty(key1));
        Assert.assertTrue((boolean)node2.hasProperty(key1));
        Assert.assertTrue((boolean)node1.hasProperty(key2));
        Assert.assertTrue((boolean)node2.hasProperty(key2));
        Assert.assertTrue((!node1.hasProperty(key3) ? 1 : 0) != 0);
        Assert.assertTrue((!node2.hasProperty(key3) ? 1 : 0) != 0);
        Assert.assertEquals((Object)int1, (Object)node1.getProperty(key1));
        Assert.assertEquals((Object)string1, (Object)node2.getProperty(key1));
        Assert.assertEquals((Object)string2, (Object)node1.getProperty(key2));
        Assert.assertEquals((Object)int2, (Object)node2.getProperty(key2));
    }

    @Test
    public void testNodeRemoveProperty() {
        String key1 = "key1";
        String key2 = "key2";
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        try {
            if (node1.removeProperty(key1) != null) {
                Assert.fail((String)"Remove of non existing property should return null");
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node1.removeProperty(null);
            Assert.fail((String)"Remove null property should throw exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        node1.setProperty(key1, (Object)int1);
        node2.setProperty(key1, (Object)string1);
        node1.setProperty(key2, (Object)string2);
        node2.setProperty(key2, (Object)int2);
        try {
            node1.removeProperty(null);
            Assert.fail((String)"Null argument should result in exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)int1, (Object)node1.removeProperty(key1));
        Assert.assertEquals((Object)string1, (Object)node2.removeProperty(key1));
        try {
            if (node2.removeProperty(key1) != null) {
                Assert.fail((String)"Remove of non existing property return null.");
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNodeChangeProperty() {
        String key1 = "key1";
        String key2 = "key2";
        String key3 = "key3";
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        Boolean bool1 = Boolean.TRUE;
        Boolean bool2 = Boolean.FALSE;
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        node1.setProperty(key1, (Object)int1);
        node2.setProperty(key1, (Object)string1);
        node1.setProperty(key2, (Object)string2);
        node2.setProperty(key2, (Object)int2);
        try {
            node1.setProperty(null, null);
            Assert.fail((String)"Null argument should result in exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NotFoundException e) {
            Assert.fail((String)"wrong exception");
        }
        node1.setProperty(key1, (Object)int2);
        node2.setProperty(key1, (Object)string2);
        Assert.assertEquals((Object)string2, (Object)node2.getProperty(key1));
        node1.setProperty(key3, (Object)bool1);
        node1.setProperty(key3, (Object)bool2);
        Assert.assertEquals((Object)string2, (Object)node2.getProperty(key1));
        node1.delete();
        node2.delete();
    }

    @Test
    public void testNodeChangeProperty2() {
        String key1 = "key1";
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        Boolean bool1 = Boolean.TRUE;
        Boolean bool2 = Boolean.FALSE;
        Node node1 = this.getGraphDb().createNode();
        node1.setProperty(key1, (Object)int1);
        node1.setProperty(key1, (Object)int2);
        Assert.assertEquals((Object)int2, (Object)node1.getProperty(key1));
        node1.removeProperty(key1);
        node1.setProperty(key1, (Object)string1);
        node1.setProperty(key1, (Object)string2);
        Assert.assertEquals((Object)string2, (Object)node1.getProperty(key1));
        node1.removeProperty(key1);
        node1.setProperty(key1, (Object)bool1);
        node1.setProperty(key1, (Object)bool2);
        Assert.assertEquals((Object)bool2, (Object)node1.getProperty(key1));
        node1.removeProperty(key1);
        node1.delete();
    }

    @Test
    public void testNodeGetProperties() {
        String[] names2;
        String key1 = "key1";
        String key2 = "key2";
        String key3 = "key3";
        Integer int1 = 1;
        Integer int2 = 2;
        String string = "3";
        Node node1 = this.getGraphDb().createNode();
        try {
            node1.getProperty(key1);
            Assert.fail((String)"get non existing property didn't throw exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            node1.getProperty(null);
            Assert.fail((String)"get of null key didn't throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((!node1.hasProperty(key1) ? 1 : 0) != 0);
        Assert.assertTrue((!node1.hasProperty(null) ? 1 : 0) != 0);
        node1.setProperty(key1, (Object)int1);
        node1.setProperty(key2, (Object)int2);
        node1.setProperty(key3, (Object)string);
        Iterator keys = node1.getPropertyKeys().iterator();
        keys.next();
        keys.next();
        keys.next();
        Map properties = node1.getAllProperties();
        Assert.assertTrue((boolean)properties.get(key1).equals(int1));
        Assert.assertTrue((boolean)properties.get(key2).equals(int2));
        Assert.assertTrue((boolean)properties.get(key3).equals(string));
        properties = node1.getProperties(new String[]{key1, key2});
        Assert.assertTrue((boolean)properties.get(key1).equals(int1));
        Assert.assertTrue((boolean)properties.get(key2).equals(int2));
        Assert.assertFalse((boolean)properties.containsKey(key3));
        properties = node1.getProperties(new String[0]);
        Assert.assertTrue((boolean)properties.isEmpty());
        try {
            names2 = null;
            node1.getProperties(names2);
            Assert.fail();
        }
        catch (NullPointerException names2) {
            // empty catch block
        }
        try {
            names2 = new String[]{null};
            node1.getProperties(names2);
            Assert.fail();
        }
        catch (NullPointerException names3) {
            // empty catch block
        }
        try {
            node1.removeProperty(key3);
        }
        catch (NotFoundException e) {
            Assert.fail((String)"Remove of property failed.");
        }
        Assert.assertTrue((!node1.hasProperty(key3) ? 1 : 0) != 0);
        Assert.assertTrue((!node1.hasProperty(null) ? 1 : 0) != 0);
        node1.delete();
    }

    @Test
    public void testAddPropertyThenDelete() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("test", (Object)"test");
        this.tx.success();
        this.tx.begin();
        node.setProperty("test2", (Object)"test2");
        node.delete();
        this.tx.success();
    }

    @Test
    public void testChangeProperty() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("test", (Object)"test1");
        this.tx.success();
        this.tx.begin();
        node.setProperty("test", (Object)"test2");
        node.removeProperty("test");
        node.setProperty("test", (Object)"test3");
        Assert.assertEquals((Object)"test3", (Object)node.getProperty("test"));
        node.removeProperty("test");
        node.setProperty("test", (Object)"test4");
        this.tx.success();
        this.tx.begin();
        Assert.assertEquals((Object)"test4", (Object)node.getProperty("test"));
    }

    @Test
    public void testChangeProperty2() {
        Node node = this.getGraphDb().createNode();
        node.setProperty("test", (Object)"test1");
        this.tx.success();
        this.tx.begin();
        node.removeProperty("test");
        node.setProperty("test", (Object)"test3");
        Assert.assertEquals((Object)"test3", (Object)node.getProperty("test"));
        this.tx.success();
        this.tx.begin();
        Assert.assertEquals((Object)"test3", (Object)node.getProperty("test"));
        node.removeProperty("test");
        node.setProperty("test", (Object)"test4");
        this.tx.success();
        this.tx.begin();
        Assert.assertEquals((Object)"test4", (Object)node.getProperty("test"));
    }

    private GraphDatabaseService getGraphDb() {
        return db.getGraphDatabaseAPI();
    }
}

