/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.LongConsumer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReaderTestBase;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.TestDegreeItem;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.TestRelType;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.RandomRule;

public class RecordStorageReaderRelTypesAndDegreeTest
extends RecordStorageReaderTestBase {
    private static final int RELATIONSHIPS_COUNT = 20;
    @Rule
    public final RandomRule random = new RandomRule();

    @Override
    protected GraphDatabaseService createGraphDatabase() {
        return new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.dense_node_threshold, String.valueOf(20)).newGraphDatabase();
    }

    @Test
    public void degreesForDenseNodeWithPartiallyDeletedRelGroupChain() {
        this.testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(new TestRelType[0]);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.OUT);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.LOOP);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.OUT);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.OUT, TestRelType.LOOP);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.LOOP);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.OUT, TestRelType.LOOP);
    }

    @Test
    public void degreesForDenseNodeWithPartiallyDeletedRelChains() {
        this.testDegreesForDenseNodeWithPartiallyDeletedRelChains(false, false, false);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelChains(true, false, false);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelChains(false, true, false);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelChains(false, false, true);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelChains(true, true, false);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelChains(true, true, true);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelChains(true, false, true);
        this.testDegreesForDenseNodeWithPartiallyDeletedRelChains(true, true, true);
    }

    @Test
    public void degreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain() {
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(new TestRelType[0]);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.OUT);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.LOOP);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.OUT);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.LOOP);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.OUT, TestRelType.LOOP);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.OUT, TestRelType.LOOP);
    }

    @Test
    public void degreeByDirectionForDenseNodeWithPartiallyDeletedRelChains() {
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(false, false, false);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(true, false, false);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(false, true, false);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(false, false, true);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(true, true, false);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(true, true, true);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(true, false, true);
        this.testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(true, true, true);
    }

    @Test
    public void degreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain() {
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(new TestRelType[0]);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.OUT);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.LOOP);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.OUT);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.OUT, TestRelType.LOOP);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.LOOP);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType.IN, TestRelType.OUT, TestRelType.LOOP);
    }

    @Test
    public void degreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains() {
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(false, false, false);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(true, false, false);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(false, true, false);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(false, false, true);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(true, true, false);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(true, true, true);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(true, false, true);
        this.testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(true, true, true);
    }

    private void testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType ... typesToDelete) {
        int inRelCount = this.randomRelCount();
        int outRelCount = this.randomRelCount();
        int loopRelCount = this.randomRelCount();
        long nodeId = this.createNode(inRelCount, outRelCount, loopRelCount);
        StorageNodeCursor cursor = this.newCursor(nodeId);
        block5: for (TestRelType type : typesToDelete) {
            this.markRelGroupNotInUse(nodeId, type);
            switch (type) {
                case IN: {
                    inRelCount = 0;
                    continue block5;
                }
                case OUT: {
                    outRelCount = 0;
                    continue block5;
                }
                case LOOP: {
                    loopRelCount = 0;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + type);
                }
            }
        }
        Assert.assertEquals((long)(outRelCount + loopRelCount), (long)this.degreeForDirection(cursor, Direction.OUTGOING));
        Assert.assertEquals((long)(inRelCount + loopRelCount), (long)this.degreeForDirection(cursor, Direction.INCOMING));
        Assert.assertEquals((long)(inRelCount + outRelCount + loopRelCount), (long)this.degreeForDirection(cursor, Direction.BOTH));
    }

    private void testDegreeByDirectionForDenseNodeWithPartiallyDeletedRelChains(boolean modifyInChain, boolean modifyOutChain, boolean modifyLoopChain) {
        int inRelCount = this.randomRelCount();
        int outRelCount = this.randomRelCount();
        int loopRelCount = this.randomRelCount();
        long nodeId = this.createNode(inRelCount, outRelCount, loopRelCount);
        StorageNodeCursor cursor = this.newCursor(nodeId);
        if (modifyInChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.IN);
        }
        if (modifyOutChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.OUT);
        }
        if (modifyLoopChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.LOOP);
        }
        Assert.assertEquals((long)(outRelCount + loopRelCount), (long)this.degreeForDirection(cursor, Direction.OUTGOING));
        Assert.assertEquals((long)(inRelCount + loopRelCount), (long)this.degreeForDirection(cursor, Direction.INCOMING));
        Assert.assertEquals((long)(inRelCount + outRelCount + loopRelCount), (long)this.degreeForDirection(cursor, Direction.BOTH));
    }

    private int degreeForDirection(StorageNodeCursor cursor, Direction direction) {
        return this.degreeForDirectionAndType(cursor, direction, -1);
    }

    private int degreeForDirectionAndType(StorageNodeCursor cursor, Direction direction, int relType) {
        int degree = 0;
        try (StorageRelationshipGroupCursor groups = this.storageReader.allocateRelationshipGroupCursor();){
            groups.init(cursor.nodeReference(), cursor.relationshipGroupReference());
            block14: while (groups.next()) {
                if (relType != -1 && relType != groups.type()) continue;
                switch (direction) {
                    case OUTGOING: {
                        degree += groups.outgoingCount() + groups.loopCount();
                        continue block14;
                    }
                    case INCOMING: {
                        degree += groups.incomingCount() + groups.loopCount();
                        continue block14;
                    }
                    case BOTH: {
                        degree += groups.outgoingCount() + groups.incomingCount() + groups.loopCount();
                        continue block14;
                    }
                }
                throw new IllegalArgumentException(direction.name());
            }
        }
        return degree;
    }

    private void testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType ... typesToDelete) {
        int inRelCount = this.randomRelCount();
        int outRelCount = this.randomRelCount();
        int loopRelCount = this.randomRelCount();
        long nodeId = this.createNode(inRelCount, outRelCount, loopRelCount);
        StorageNodeCursor cursor = this.newCursor(nodeId);
        block5: for (TestRelType type : typesToDelete) {
            this.markRelGroupNotInUse(nodeId, type);
            switch (type) {
                case IN: {
                    inRelCount = 0;
                    continue block5;
                }
                case OUT: {
                    outRelCount = 0;
                    continue block5;
                }
                case LOOP: {
                    loopRelCount = 0;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + type);
                }
            }
        }
        Assert.assertEquals((long)0L, (long)this.degreeForDirectionAndType(cursor, Direction.OUTGOING, this.relTypeId(TestRelType.IN)));
        Assert.assertEquals((long)outRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.OUTGOING, this.relTypeId(TestRelType.OUT)));
        Assert.assertEquals((long)loopRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.OUTGOING, this.relTypeId(TestRelType.LOOP)));
        Assert.assertEquals((long)0L, (long)this.degreeForDirectionAndType(cursor, Direction.INCOMING, this.relTypeId(TestRelType.OUT)));
        Assert.assertEquals((long)inRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.INCOMING, this.relTypeId(TestRelType.IN)));
        Assert.assertEquals((long)loopRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.INCOMING, this.relTypeId(TestRelType.LOOP)));
        Assert.assertEquals((long)inRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.BOTH, this.relTypeId(TestRelType.IN)));
        Assert.assertEquals((long)outRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.BOTH, this.relTypeId(TestRelType.OUT)));
        Assert.assertEquals((long)loopRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.BOTH, this.relTypeId(TestRelType.LOOP)));
    }

    private void testDegreeByDirectionAndTypeForDenseNodeWithPartiallyDeletedRelChains(boolean modifyInChain, boolean modifyOutChain, boolean modifyLoopChain) {
        int inRelCount = this.randomRelCount();
        int outRelCount = this.randomRelCount();
        int loopRelCount = this.randomRelCount();
        long nodeId = this.createNode(inRelCount, outRelCount, loopRelCount);
        StorageNodeCursor cursor = this.newCursor(nodeId);
        if (modifyInChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.IN);
        }
        if (modifyOutChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.OUT);
        }
        if (modifyLoopChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.LOOP);
        }
        Assert.assertEquals((long)0L, (long)this.degreeForDirectionAndType(cursor, Direction.OUTGOING, this.relTypeId(TestRelType.IN)));
        Assert.assertEquals((long)outRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.OUTGOING, this.relTypeId(TestRelType.OUT)));
        Assert.assertEquals((long)loopRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.OUTGOING, this.relTypeId(TestRelType.LOOP)));
        Assert.assertEquals((long)0L, (long)this.degreeForDirectionAndType(cursor, Direction.INCOMING, this.relTypeId(TestRelType.OUT)));
        Assert.assertEquals((long)inRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.INCOMING, this.relTypeId(TestRelType.IN)));
        Assert.assertEquals((long)loopRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.INCOMING, this.relTypeId(TestRelType.LOOP)));
        Assert.assertEquals((long)inRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.BOTH, this.relTypeId(TestRelType.IN)));
        Assert.assertEquals((long)outRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.BOTH, this.relTypeId(TestRelType.OUT)));
        Assert.assertEquals((long)loopRelCount, (long)this.degreeForDirectionAndType(cursor, Direction.BOTH, this.relTypeId(TestRelType.LOOP)));
    }

    @Test
    public void relationshipTypesForDenseNodeWithPartiallyDeletedRelGroupChain() {
        this.testRelationshipTypesForDenseNode(this::noNodeChange, Iterators.asSet((Object[])new TestRelType[]{TestRelType.IN, TestRelType.OUT, TestRelType.LOOP}));
        this.testRelationshipTypesForDenseNode(nodeId -> this.markRelGroupNotInUse(nodeId, TestRelType.IN), Iterators.asSet((Object[])new TestRelType[]{TestRelType.OUT, TestRelType.LOOP}));
        this.testRelationshipTypesForDenseNode(nodeId -> this.markRelGroupNotInUse(nodeId, TestRelType.OUT), Iterators.asSet((Object[])new TestRelType[]{TestRelType.IN, TestRelType.LOOP}));
        this.testRelationshipTypesForDenseNode(nodeId -> this.markRelGroupNotInUse(nodeId, TestRelType.LOOP), Iterators.asSet((Object[])new TestRelType[]{TestRelType.IN, TestRelType.OUT}));
        this.testRelationshipTypesForDenseNode(nodeId -> this.markRelGroupNotInUse(nodeId, TestRelType.IN, TestRelType.OUT), Iterators.asSet((Object[])new TestRelType[]{TestRelType.LOOP}));
        this.testRelationshipTypesForDenseNode(nodeId -> this.markRelGroupNotInUse(nodeId, TestRelType.IN, TestRelType.LOOP), Iterators.asSet((Object[])new TestRelType[]{TestRelType.OUT}));
        this.testRelationshipTypesForDenseNode(nodeId -> this.markRelGroupNotInUse(nodeId, TestRelType.OUT, TestRelType.LOOP), Iterators.asSet((Object[])new TestRelType[]{TestRelType.IN}));
        this.testRelationshipTypesForDenseNode(nodeId -> this.markRelGroupNotInUse(nodeId, TestRelType.IN, TestRelType.OUT, TestRelType.LOOP), Collections.emptySet());
    }

    @Test
    public void relationshipTypesForDenseNodeWithPartiallyDeletedRelChains() {
        this.testRelationshipTypesForDenseNode(this::markRandomRelsNotInUse, Iterators.asSet((Object[])new TestRelType[]{TestRelType.IN, TestRelType.OUT, TestRelType.LOOP}));
    }

    private void testRelationshipTypesForDenseNode(LongConsumer nodeChanger, Set<TestRelType> expectedTypes) {
        int inRelCount = this.randomRelCount();
        int outRelCount = this.randomRelCount();
        int loopRelCount = this.randomRelCount();
        long nodeId = this.createNode(inRelCount, outRelCount, loopRelCount);
        nodeChanger.accept(nodeId);
        StorageNodeCursor cursor = this.newCursor(nodeId);
        Assert.assertEquals(expectedTypes, this.relTypes(cursor));
    }

    private Set<TestRelType> relTypes(StorageNodeCursor cursor) {
        HashSet<TestRelType> types = new HashSet<TestRelType>();
        try (StorageRelationshipGroupCursor groups = this.storageReader.allocateRelationshipGroupCursor();){
            groups.init(cursor.nodeReference(), cursor.relationshipGroupReference());
            while (groups.next()) {
                types.add(this.relTypeForId(groups.type()));
            }
        }
        return types;
    }

    private void testDegreesForDenseNodeWithPartiallyDeletedRelGroupChain(TestRelType ... typesToDelete) {
        int inRelCount = this.randomRelCount();
        int outRelCount = this.randomRelCount();
        int loopRelCount = this.randomRelCount();
        long nodeId = this.createNode(inRelCount, outRelCount, loopRelCount);
        StorageNodeCursor cursor = this.newCursor(nodeId);
        block5: for (TestRelType type : typesToDelete) {
            this.markRelGroupNotInUse(nodeId, type);
            switch (type) {
                case IN: {
                    inRelCount = 0;
                    continue block5;
                }
                case OUT: {
                    outRelCount = 0;
                    continue block5;
                }
                case LOOP: {
                    loopRelCount = 0;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + type);
                }
            }
        }
        HashSet<TestDegreeItem> expectedDegrees = new HashSet<TestDegreeItem>();
        if (outRelCount != 0) {
            expectedDegrees.add(new TestDegreeItem(this.relTypeId(TestRelType.OUT), (long)outRelCount, 0L));
        }
        if (inRelCount != 0) {
            expectedDegrees.add(new TestDegreeItem(this.relTypeId(TestRelType.IN), 0L, (long)inRelCount));
        }
        if (loopRelCount != 0) {
            expectedDegrees.add(new TestDegreeItem(this.relTypeId(TestRelType.LOOP), (long)loopRelCount, (long)loopRelCount));
        }
        Set<TestDegreeItem> actualDegrees = this.degrees(cursor);
        Assert.assertEquals(expectedDegrees, actualDegrees);
    }

    private void testDegreesForDenseNodeWithPartiallyDeletedRelChains(boolean modifyInChain, boolean modifyOutChain, boolean modifyLoopChain) {
        int inRelCount = this.randomRelCount();
        int outRelCount = this.randomRelCount();
        int loopRelCount = this.randomRelCount();
        long nodeId = this.createNode(inRelCount, outRelCount, loopRelCount);
        StorageNodeCursor cursor = this.newCursor(nodeId);
        if (modifyInChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.IN);
        }
        if (modifyOutChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.OUT);
        }
        if (modifyLoopChain) {
            this.markRandomRelsInGroupNotInUse(nodeId, TestRelType.LOOP);
        }
        HashSet<TestDegreeItem> expectedDegrees = new HashSet<TestDegreeItem>(Arrays.asList(new TestDegreeItem(this.relTypeId(TestRelType.OUT), (long)outRelCount, 0L), new TestDegreeItem(this.relTypeId(TestRelType.IN), 0L, (long)inRelCount), new TestDegreeItem(this.relTypeId(TestRelType.LOOP), (long)loopRelCount, (long)loopRelCount)));
        Set<TestDegreeItem> actualDegrees = this.degrees(cursor);
        Assert.assertEquals(expectedDegrees, actualDegrees);
    }

    private Set<TestDegreeItem> degrees(StorageNodeCursor nodeCursor) {
        HashSet<TestDegreeItem> degrees = new HashSet<TestDegreeItem>();
        try (StorageRelationshipGroupCursor groups = this.storageReader.allocateRelationshipGroupCursor();){
            groups.init(nodeCursor.nodeReference(), nodeCursor.relationshipGroupReference());
            while (groups.next()) {
                degrees.add(new TestDegreeItem(groups.type(), (long)(groups.outgoingCount() + groups.loopCount()), (long)(groups.incomingCount() + groups.loopCount())));
            }
        }
        return degrees;
    }

    private StorageNodeCursor newCursor(long nodeId) {
        StorageNodeCursor nodeCursor = this.storageReader.allocateNodeCursor();
        nodeCursor.single(nodeId);
        Assert.assertTrue((boolean)nodeCursor.next());
        return nodeCursor;
    }

    private void noNodeChange(long nodeId) {
    }

    private void markRandomRelsNotInUse(long nodeId) {
        for (TestRelType type : TestRelType.values()) {
            this.markRandomRelsInGroupNotInUse(nodeId, type);
        }
    }

    private void markRandomRelsInGroupNotInUse(long nodeId, TestRelType type) {
        NodeRecord node = this.getNodeRecord(nodeId);
        Assert.assertTrue((boolean)node.isDense());
        long relGroupId = node.getNextRel();
        while (relGroupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord relGroup = this.getRelGroupRecord(relGroupId);
            if (type == this.relTypeForId(relGroup.getType())) {
                this.markRandomRelsInChainNotInUse(relGroup.getFirstOut());
                this.markRandomRelsInChainNotInUse(relGroup.getFirstIn());
                this.markRandomRelsInChainNotInUse(relGroup.getFirstLoop());
                return;
            }
            relGroupId = relGroup.getNext();
        }
        throw new IllegalStateException("No relationship group with type: " + type + " found");
    }

    private void markRandomRelsInChainNotInUse(long relId) {
        if (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            boolean isLoopRelationship;
            RelationshipRecord record = this.getRelRecord(relId);
            boolean shouldBeMarked = this.random.nextBoolean();
            if (shouldBeMarked) {
                record.setInUse(false);
                this.update(record);
            }
            this.markRandomRelsInChainNotInUse(record.getFirstNextRel());
            boolean bl = isLoopRelationship = record.getFirstNextRel() == record.getSecondNextRel();
            if (!isLoopRelationship) {
                this.markRandomRelsInChainNotInUse(record.getSecondNextRel());
            }
        }
    }

    private void markRelGroupNotInUse(long nodeId, TestRelType ... types) {
        NodeRecord node = this.getNodeRecord(nodeId);
        Assert.assertTrue((boolean)node.isDense());
        Set typesToRemove = Iterators.asSet((Object[])types);
        long relGroupId = node.getNextRel();
        while (relGroupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord relGroup = this.getRelGroupRecord(relGroupId);
            TestRelType type = this.relTypeForId(relGroup.getType());
            if (typesToRemove.contains(type)) {
                relGroup.setInUse(false);
                this.update(relGroup);
            }
            relGroupId = relGroup.getNext();
        }
    }

    private int relTypeId(TestRelType type) {
        int id = this.relationshipTypeId((RelationshipType)type);
        Assert.assertNotEquals((long)-1L, (long)id);
        return id;
    }

    private long createNode(int inRelCount, int outRelCount, int loopRelCount) {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            int i;
            node = this.db.createNode();
            for (i = 0; i < inRelCount; ++i) {
                Node start = this.db.createNode();
                start.createRelationshipTo(node, (RelationshipType)TestRelType.IN);
            }
            for (i = 0; i < outRelCount; ++i) {
                Node end = this.db.createNode();
                node.createRelationshipTo(end, (RelationshipType)TestRelType.OUT);
            }
            for (i = 0; i < loopRelCount; ++i) {
                node.createRelationshipTo(node, (RelationshipType)TestRelType.LOOP);
            }
            tx.success();
        }
        return node.getId();
    }

    private TestRelType relTypeForId(int id) {
        try {
            return TestRelType.valueOf((String)this.relationshipType(id));
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    private static <R extends AbstractBaseRecord> R getRecord(RecordStore<R> store, long id) {
        return (R)RecordStore.getRecord(store, (long)id, (RecordLoad)RecordLoad.FORCE);
    }

    private NodeRecord getNodeRecord(long id) {
        return (NodeRecord)RecordStorageReaderRelTypesAndDegreeTest.getRecord(this.resolveNeoStores().getNodeStore(), id);
    }

    private RelationshipRecord getRelRecord(long id) {
        return (RelationshipRecord)RecordStorageReaderRelTypesAndDegreeTest.getRecord(this.resolveNeoStores().getRelationshipStore(), id);
    }

    private RelationshipGroupRecord getRelGroupRecord(long id) {
        return (RelationshipGroupRecord)RecordStorageReaderRelTypesAndDegreeTest.getRecord(this.resolveNeoStores().getRelationshipGroupStore(), id);
    }

    private void update(RelationshipGroupRecord record) {
        this.resolveNeoStores().getRelationshipGroupStore().updateRecord((AbstractBaseRecord)record);
    }

    private void update(RelationshipRecord record) {
        this.resolveNeoStores().getRelationshipStore().updateRecord((AbstractBaseRecord)record);
    }

    private NeoStores resolveNeoStores() {
        DependencyResolver resolver = this.db.getDependencyResolver();
        RecordStorageEngine storageEngine = (RecordStorageEngine)resolver.resolveDependency(RecordStorageEngine.class);
        return storageEngine.testAccessNeoStores();
    }

    private int randomRelCount() {
        return 20 + this.random.nextInt(20);
    }
}

