/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.core.DelegatingTokenHolder;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.TransactionRecordState;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.string.UTF8;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.test.rule.ConfigurablePageCacheRule;
import org.neo4j.test.rule.NeoStoreDataSourceRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NeoStoresTest {
    private static final NullLogProvider LOG_PROVIDER = NullLogProvider.getInstance();
    private final PageCacheRule pageCacheRule = new ConfigurablePageCacheRule();
    private final ExpectedException exception = ExpectedException.none();
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory dir = TestDirectory.testDirectory((FileSystemAbstraction)this.fs.get());
    private final NeoStoreDataSourceRule dsRule = new NeoStoreDataSourceRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.exception).around((TestRule)this.pageCacheRule).around((TestRule)this.fs).around((TestRule)this.dir).around((TestRule)this.dsRule);
    private PageCache pageCache;
    private File storeDir;
    private PropertyStore pStore;
    private RelationshipTypeTokenStore rtStore;
    private RelationshipStore relStore;
    private NodeStore nodeStore;
    private NeoStoreDataSource ds;
    private KernelTransaction tx;
    private TransactionState transaction;
    private StorageReader storageReader;
    private TokenHolder propertyKeyTokenHolder;

    @Before
    public void setUpNeoStores() {
        this.storeDir = this.dir.graphDbDir();
        Config config = Config.defaults();
        this.pageCache = this.pageCacheRule.getPageCache(this.fs.get());
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCache, this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        sf.openAllNeoStores(true).close();
        this.propertyKeyTokenHolder = new DelegatingTokenHolder(this::createPropertyKeyToken, "PropertyKey");
    }

    private int createPropertyKeyToken(String name) {
        return (int)this.nextId(PropertyKeyTokenRecord.class);
    }

    @Test
    public void impossibleToGetStoreFromClosedNeoStoresContainer() {
        Config config = Config.defaults();
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCache, this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = sf.openAllNeoStores(true);
        Assert.assertNotNull((Object)neoStores.getMetaDataStore());
        neoStores.close();
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Specified store was already closed.");
        neoStores.getMetaDataStore();
    }

    @Test
    public void notAllowCreateDynamicStoreWithNegativeBlockSize() {
        Config config = Config.defaults();
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCache, this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Block size of dynamic array store should be positive integer.");
        try (NeoStores neoStores = sf.openNeoStores(true, new StoreType[0]);){
            neoStores.createDynamicArrayStore("someStore", IdType.ARRAY_BLOCK, -2);
        }
    }

    @Test
    public void impossibleToGetNotRequestedStore() {
        Config config = Config.defaults();
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCache, this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Specified store was not initialized. Please specify " + StoreType.META_DATA.name() + " as one of the stores types that should be open to be able to use it.");
        try (NeoStores neoStores = sf.openNeoStores(true, new StoreType[]{StoreType.NODE_LABEL});){
            neoStores.getMetaDataStore();
        }
    }

    @Test
    public void testCreateStore() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        long node1 = this.nextId(Node.class);
        this.transaction.nodeDoCreate(node1);
        long node2 = this.nextId(Node.class);
        this.transaction.nodeDoCreate(node2);
        StorageProperty n1prop1 = this.nodeAddProperty(node1, this.index("prop1"), "string1");
        StorageProperty n1prop2 = this.nodeAddProperty(node1, this.index("prop2"), 1);
        StorageProperty n1prop3 = this.nodeAddProperty(node1, this.index("prop3"), true);
        StorageProperty n2prop1 = this.nodeAddProperty(node2, this.index("prop1"), "string2");
        StorageProperty n2prop2 = this.nodeAddProperty(node2, this.index("prop2"), 2);
        StorageProperty n2prop3 = this.nodeAddProperty(node2, this.index("prop3"), false);
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName1 = "relationshiptype1";
        this.transaction.relationshipTypeDoCreateForName(typeName1, relType1);
        int relType2 = (int)this.nextId(RelationshipType.class);
        String typeName2 = "relationshiptype2";
        this.transaction.relationshipTypeDoCreateForName(typeName2, relType2);
        long rel1 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel1, relType1, node1, node2);
        long rel2 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel2, relType2, node2, node1);
        StorageProperty r1prop1 = this.relAddProperty(rel1, this.index("prop1"), "string1");
        StorageProperty r1prop2 = this.relAddProperty(rel1, this.index("prop2"), 1);
        StorageProperty r1prop3 = this.relAddProperty(rel1, this.index("prop3"), true);
        StorageProperty r2prop1 = this.relAddProperty(rel2, this.index("prop1"), "string2");
        StorageProperty r2prop2 = this.relAddProperty(rel2, this.index("prop2"), 2);
        StorageProperty r2prop3 = this.relAddProperty(rel2, this.index("prop3"), false);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.validateNodeRel1(node1, n1prop1, n1prop2, n1prop3, rel1, rel2, relType1, relType2);
        this.validateNodeRel2(node2, n2prop1, n2prop2, n2prop3, rel1, rel2, relType1, relType2);
        this.validateRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.validateRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.deleteRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.deleteRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.deleteNode1(node1, n1prop1, n1prop2, n1prop3);
        this.deleteNode2(node2, n2prop1, n2prop2, n2prop3);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        Assert.assertFalse((boolean)this.nodeExists(node1));
        Assert.assertFalse((boolean)this.nodeExists(node2));
        this.testGetRels(new long[]{rel1, rel2});
        long[] nodeIds = new long[10];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            long id = this.nextId(Relationship.class);
            this.transaction.relationshipDoCreate(id, relType1, nodeIds[i], nodeIds[i + 1]);
            this.transaction.relationshipDoDelete(id, relType1, nodeIds[i], nodeIds[i + 1]);
        }
        for (i = 0; i < 3; ++i) {
            this.transaction.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    private StorageProperty nodeAddProperty(long nodeId, int key, Object value) {
        PropertyKeyValue property = new PropertyKeyValue(key, Values.of((Object)value));
        StorageProperty oldProperty = null;
        try (StorageNodeCursor nodeCursor = this.storageReader.allocateNodeCursor();){
            StorageProperty fetched;
            nodeCursor.single(nodeId);
            if (nodeCursor.next() && (fetched = this.getProperty(key, nodeCursor.propertiesReference())) != null) {
                oldProperty = fetched;
            }
        }
        if (oldProperty == null) {
            this.transaction.nodeDoAddProperty(nodeId, key, property.value());
        } else {
            this.transaction.nodeDoChangeProperty(nodeId, key, property.value());
        }
        return property;
    }

    private StorageProperty relAddProperty(long relationshipId, int key, Object value) {
        PropertyKeyValue property = new PropertyKeyValue(key, Values.of((Object)value));
        Value oldValue = Values.NO_VALUE;
        try (StorageRelationshipScanCursor cursor = this.storageReader.allocateRelationshipScanCursor();){
            StorageProperty fetched;
            cursor.single(relationshipId);
            if (cursor.next() && (fetched = this.getProperty(key, cursor.propertiesReference())) != null) {
                oldValue = fetched.value();
            }
        }
        this.transaction.relationshipDoReplaceProperty(relationshipId, key, oldValue, Values.of((Object)value));
        return property;
    }

    private StorageProperty getProperty(int key, long propertyId) {
        try (StoragePropertyCursor propertyCursor = this.storageReader.allocatePropertyCursor();){
            Value oldValue;
            propertyCursor.init(propertyId);
            if (propertyCursor.next() && (oldValue = propertyCursor.propertyValue()) != null) {
                PropertyKeyValue propertyKeyValue = new PropertyKeyValue(key, oldValue);
                return propertyKeyValue;
            }
        }
        return null;
    }

    @Test
    public void testRels1() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transaction.relationshipTypeDoCreateForName(typeName, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            this.transaction.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            this.deleteRelationships(nodeIds[i]);
            this.transaction.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    private void relDelete(long id) {
        RelationshipVisitor visitor = (relId, type, startNode, endNode) -> this.transaction.relationshipDoDelete(relId, type, startNode, endNode);
        if (!this.transaction.relationshipVisit(id, visitor)) {
            try {
                this.storageReader.relationshipVisit(id, visitor);
            }
            catch (EntityNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testRels2() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transaction.relationshipTypeDoCreateForName(typeName, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeDoCreate(nodeIds[i]);
            this.nodeAddProperty(nodeIds[i], this.index("nisse"), 10 - i);
        }
        for (i = 0; i < 2; ++i) {
            this.transaction.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.transaction.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[0], nodeIds[2]);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            this.deleteRelationships(nodeIds[i]);
            this.transaction.nodeDoDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testRels3() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        this.transaction.relationshipTypeDoCreateForName("relationshiptype1", relType1);
        long[] nodeIds = new long[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeDoCreate(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.transaction.relationshipDoCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i * 2]);
        }
        long rel5 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel5, relType1, nodeIds[0], nodeIds[5]);
        long rel2 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel2, relType1, nodeIds[1], nodeIds[2]);
        long rel3 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel3, relType1, nodeIds[1], nodeIds[3]);
        long rel6 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel6, relType1, nodeIds[1], nodeIds[6]);
        long rel1 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel1, relType1, nodeIds[0], nodeIds[1]);
        long rel4 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel4, relType1, nodeIds[0], nodeIds[4]);
        long rel7 = this.nextId(Relationship.class);
        this.transaction.relationshipDoCreate(rel7, relType1, nodeIds[0], nodeIds[7]);
        this.commitTx();
        this.startTx();
        this.relDelete(rel7);
        this.relDelete(rel4);
        this.relDelete(rel1);
        this.relDelete(rel6);
        this.relDelete(rel3);
        this.relDelete(rel2);
        this.relDelete(rel5);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testProps1() throws Exception {
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        long nodeId = this.nextId(Node.class);
        this.transaction.nodeDoCreate(nodeId);
        this.pStore.nextId();
        StorageProperty prop = this.nodeAddProperty(nodeId, this.index("nisse"), 10);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        StorageProperty prop2 = this.nodeAddProperty(nodeId, prop.propertyKeyId(), 5);
        this.transaction.nodeDoRemoveProperty(nodeId, prop2.propertyKeyId());
        this.transaction.nodeDoDelete(nodeId);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testSetBlockSize() throws Exception {
        File storeDir = this.dir.directory("small_store");
        this.initializeStores(storeDir, MapUtil.stringMap((String[])new String[]{"unsupported.dbms.block_size.strings", "62", "unsupported.dbms.block_size.array_properties", "302"}));
        Assert.assertEquals((long)70L, (long)this.pStore.getStringStore().getRecordSize());
        Assert.assertEquals((long)310L, (long)this.pStore.getArrayStore().getRecordSize());
        this.ds.stop();
    }

    @Test
    public void setVersion() throws Exception {
        FileSystemAbstraction fileSystem = this.fs.get();
        File storeDir = new File("target/test-data/set-version").getAbsoluteFile();
        this.createTestDatabase(fileSystem, storeDir).shutdown();
        Assert.assertEquals((long)0L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)new File(storeDir, "neostore").getAbsoluteFile(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)10L));
        Assert.assertEquals((long)10L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)new File(storeDir, "neostore").getAbsoluteFile(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)12L));
        Config config = Config.defaults();
        StoreFactory sf = new StoreFactory(storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), this.pageCache, fileSystem, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = sf.openAllNeoStores();
        Assert.assertEquals((long)12L, (long)neoStores.getMetaDataStore().getCurrentLogVersion());
        neoStores.close();
    }

    @Test
    public void shouldNotReadNonRecordDataAsRecord() throws Exception {
        FileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = this.dir.graphDbDir();
        StoreFactory factory = NeoStoresTest.newStoreFactory(neoStoreDir, this.pageCache, fileSystem);
        long recordVersion = NeoStoresTest.defaultStoreVersion();
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            metaDataStore.setCreationTime(3L);
            metaDataStore.setRandomNumber(4L);
            metaDataStore.setCurrentLogVersion(5L);
            metaDataStore.setLastCommittedAndClosedTransactionId(6L, 0L, 0L, 43L, 44L);
            metaDataStore.setStoreVersion(recordVersion);
            metaDataStore.setGraphNextProp(8L);
            metaDataStore.setLatestConstraintIntroducingTx(9L);
        }
        File file = new File(neoStoreDir, "neostore");
        try (StoreChannel channel = fileSystem.open(file, OpenMode.READ_WRITE);){
            channel.position(0L);
            channel.write(ByteBuffer.wrap(UTF8.encode((String)"This is some data that is not a record.")));
        }
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)recordVersion);
        var8_7 = null;
        try (NeoStores neoStores = factory.openAllNeoStores();){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            Assert.assertEquals((long)-1L, (long)metaDataStore.getCreationTime());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getRandomNumber());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getCurrentLogVersion());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getLastCommittedTransactionId());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getLastClosedTransactionId());
            Assert.assertEquals((long)recordVersion, (long)metaDataStore.getStoreVersion());
            Assert.assertEquals((long)8L, (long)metaDataStore.getGraphNextProp());
            Assert.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assert.assertArrayEquals((long[])metaDataStore.getLastClosedTransaction(), (long[])new long[]{-1L, 44L, 43L});
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSetLatestConstraintTx() {
        Config config = Config.defaults();
        StoreFactory sf = new StoreFactory(this.dir.directory(), config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = sf.openAllNeoStores(true);
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        Assert.assertEquals((long)0L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        metaDataStore.setLatestConstraintIntroducingTx(10L);
        Assert.assertEquals((long)10L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        neoStores.flush(IOLimiter.UNLIMITED);
        neoStores.close();
        neoStores = sf.openAllNeoStores();
        Assert.assertEquals((long)10L, (long)neoStores.getMetaDataStore().getLatestConstraintIntroducingTx());
        neoStores.close();
    }

    @Test
    public void shouldInitializeTheTxIdToOne() {
        StoreFactory factory = new StoreFactory(new File("graph.db/neostore"), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCache, this.fs.get(), (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        neoStores = factory.openAllNeoStores();
        var3_3 = null;
        try {
            long lastCommittedTransactionId = neoStores.getMetaDataStore().getLastCommittedTransactionId();
            Assert.assertEquals((long)1L, (long)lastCommittedTransactionId);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (neoStores != null) {
                if (var3_3 != null) {
                    try {
                        neoStores.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    neoStores.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowUnderlyingStorageExceptionWhenFailingToLoadStorage() {
        FileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = this.dir.graphDbDir();
        StoreFactory factory = new StoreFactory(neoStoreDir, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), this.pageCache, fileSystem, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        File file = new File(neoStoreDir, "neostore");
        fileSystem.deleteFile(file);
        this.exception.expect(StoreNotFoundException.class);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            neoStores.getMetaDataStore();
        }
    }

    @Test
    public void shouldAddUpgradeFieldsToTheNeoStoreIfNotPresent() throws IOException {
        MetaDataStore metaDataStore;
        FileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = this.dir.graphDbDir();
        StoreFactory factory = NeoStoresTest.newStoreFactory(neoStoreDir, this.pageCache, fileSystem);
        long recordVersion = NeoStoresTest.defaultStoreVersion();
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore2 = neoStores.getMetaDataStore();
            metaDataStore2.setCreationTime(3L);
            metaDataStore2.setRandomNumber(4L);
            metaDataStore2.setCurrentLogVersion(5L);
            metaDataStore2.setLastCommittedAndClosedTransactionId(6L, 42L, 0L, 43L, 44L);
            metaDataStore2.setStoreVersion(recordVersion);
            metaDataStore2.setGraphNextProp(8L);
            metaDataStore2.setLatestConstraintIntroducingTx(9L);
        }
        File file = new File(neoStoreDir, "neostore");
        Assert.assertNotEquals((long)10L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID));
        Assert.assertNotEquals((long)11L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM));
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID, (long)10L);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, (long)11L);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TIME, (long)12L);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            metaDataStore = neoStores.getMetaDataStore();
            Assert.assertEquals((long)3L, (long)metaDataStore.getCreationTime());
            Assert.assertEquals((long)4L, (long)metaDataStore.getRandomNumber());
            Assert.assertEquals((long)5L, (long)metaDataStore.getCurrentLogVersion());
            Assert.assertEquals((long)6L, (long)metaDataStore.getLastCommittedTransactionId());
            Assert.assertEquals((long)recordVersion, (long)metaDataStore.getStoreVersion());
            Assert.assertEquals((long)8L, (long)metaDataStore.getGraphNextProp());
            Assert.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assert.assertEquals((Object)new TransactionId(10L, 11L, 0L), (Object)metaDataStore.getUpgradeTransaction());
            Assert.assertEquals((long)12L, (long)metaDataStore.getUpgradeTime());
            Assert.assertArrayEquals((long[])metaDataStore.getLastClosedTransaction(), (long[])new long[]{6L, 44L, 43L});
        }
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, (long)13L);
        neoStores = factory.openAllNeoStores();
        var8_7 = null;
        try {
            metaDataStore = neoStores.getMetaDataStore();
            Assert.assertEquals((Object)new TransactionId(10L, 11L, 13L), (Object)metaDataStore.getUpgradeTransaction());
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (neoStores != null) {
                if (var8_7 != null) {
                    try {
                        neoStores.close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    neoStores.close();
                }
            }
        }
    }

    @Test
    public void shouldSetHighestTransactionIdWhenNeeded() throws Throwable {
        FileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.mkdirs(this.storeDir);
        StoreFactory factory = new StoreFactory(this.storeDir, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), this.pageCache, fileSystem, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444L, 0L, 16L, 0L);
            store.transactionCommitted(42L, 6666L, 0L);
            Assert.assertEquals((Object)new TransactionId(42L, 6666L, 0L), (Object)store.getLastCommittedTransaction());
            Assert.assertArrayEquals((long[])store.getLastClosedTransaction(), (long[])new long[]{40L, 0L, 16L});
        }
    }

    @Test
    public void shouldNotSetHighestTransactionIdWhenNeeded() throws Throwable {
        FileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.mkdirs(this.storeDir);
        StoreFactory factory = new StoreFactory(this.storeDir, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), this.pageCache, fileSystem, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444L, 0L, 16L, 0L);
            store.transactionCommitted(39L, 3333L, 0L);
            Assert.assertEquals((Object)new TransactionId(40L, 4444L, 0L), (Object)store.getLastCommittedTransaction());
            Assert.assertArrayEquals((long[])store.getLastClosedTransaction(), (long[])new long[]{40L, 0L, 16L});
        }
    }

    @Test
    public void shouldCloseAllTheStoreEvenIfExceptionsAreThrown() throws Exception {
        FileSystemAbstraction fileSystem = this.fs.get();
        Config defaults = Config.defaults((Setting)GraphDatabaseSettings.counts_store_rotation_timeout, (String)"60m");
        StoreFactory factory = new StoreFactory(this.storeDir, defaults, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), this.pageCache, fileSystem, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStore = factory.openAllNeoStores(true);
        CountsTracker counts = neoStore.getCounts();
        counts.start();
        long nextTxId = neoStore.getMetaDataStore().getLastCommittedTransactionId() + 1L;
        AtomicReference exRef = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                counts.rotate(nextTxId);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Throwable e) {
                exRef.set(e);
                throw new RuntimeException(e);
            }
        });
        thread.start();
        ThreadTestUtils.awaitThreadState((Thread)thread, (long)TimeUnit.SECONDS.toMillis(5L), (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[]{Thread.State.WAITING});
        try {
            neoStore.close();
            Assert.fail((String)"should have thrown2");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Cannot stop in state: rotating", (Object)ex.getMessage());
        }
        thread.interrupt();
        thread.join();
        this.pageCache.close();
        Assert.assertNull(exRef.get());
    }

    @Test
    public void isPresentAfterCreatingAllStores() throws Exception {
        FileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.deleteRecursively(this.storeDir);
        DefaultIdGeneratorFactory idFactory = new DefaultIdGeneratorFactory(fileSystem);
        StoreFactory factory = new StoreFactory(this.storeDir, Config.defaults(), (IdGeneratorFactory)idFactory, this.pageCache, fileSystem, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        try (NeoStores ignore = factory.openAllNeoStores(true);){
            Assert.assertTrue((boolean)NeoStores.isStorePresent((PageCache)this.pageCache, (File)this.storeDir));
        }
    }

    @Test
    public void isPresentFalseAfterCreatingAllButLastStoreType() throws Exception {
        FileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.deleteRecursively(this.storeDir);
        DefaultIdGeneratorFactory idFactory = new DefaultIdGeneratorFactory(fileSystem);
        StoreFactory factory = new StoreFactory(this.storeDir, Config.defaults(), (IdGeneratorFactory)idFactory, this.pageCache, fileSystem, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        StoreType[] allStoreTypes = StoreType.values();
        StoreType[] allButLastStoreTypes = Arrays.copyOf(allStoreTypes, allStoreTypes.length - 1);
        try (NeoStores ignore = factory.openNeoStores(true, allButLastStoreTypes);){
            Assert.assertFalse((boolean)NeoStores.isStorePresent((PageCache)this.pageCache, (File)this.storeDir));
        }
    }

    private static long defaultStoreVersion() {
        return MetaDataStore.versionStringToLong((String)RecordFormatSelector.defaultFormat().storeVersion());
    }

    private static StoreFactory newStoreFactory(File neoStoreDir, PageCache pageCache, FileSystemAbstraction fs) {
        RecordFormats recordFormats = RecordFormatSelector.defaultFormat();
        Config config = Config.defaults();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs);
        return new StoreFactory(neoStoreDir, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fs, recordFormats, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
    }

    private void initializeStores(File storeDir, Map<String, String> additionalConfig) throws IOException {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)Config.defaults(additionalConfig));
        this.ds = this.dsRule.getDataSource(storeDir, this.fs.get(), this.pageCache, (DependencyResolver)dependencies);
        this.ds.start();
        NeoStores neoStores = ((RecordStorageEngine)this.ds.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.pStore = neoStores.getPropertyStore();
        this.rtStore = neoStores.getRelationshipTypeTokenStore();
        this.relStore = neoStores.getRelationshipStore();
        this.nodeStore = neoStores.getNodeStore();
        this.storageReader = ((StorageEngine)this.ds.getDependencyResolver().resolveDependency(StorageEngine.class)).newReader();
    }

    private void startTx() throws TransactionFailureException {
        this.tx = (KernelTransaction)this.ds.getKernel().beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
        this.transaction = ((KernelTransactionImplementation)this.tx).txState();
    }

    private void commitTx() throws TransactionFailureException {
        this.tx.success();
        this.tx.close();
    }

    private int index(String key) {
        return this.propertyKeyTokenHolder.getOrCreateId(key);
    }

    private long nextId(Class<?> clazz) {
        NeoStores neoStores = ((RecordStorageEngine)this.ds.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        if (clazz.equals(PropertyKeyTokenRecord.class)) {
            return neoStores.getPropertyKeyTokenStore().nextId();
        }
        if (clazz.equals(RelationshipType.class)) {
            return neoStores.getRelationshipTypeTokenStore().nextId();
        }
        if (clazz.equals(Node.class)) {
            return neoStores.getNodeStore().nextId();
        }
        if (clazz.equals(Relationship.class)) {
            return neoStores.getRelationshipStore().nextId();
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    private void validateNodeRel1(long node, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException, TokenNotFoundException {
        Assert.assertTrue((boolean)this.nodeExists(node));
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        TransactionRecordState.PropertyReceiver<StorageProperty> receiver = this.newPropertyReceiver(props);
        this.nodeLoadProperties(node, receiver);
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)this.pStore, (long)id);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value().asObject());
                this.nodeAddProperty(node, prop1.propertyKeyId(), "-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value().asObject());
                this.nodeAddProperty(node, prop2.propertyKeyId(), -1);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value().asObject());
                this.nodeAddProperty(node, prop3.propertyKeyId(), false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = this.validateAndCountRelationships(node, rel1, rel2, relType1, relType2);
        Assert.assertEquals((long)2L, (long)count);
    }

    private int validateAndCountRelationships(long node, long rel1, long rel2, int relType1, int relType2) throws IOException {
        int count = 0;
        try (KernelStatement statement = (KernelStatement)this.tx.acquireStatement();
             StorageNodeCursor nodeCursor = this.allocateNodeCursor(node);){
            Assert.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                while (relationships.next()) {
                    long rel = relationships.relationshipReference();
                    if (rel == rel1) {
                        Assert.assertEquals((long)node, (long)relationships.sourceNodeReference());
                        Assert.assertEquals((long)relType1, (long)relationships.type());
                    } else if (rel == rel2) {
                        Assert.assertEquals((long)node, (long)relationships.targetNodeReference());
                        Assert.assertEquals((long)relType2, (long)relationships.type());
                    } else {
                        throw new IOException();
                    }
                    ++count;
                }
            }
        }
        return count;
    }

    private StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor(StorageNodeCursor node) {
        StorageRelationshipTraversalCursor relationships = this.storageReader.allocateRelationshipTraversalCursor();
        relationships.init(node.nodeReference(), node.allRelationshipsReference());
        return relationships;
    }

    private StorageNodeCursor allocateNodeCursor(long nodeId) {
        StorageNodeCursor nodeCursor = this.storageReader.allocateNodeCursor();
        nodeCursor.single(nodeId);
        return nodeCursor;
    }

    private TransactionRecordState.PropertyReceiver<StorageProperty> newPropertyReceiver(Map<Integer, Pair<StorageProperty, Long>> props) {
        return (property, propertyRecordId) -> props.put(property.propertyKeyId(), Pair.of((Object)property, (Object)propertyRecordId));
    }

    private void validateNodeRel2(long node, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException, RuntimeException, TokenNotFoundException {
        Assert.assertTrue((boolean)this.nodeExists(node));
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.nodeLoadProperties(node, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)this.pStore, (long)id);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value().asObject());
                this.nodeAddProperty(node, prop1.propertyKeyId(), "-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value().asObject());
                this.nodeAddProperty(node, prop2.propertyKeyId(), -2);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value().asObject());
                this.nodeAddProperty(node, prop3.propertyKeyId(), true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        try (KernelStatement statement = (KernelStatement)this.tx.acquireStatement();
             StorageNodeCursor nodeCursor = this.allocateNodeCursor(node);){
            Assert.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                while (relationships.next()) {
                    long rel = relationships.relationshipReference();
                    if (rel == rel1) {
                        Assert.assertEquals((long)node, (long)relationships.targetNodeReference());
                        Assert.assertEquals((long)relType1, (long)relationships.type());
                    } else if (rel == rel2) {
                        Assert.assertEquals((long)node, (long)relationships.sourceNodeReference());
                        Assert.assertEquals((long)relType2, (long)relationships.type());
                    } else {
                        throw new IOException();
                    }
                    ++count;
                }
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private boolean nodeExists(long nodeId) {
        try (StorageNodeCursor node = this.allocateNodeCursor(nodeId);){
            boolean bl = node.next();
            return bl;
        }
    }

    private void validateRel1(long rel, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long firstNode, long secondNode, int relType) throws IOException, TokenNotFoundException {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.relLoadProperties(rel, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)this.pStore, (long)id);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value().asObject());
                this.relAddProperty(rel, prop1.propertyKeyId(), "-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value().asObject());
                this.relAddProperty(rel, prop2.propertyKeyId(), -1);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value().asObject());
                this.relAddProperty(rel, prop3.propertyKeyId(), false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void assertRelationshipData(long rel, long firstNode, long secondNode, int relType) {
        try {
            this.storageReader.relationshipVisit(rel, (relId, type, startNode, endNode) -> {
                Assert.assertEquals((long)firstNode, (long)startNode);
                Assert.assertEquals((long)secondNode, (long)endNode);
                Assert.assertEquals((long)relType, (long)type);
            });
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateRel2(long rel, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long firstNode, long secondNode, int relType) throws IOException, TokenNotFoundException {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.relLoadProperties(rel, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)RecordStore.getRecord((RecordStore)this.pStore, (long)id);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value().asObject());
                this.relAddProperty(rel, prop1.propertyKeyId(), "-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value().asObject());
                this.relAddProperty(rel, prop2.propertyKeyId(), -2);
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value().asObject());
                this.relAddProperty(rel, prop3.propertyKeyId(), true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void validateRelTypes(int relType1, int relType2) throws IOException {
        NamedToken data = this.rtStore.getToken(relType1);
        Assert.assertEquals((long)relType1, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype1", (Object)data.name());
        data = this.rtStore.getToken(relType2);
        Assert.assertEquals((long)relType2, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype2", (Object)data.name());
        List allData = this.rtStore.getTokens();
        Assert.assertEquals((long)2L, (long)allData.size());
        for (int i = 0; i < 2; ++i) {
            if (((NamedToken)allData.get(i)).id() == relType1) {
                Assert.assertEquals((long)relType1, (long)((NamedToken)allData.get(i)).id());
                Assert.assertEquals((Object)"relationshiptype1", (Object)((NamedToken)allData.get(i)).name());
                continue;
            }
            if (((NamedToken)allData.get(i)).id() == relType2) {
                Assert.assertEquals((long)relType2, (long)((NamedToken)allData.get(i)).id());
                Assert.assertEquals((Object)"relationshiptype2", (Object)((NamedToken)allData.get(i)).name());
                continue;
            }
            throw new IOException();
        }
    }

    private void deleteRel1(long rel, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long firstNode, long secondNode, int relType) throws Exception {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.relLoadProperties(rel, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value().asObject());
                this.transaction.relationshipDoRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.relLoadProperties(rel, propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.relDelete(rel);
        this.assertHasRelationships(firstNode);
        this.assertHasRelationships(secondNode);
    }

    private void deleteRel2(long rel, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3, long firstNode, long secondNode, int relType) throws Exception {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.relLoadProperties(rel, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value().asObject());
                this.transaction.relationshipDoRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.relLoadProperties(rel, propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.relDelete(rel);
        this.assertHasRelationships(firstNode);
        this.assertHasRelationships(secondNode);
    }

    private void assertHasRelationships(long node) {
        try (KernelStatement statement = (KernelStatement)this.tx.acquireStatement();
             StorageNodeCursor nodeCursor = this.allocateNodeCursor(node);){
            Assert.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                Assert.assertTrue((boolean)relationships.next());
            }
        }
    }

    private void deleteNode1(long node, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3) throws IOException, TokenNotFoundException {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.nodeLoadProperties(node, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value().asObject());
                this.transaction.nodeDoRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.nodeLoadProperties(node, propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertHasRelationships(node);
        this.transaction.nodeDoDelete(node);
    }

    private void deleteNode2(long node, StorageProperty prop1, StorageProperty prop2, StorageProperty prop3) throws IOException, TokenNotFoundException {
        HashMap<Integer, Pair<StorageProperty, Long>> props = new HashMap<Integer, Pair<StorageProperty, Long>>();
        this.nodeLoadProperties(node, this.newPropertyReceiver(props));
        int count = 0;
        Iterator iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            int keyId = (Integer)iterator.next();
            long id = (Long)((Pair)props.get(keyId)).other();
            PropertyRecord record = (PropertyRecord)this.pStore.getRecord(id, (AbstractBaseRecord)this.pStore.newRecord(), RecordLoad.NORMAL);
            PropertyBlock block = record.getPropertyBlock(((StorageProperty)((Pair)props.get(keyId)).first()).propertyKeyId());
            PropertyKeyValue data = block.newPropertyKeyValue(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value().asObject());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)this.propertyKeyTokenHolder.getTokenById(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value().asObject());
                this.transaction.nodeDoRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.nodeLoadProperties(node, propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertHasRelationships(node);
        this.transaction.nodeDoDelete(node);
    }

    private void testGetRels(long[] relIds) {
        for (long relId : relIds) {
            try (StorageRelationshipScanCursor relationship = this.storageReader.allocateRelationshipScanCursor();){
                relationship.single(relId);
                Assert.assertFalse((boolean)relationship.next());
            }
        }
    }

    private void deleteRelationships(long nodeId) {
        try (KernelStatement statement = (KernelStatement)this.tx.acquireStatement();
             StorageNodeCursor nodeCursor = this.allocateNodeCursor(nodeId);){
            Assert.assertTrue((boolean)nodeCursor.next());
            try (StorageRelationshipTraversalCursor relationships = this.allocateRelationshipTraversalCursor(nodeCursor);){
                while (relationships.next()) {
                    this.relDelete(relationships.relationshipReference());
                }
            }
        }
    }

    private GraphDatabaseService createTestDatabase(FileSystemAbstraction fileSystem, File storeDir) {
        return new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fileSystem)).newImpermanentDatabase(storeDir);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver> void nodeLoadProperties(long nodeId, RECEIVER receiver) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.getRecord(nodeId, this.nodeStore.newRecord(), RecordLoad.NORMAL);
        this.loadProperties(nodeRecord.getNextProp(), receiver);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver> void relLoadProperties(long relId, RECEIVER receiver) {
        RelationshipRecord relRecord = (RelationshipRecord)this.relStore.getRecord(relId, this.relStore.newRecord(), RecordLoad.NORMAL);
        this.loadProperties(relRecord.getNextProp(), receiver);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver> void loadProperties(long nextProp, RECEIVER receiver) {
        Collection chain = this.pStore.getPropertyRecordChain(nextProp);
        this.receivePropertyChain(receiver, chain);
    }

    private <RECEIVER extends TransactionRecordState.PropertyReceiver> void receivePropertyChain(RECEIVER receiver, Collection<PropertyRecord> chain) {
        if (chain != null) {
            for (PropertyRecord propRecord : chain) {
                for (PropertyBlock propBlock : propRecord) {
                    receiver.receive((StorageProperty)propBlock.newPropertyKeyValue(this.pStore), propRecord.getId());
                }
            }
        }
    }

    private static class CountingPropertyReceiver
    implements TransactionRecordState.PropertyReceiver<StorageProperty> {
        private int count;

        private CountingPropertyReceiver() {
        }

        public void receive(StorageProperty property, long propertyRecordId) {
            ++this.count;
        }
    }
}

