/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RecordStorageEngineRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Workers;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexWorkSyncTransactionApplicationStressIT {
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final RecordStorageEngineRule storageEngineRule = new RecordStorageEngineRule();
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule).around((TestRule)this.storageEngineRule);
    private final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});

    @Test
    public void shouldApplyIndexUpdatesInWorkSyncedBatches() throws Exception {
        long duration = (Long)TimeUtil.parseTimeMillis.apply(System.getProperty(this.getClass().getName() + ".duration", "2s"));
        int numThreads = Integer.getInteger(this.getClass().getName() + ".numThreads", Runtime.getRuntime().availableProcessors());
        DefaultFileSystemAbstraction fs = (DefaultFileSystemAbstraction)this.fileSystemRule.get();
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        FusionIndexProvider indexProvider = NativeLuceneFusionIndexProviderFactory20.create((PageCache)pageCache, (File)this.directory.graphDbDir(), (FileSystemAbstraction)fs, (IndexProvider.Monitor)IndexProvider.Monitor.EMPTY, (Config)Config.defaults(), (OperationalMode)OperationalMode.single, (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.IMMEDIATE);
        RecordStorageEngine storageEngine = this.storageEngineRule.getWith((FileSystemAbstraction)fs, pageCache).storeDirectory(this.directory.directory()).indexProvider((IndexProvider)indexProvider).build();
        storageEngine.apply((CommandsToApply)IndexWorkSyncTransactionApplicationStressIT.tx(Collections.singletonList(Commands.createIndexRule((IndexProvider.Descriptor)NativeLuceneFusionIndexProviderFactory20.DESCRIPTOR, (long)1L, (LabelSchemaDescriptor)this.descriptor))), TransactionApplicationMode.EXTERNAL);
        Dependencies dependencies = new Dependencies();
        storageEngine.satisfyDependencies((DependencySatisfier)dependencies);
        IndexProxy index = ((IndexingService)dependencies.resolveDependency(IndexingService.class)).getIndexProxy((SchemaDescriptor)this.descriptor);
        this.awaitOnline(index);
        Workers workers = new Workers(this.getClass().getSimpleName());
        AtomicBoolean end = new AtomicBoolean();
        for (int i = 0; i < numThreads; ++i) {
            workers.start((Runnable)new Worker(i, end, storageEngine, 10, index));
        }
        Thread.sleep(duration);
        end.set(true);
        workers.awaitAndThrowOnError();
    }

    private void awaitOnline(IndexProxy index) throws InterruptedException {
        while (index.getState() == InternalIndexState.POPULATING) {
            Thread.sleep(10L);
        }
    }

    private static Value propertyValue(int id, int progress) {
        return Values.of((Object)(id + "_" + progress));
    }

    private static TransactionToApply tx(Collection<StorageCommand> commands) {
        TransactionToApply tx = new TransactionToApply(Commands.transactionRepresentation(commands));
        tx.commitment(Commitment.NO_COMMITMENT, 0L);
        return tx;
    }

    private static class NodeVisitor
    implements Visitor<StorageCommand, IOException> {
        long nodeId;

        private NodeVisitor() {
        }

        public boolean visit(StorageCommand element) {
            if (element instanceof Command.NodeCommand) {
                this.nodeId = ((Command.NodeCommand)element).getKey();
            }
            return false;
        }

        public NodeVisitor clear() {
            this.nodeId = -1L;
            return this;
        }
    }

    private class Worker
    implements Runnable {
        private final int id;
        private final AtomicBoolean end;
        private final RecordStorageEngine storageEngine;
        private final NodeStore nodeIds;
        private final int batchSize;
        private final IndexProxy index;
        private final CommandCreationContext commandCreationContext;
        private int i;
        private int base;

        Worker(int id, AtomicBoolean end, RecordStorageEngine storageEngine, int batchSize, IndexProxy index) {
            this.id = id;
            this.end = end;
            this.storageEngine = storageEngine;
            this.batchSize = batchSize;
            this.index = index;
            NeoStores neoStores = this.storageEngine.testAccessNeoStores();
            this.nodeIds = neoStores.getNodeStore();
            this.commandCreationContext = storageEngine.allocateCommandCreationContext();
        }

        @Override
        public void run() {
            try {
                TransactionQueue queue = new TransactionQueue(this.batchSize, (tx, last) -> {
                    this.storageEngine.apply((CommandsToApply)tx, TransactionApplicationMode.EXTERNAL);
                    this.verifyIndex(tx);
                    this.base += this.batchSize;
                });
                while (!this.end.get()) {
                    queue.queue(this.createNodeAndProperty(this.i));
                    ++this.i;
                }
                queue.empty();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.commandCreationContext.close();
            }
        }

        private TransactionToApply createNodeAndProperty(int progress) throws Exception {
            TxState txState = new TxState();
            long nodeId = this.nodeIds.nextId();
            txState.nodeDoCreate(nodeId);
            txState.nodeDoAddLabel((long)IndexWorkSyncTransactionApplicationStressIT.this.descriptor.getLabelId(), nodeId);
            txState.nodeDoAddProperty(nodeId, IndexWorkSyncTransactionApplicationStressIT.this.descriptor.getPropertyId(), IndexWorkSyncTransactionApplicationStressIT.propertyValue(this.id, progress));
            ArrayList commands = new ArrayList();
            try (StorageReader statement = this.storageEngine.newReader();){
                this.storageEngine.createCommands(commands, (ReadableTransactionState)txState, statement, null, 0L, TxStateVisitor.NO_DECORATION);
            }
            return IndexWorkSyncTransactionApplicationStressIT.tx(commands);
        }

        private void verifyIndex(TransactionToApply tx) throws Exception {
            try (IndexReader reader = this.index.newReader();){
                NodeVisitor visitor = new NodeVisitor();
                int i = 0;
                while (tx != null) {
                    tx.transactionRepresentation().accept((Visitor)visitor.clear());
                    Value propertyValue = IndexWorkSyncTransactionApplicationStressIT.propertyValue(this.id, this.base + i);
                    IndexQuery.ExactPredicate query = IndexQuery.exact((int)IndexWorkSyncTransactionApplicationStressIT.this.descriptor.getPropertyId(), (Object)propertyValue);
                    PrimitiveLongResourceIterator hits = reader.query(new IndexQuery[]{query});
                    Assert.assertEquals((String)("Index doesn't contain " + visitor.nodeId + " " + propertyValue), (long)visitor.nodeId, (long)hits.next());
                    Assert.assertFalse((boolean)hits.hasNext());
                    tx = tx.next();
                    ++i;
                }
            }
        }
    }
}

