/*
 * Decompiled with CFR 0.152.
 */
package synchronization;

import java.io.OutputStream;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class ConcurrentChangesOnEntitiesTest {
    private final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.suppressOutput).around((TestRule)this.testDirectory);
    private final CyclicBarrier barrier = new CyclicBarrier(2);
    private final AtomicReference<Exception> ex = new AtomicReference();
    private GraphDatabaseService db;

    @Before
    public void setup() {
        this.db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).newGraphDatabase();
    }

    @Test
    public void addConcurrentlySameLabelToANode() throws Throwable {
        long nodeId = this.initWithNode(this.db);
        Thread t1 = this.newThreadForNodeAction(nodeId, node -> node.addLabel(Label.label((String)"A")));
        Thread t2 = this.newThreadForNodeAction(nodeId, node -> node.addLabel(Label.label((String)"A")));
        this.startAndWait(t1, t2);
        this.db.shutdown();
        this.assertDatabaseConsistent();
    }

    @Test
    public void setConcurrentlySamePropertyWithDifferentValuesOnANode() throws Throwable {
        long nodeId = this.initWithNode(this.db);
        Thread t1 = this.newThreadForNodeAction(nodeId, node -> node.setProperty("a", (Object)0.788));
        Thread t2 = this.newThreadForNodeAction(nodeId, node -> node.setProperty("a", (Object)new double[]{0.999, 0.77}));
        this.startAndWait(t1, t2);
        this.db.shutdown();
        this.assertDatabaseConsistent();
    }

    @Test
    public void setConcurrentlySamePropertyWithDifferentValuesOnARelationship() throws Throwable {
        long relId = this.initWithRel(this.db);
        Thread t1 = this.newThreadForRelationshipAction(relId, relationship -> relationship.setProperty("a", (Object)0.788));
        Thread t2 = this.newThreadForRelationshipAction(relId, relationship -> relationship.setProperty("a", (Object)new double[]{0.999, 0.77}));
        this.startAndWait(t1, t2);
        this.db.shutdown();
        this.assertDatabaseConsistent();
    }

    private long initWithNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node theNode = db.createNode();
            long id = theNode.getId();
            tx.success();
            long l = id;
            return l;
        }
    }

    private long initWithRel(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("a", (Object)"prop");
            Relationship rel = node.createRelationshipTo(db.createNode(), RelationshipType.withName((String)"T"));
            long id = rel.getId();
            tx.success();
            long l = id;
            return l;
        }
    }

    private Thread newThreadForNodeAction(long nodeId, Consumer<Node> nodeConsumer) {
        return new Thread(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = this.db.getNodeById(nodeId);
                this.barrier.await();
                nodeConsumer.accept(node);
                tx.success();
            }
            catch (Exception e) {
                this.ex.set(e);
            }
        });
    }

    private Thread newThreadForRelationshipAction(long relationshipId, Consumer<Relationship> relConsumer) {
        return new Thread(() -> {
            try (Transaction tx = this.db.beginTx();){
                Relationship relationship = this.db.getRelationshipById(relationshipId);
                this.barrier.await();
                relConsumer.accept(relationship);
                tx.success();
            }
            catch (Exception e) {
                this.ex.set(e);
            }
        });
    }

    private void startAndWait(Thread t1, Thread t2) throws Exception {
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.ex.get() != null) {
            throw this.ex.get();
        }
    }

    private void assertDatabaseConsistent() {
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out);
        try {
            ConsistencyCheckService.Result result = new ConsistencyCheckService().runFullConsistencyCheck(this.testDirectory.graphDbDir(), Config.defaults(), ProgressMonitorFactory.textual((OutputStream)System.err), (LogProvider)logProvider, false);
            Assert.assertTrue((boolean)result.isSuccessful());
        }
        catch (ConsistencyCheckIncompleteException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

