/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public abstract class IndexAccessorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    protected IndexAccessor accessor;
    private Map<Long, Value[]> committedValues = new HashMap<Long, Value[]>();

    public IndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Before
    public void before() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexPopulator populator = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig);
        populator.create();
        populator.close(true);
        this.accessor = this.indexProvider.getOnlineAccessor(this.descriptor, indexSamplingConfig);
    }

    @After
    public void after() {
        try {
            this.testSuite.consistencyCheck(this.accessor);
        }
        finally {
            this.accessor.drop();
            this.accessor.close();
        }
    }

    /*
     * Exception decompiling
     */
    protected List<Long> query(IndexQuery ... predicates) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean passesFilter(long entityId, IndexQuery[] predicates) {
        if (predicates.length == 1 && predicates[0] instanceof IndexQuery.ExistsPredicate) {
            return true;
        }
        Value[] values = this.committedValues.get(entityId);
        for (int i = 0; i < values.length; ++i) {
            IndexQuery predicate = predicates[i];
            if (predicate.valueGroup() != ValueGroup.GEOMETRY && predicate.valueGroup() != ValueGroup.GEOMETRY_ARRAY && (predicate.valueGroup() != ValueGroup.NUMBER || this.testSuite.supportFullValuePrecisionForNumbers()) || predicates[i].acceptsValue(values[i])) continue;
            return false;
        }
        return true;
    }

    void updateAndCommit(Collection<IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            block13: for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
                switch (update.updateMode()) {
                    case ADDED: 
                    case CHANGED: {
                        this.committedValues.put(update.getEntityId(), update.values());
                        continue block13;
                    }
                    case REMOVED: {
                        this.committedValues.remove(update.getEntityId());
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Unknown update mode of " + update);
            }
        }
    }
}

