/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public abstract class SimpleIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public SimpleIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Test
    public void testIndexSeekByPrefix() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"A"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apA"}), IndexQueryHelper.add((long)5L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"b"})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"A")}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"ba")}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
    }

    @Test
    public void testIndexSeekByPrefixOnNonStrings() throws Exception {
        this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"2a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{2L}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{20L})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"2")}), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
    }

    @Test
    public void testIndexRangeSeekByDateTimeWithSneakyZones() throws Exception {
        DateTimeValue d1 = DateTimeValue.datetime((long)9999L, (long)100L, (ZoneId)ZoneId.of("+18:00"));
        DateTimeValue d4 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("UTC"));
        DateTimeValue d5 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+01:00"));
        DateTimeValue d6 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("Europe/Stockholm"));
        DateTimeValue d7 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+03:00"));
        DateTimeValue d8 = DateTimeValue.datetime((long)10000L, (long)101L, (ZoneId)ZoneId.of("UTC"));
        this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{d1}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{d4}), IndexQueryHelper.add((long)5L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{d5}), IndexQueryHelper.add((long)6L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{d6}), IndexQueryHelper.add((long)7L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{d7}), IndexQueryHelper.add((long)8L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{d8})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Value)d4, (boolean)true, (Value)d7, (boolean)true)}), (Matcher)Matchers.contains((Object[])new Long[]{4L, 5L, 6L, 7L}));
    }

    @Test
    public void testIndexRangeSeekWithSpatial() throws Exception {
        Assume.assumeTrue((boolean)this.testSuite.supportsSpatial());
        PointValue p1 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-180.0, -1.0});
        PointValue p2 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-180.0, 1.0});
        PointValue p3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{p1}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{p2}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{p3})));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Value)p1, (boolean)true, (Value)p2, (boolean)true)}), (Matcher)Matchers.contains((Object[])new Long[]{1L, 2L}));
    }

    @Test
    public void shouldUpdateWithAllValues() throws Exception {
        List<IndexEntryUpdate<?>> updates = this.updates(this.valueSet1);
        this.updateAndCommit(updates);
        int propertyKeyId = this.descriptor.schema().getPropertyId();
        for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : this.valueSet1) {
            List<Long> result = this.query(new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
            Assert.assertThat(result, (Matcher)Matchers.equalTo(Collections.singletonList(entry.nodeId)));
        }
    }

    @Test
    public void shouldScanAllValues() throws Exception {
        List<IndexEntryUpdate<?>> updates = this.updates(this.valueSet1);
        this.updateAndCommit(updates);
        Object[] allNodes = (Long[])this.valueSet1.stream().map(x -> x.nodeId).toArray(Long[]::new);
        int propertyKeyId = this.descriptor.schema().getPropertyId();
        List<Long> result = this.query(new IndexQuery[]{IndexQuery.exists((int)propertyKeyId)});
        Assert.assertThat(result, (Matcher)Matchers.containsInAnyOrder((Object[])allNodes));
    }

    @Test
    public void testIndexRangeSeekByNumber() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextNumberValue());
    }

    @Test
    public void testIndexRangeSeekByText() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextTextValue());
    }

    @Test
    public void testIndexRangeSeekByDateTime() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextDateTimeValue());
    }

    @Test
    public void testIndexRangeSeekByLocalDateTime() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextLocalDateTimeValue());
    }

    @Test
    public void testIndexRangeSeekByDate() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextDateValue());
    }

    @Test
    public void testIndexRangeSeekByTime() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextTimeValue());
    }

    @Test
    public void testIndexRangeSeekByLocalTime() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextLocalTimeValue());
    }

    @Test
    public void testIndexRangeSeekByDuration() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextDuration());
    }

    @Test
    public void testIndexRangeSeekByPeriod() throws Exception {
        this.testIndexRangeSeek(() -> this.random.randomValues().nextPeriod());
    }

    @Test
    public void testIndexRangeSeekByZonedDateTimeArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextDateTimeArray());
    }

    @Test
    public void testIndexRangeSeekByLocalDateTimeArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextLocalDateTimeArray());
    }

    @Test
    public void testIndexRangeSeekByDateArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextDateArray());
    }

    @Test
    public void testIndexRangeSeekByZonedTimeArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextTimeArray());
    }

    @Test
    public void testIndexRangeSeekByLocalTimeArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextLocalTimeArray());
    }

    @Test
    public void testIndexRangeSeekByDurationArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextDurationArray());
    }

    @Test
    public void testIndexRangeSeekByTextArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextBasicMultilingualPlaneStringArray());
    }

    @Test
    public void testIndexRangeSeekByBooleanArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextBooleanArray());
    }

    @Test
    public void testIndexRangeSeekByByteArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextByteArray());
    }

    @Test
    public void testIndexRangeSeekByShortArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextShortArray());
    }

    @Test
    public void testIndexRangeSeekByIntArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextIntArray());
    }

    @Test
    public void testIndexRangeSeekByLongArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextLongArray());
    }

    @Test
    public void testIndexRangeSeekByFloatArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextFloatArray());
    }

    @Test
    public void testIndexRangeSeekByDoubleArray() throws Exception {
        this.testIndexRangeSeekArray(() -> this.random.randomValues().nextDoubleArray());
    }

    private void testIndexRangeSeekArray(Supplier<ArrayValue> generator) throws Exception {
        Assume.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries());
        this.testIndexRangeSeek(generator);
    }

    private void testIndexRangeSeek(Supplier<? extends Value> generator) throws Exception {
        int i;
        int count = this.random.nextInt(5, 10);
        ArrayList<Value> values = new ArrayList<Value>();
        ArrayList updates = new ArrayList();
        HashSet<Value> duplicateCheck = new HashSet<Value>();
        for (i = 0; i < count; ++i) {
            Value value;
            while (!duplicateCheck.add(value = generator.get())) {
            }
            values.add(value);
        }
        values.sort((Comparator<Value>)Values.COMPARATOR);
        for (i = 0; i < count; ++i) {
            updates.add(IndexQueryHelper.add((long)(i + 1), (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{values.get(i)}));
        }
        this.updateAndCommit(updates);
        for (int f = 0; f < values.size(); ++f) {
            for (int t = f; t < values.size(); ++t) {
                Value from = (Value)values.get(f);
                Value to = (Value)values.get(t);
                for (boolean fromInclusive : new boolean[]{true, false}) {
                    for (boolean toInclusive : new boolean[]{true, false}) {
                        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive)}), (Matcher)Matchers.equalTo(this.ids(f, fromInclusive, t, toInclusive)));
                    }
                }
            }
        }
    }

    private List<Long> ids(int fromIndex, boolean fromInclusive, int toIndex, boolean toInclusive) {
        ArrayList<Long> ids = new ArrayList<Long>();
        int from = fromInclusive ? fromIndex : fromIndex + 1;
        int to = toInclusive ? toIndex : toIndex - 1;
        for (int i = from; i <= to; ++i) {
            ids.add(Long.valueOf(i + 1));
        }
        return ids;
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends SimpleIndexAccessorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, TestIndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }

        @Test
        public void testIndexSeekAndScan() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"b"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"c"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends SimpleIndexAccessorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, TestIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }

        @Test
        public void testIndexSeekAndScan() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"b"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        }

        @Test
        public void testIndexRangeSeekByNumberWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{-5}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{-5}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{0}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{5}), IndexQueryHelper.add((long)5L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{5})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)5, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-3, (boolean)true, (Number)-1, (boolean)true)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)4, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-4, (boolean)true, (Number)5, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)-5, (boolean)true, (Number)5, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        }

        @Test
        public void testIndexRangeSeekByStringWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"Anna"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"Anna"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"Bob"}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"William"}), IndexQueryHelper.add((long)5L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"William"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)false, (String)"William", (boolean)false)}), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Arabella", (boolean)false, (String)"Bob", (boolean)false)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)true, (String)"William", (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)false, (String)"William", (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"Anna", (boolean)true, (String)"William", (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        }

        @Test
        public void testIndexRangeSeekByDateWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(DateValue.epochDate((long)100L), DateValue.epochDate((long)101L), DateValue.epochDate((long)200L), DateValue.epochDate((long)300L));
        }

        @Test
        public void testIndexRangeSeekByLocalDateTimeWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(LocalDateTimeValue.localDateTime((long)1000L, (long)10L), LocalDateTimeValue.localDateTime((long)1000L, (long)11L), LocalDateTimeValue.localDateTime((long)2000L, (long)10L), LocalDateTimeValue.localDateTime((long)3000L, (long)10L));
        }

        @Test
        public void testIndexRangeSeekByDateTimeWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(DateTimeValue.datetime((long)1000L, (long)10L, (ZoneOffset)ZoneOffset.UTC), DateTimeValue.datetime((long)1000L, (long)11L, (ZoneOffset)ZoneOffset.UTC), DateTimeValue.datetime((long)2000L, (long)10L, (ZoneOffset)ZoneOffset.UTC), DateTimeValue.datetime((long)3000L, (long)10L, (ZoneOffset)ZoneOffset.UTC));
        }

        @Test
        public void testIndexRangeSeekByLocalTimeWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(LocalTimeValue.localTime((long)1000L), LocalTimeValue.localTime((long)1001L), LocalTimeValue.localTime((long)2000L), LocalTimeValue.localTime((long)3000L));
        }

        @Test
        public void testIndexRangeSeekByTimeWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(TimeValue.time((long)1000L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)1001L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)2000L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)3000L, (ZoneOffset)ZoneOffset.UTC));
        }

        @Test
        public void testIndexRangeSeekByTimeWithZonesAndDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(TimeValue.time((int)20, (int)31, (int)53, (int)4, (ZoneOffset)ZoneOffset.of("+17:02")), TimeValue.time((int)20, (int)31, (int)54, (int)3, (ZoneOffset)ZoneOffset.of("+17:02")), TimeValue.time((int)19, (int)31, (int)54, (int)2, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((int)18, (int)23, (int)27, (int)1, (ZoneOffset)ZoneOffset.of("-18:00")));
        }

        @Test
        public void testIndexRangeSeekByDurationWithDuplicates() throws Exception {
            this.testIndexRangeSeekWithDuplicates(DurationValue.duration((long)1L, (long)1L, (long)1L, (long)1L), DurationValue.duration((long)1L, (long)1L, (long)1L, (long)2L), DurationValue.duration((long)2L, (long)1L, (long)1L, (long)1L), DurationValue.duration((long)3L, (long)1L, (long)1L, (long)1L));
        }

        private <VALUE extends Value> void testIndexRangeSeekWithDuplicates(VALUE v1, VALUE v2, VALUE v3, VALUE v4) throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{v1}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{v1}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{v3}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{v4}), IndexQueryHelper.add((long)5L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{v4})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, v1, (boolean)false, v4, (boolean)false)}), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, v2, (boolean)false, v3, (boolean)false)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, v1, (boolean)true, v4, (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, v1, (boolean)false, v4, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)1, v1, (boolean)true, v4, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        }

        @Test
        public void testIndexRangeSeekByPrefixWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"A"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)5L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apa"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"apa")}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
        }

        @Test
        public void testIndexFullSearchWithDuplicates() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"A"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)5L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apalong"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringContains((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringContains((int)1, (String)"apa")}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringContains((int)1, (String)"apa*")}), (Matcher)Matchers.equalTo(Collections.emptyList()));
        }

        @Test
        public void testIndexEndsWithWithDuplicated() throws Exception {
            this.updateAndCommit(Arrays.asList(IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"a"}), IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"A"}), IndexQueryHelper.add((long)3L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)4L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apa"}), IndexQueryHelper.add((long)5L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"longapa"}), IndexQueryHelper.add((long)6L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{"apalong"})));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringSuffix((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringSuffix((int)1, (String)"apa")}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringSuffix((int)1, (String)"apa*")}), (Matcher)Matchers.equalTo(Collections.emptyList()));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringSuffix((int)1, (String)"")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L)));
        }

        @Test
        public void testIndexShouldHandleLargeAmountOfDuplicatesString() throws Exception {
            this.doTestShouldHandleLargeAmountOfDuplicates("this is a semi-long string that will need to be split");
        }

        @Test
        public void testIndexShouldHandleLargeAmountOfDuplicatesStringArray() throws Exception {
            Value arrayValue = this.nextRandomValidArrayValue();
            this.doTestShouldHandleLargeAmountOfDuplicates(arrayValue);
        }

        private void doTestShouldHandleLargeAmountOfDuplicates(Object value) throws Exception {
            ArrayList updates = new ArrayList();
            ArrayList<Long> nodeIds = new ArrayList<Long>();
            for (long i = 0L; i < 1000L; ++i) {
                nodeIds.add(i);
                updates.add(IndexQueryHelper.add((long)i, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{value}));
            }
            this.updateAndCommit(updates);
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(nodeIds));
        }

        private Value nextRandomValidArrayValue() {
            ArrayValue value;
            do {
                value = this.random.randomValues().nextArray();
            } while (!this.testSuite.supportsSpatial() && Values.isGeometryArray((Value)value));
            return value;
        }
    }
}

