/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class SimpleRandomizedIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public SimpleRandomizedIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, TestIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100}));
    }

    @Test
    public void testExactMatchOnRandomValues() throws Exception {
        List<RandomValues.Types> types = this.testSuite.supportedValueTypes();
        Collections.shuffle(types, this.random.random());
        types = types.subList(0, this.random.nextInt(2, types.size()));
        ArrayList updates = new ArrayList();
        HashSet<Value> duplicateChecker = new HashSet<Value>();
        for (long id = 0L; id < 30000L; ++id) {
            IndexEntryUpdate update;
            while (!duplicateChecker.add((update = IndexQueryHelper.add((long)id, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{this.random.nextValue((RandomValues.Types)this.random.among(types))})).values()[0])) {
            }
            updates.add(update);
        }
        this.updateAndCommit(updates);
        for (IndexEntryUpdate indexEntryUpdate : updates) {
            List<Long> hits = this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)indexEntryUpdate.values()[0])});
            Assert.assertEquals((String)hits.toString(), (long)1L, (long)hits.size());
            Assert.assertThat((Object)Iterables.single(hits), (Matcher)Matchers.equalTo((Object)indexEntryUpdate.getEntityId()));
        }
    }
}

