/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class BuiltInDbmsProceduresIT
extends KernelIntegrationTest {
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Test
    public void listConfig() throws Exception {
        RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "listConfig"}), ArrayUtils.toArray((Object[])new String[]{""}), this.dependencyResolver, SecurityContext.AUTH_DISABLED, this.resourceTracker);
        List config = Iterators.asList((RawIterator)stream);
        List names = config.stream().map(o -> o[0].toString()).collect(Collectors.toList());
        Assert.assertTrue((names.size() > 10 ? 1 : 0) != 0);
        Assert.assertThat(names, (Matcher)Matchers.hasItem((Object)GraphDatabaseSettings.record_format.name()));
        Assert.assertEquals((long)names.stream().filter(n -> n.startsWith("unsupported")).count(), (long)0L);
    }

    @Test
    public void listConfigWithASpecificConfigName() throws Exception {
        RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "listConfig"}), ArrayUtils.toArray((Object[])new String[]{GraphDatabaseSettings.strict_config_validation.name()}), this.dependencyResolver, SecurityContext.AUTH_DISABLED, this.resourceTracker);
        List config = Iterators.asList((RawIterator)stream);
        Assert.assertEquals((long)1L, (long)config.size());
        Assert.assertArrayEquals((Object[])new Object[]{"dbms.config.strict_validation", "A strict configuration validation will prevent the database from starting up if unknown configuration options are specified in the neo4j settings namespace (such as dbms., ha., cypher., etc). This is currently false by default but will be true by default in 4.0.", "false"}, (Object[])((Object[])config.get(0)));
    }

    @Test
    public void durationAlwaysListedWithUnit() throws Exception {
        RawIterator stream = this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "listConfig"}), ArrayUtils.toArray((Object[])new String[]{GraphDatabaseSettings.transaction_timeout.name()}), this.dependencyResolver, SecurityContext.AUTH_DISABLED, this.resourceTracker);
        List config = Iterators.asList((RawIterator)stream);
        Assert.assertEquals((long)1L, (long)config.size());
        Assert.assertArrayEquals((Object[])new Object[]{"dbms.transaction.timeout", "The maximum time interval of a transaction within which it should be completed.", "0ms"}, (Object[])((Object[])config.get(0)));
    }
}

