/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={EphemeralFileSystemExtension.class, TestDirectoryExtension.class})
public class SchemaImplTest {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService db;

    @BeforeEach
    void createDb() {
        this.db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs).newImpermanentDatabase(this.testDirectory.databaseDir());
    }

    @AfterEach
    void shutdownDb() {
        this.db.shutdown();
    }

    @Test
    void testGetIndexPopulationProgress() throws Exception {
        IndexDefinition indexDefinition;
        Schema schema;
        Assertions.assertFalse((boolean)this.indexExists(Label.label((String)"User")));
        try (Transaction tx = this.db.beginTx();){
            Label label = Label.label((String)"User");
            for (int id = 0; id < 100000; ++id) {
                Node userNode = this.db.createNode(new Label[]{label});
                userNode.setProperty("username", (Object)("user" + id + "@neo4j.org"));
            }
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            schema = this.db.schema();
            indexDefinition = schema.indexFor(Label.label((String)"User")).on("username").create();
            tx.success();
        }
        var3_3 = null;
        try (Transaction ignore = this.db.beginTx();){
            IndexPopulationProgress progress;
            Schema.IndexState state;
            schema = this.db.schema();
            do {
                state = schema.getIndexState(indexDefinition);
                progress = schema.getIndexPopulationProgress(indexDefinition);
                Assertions.assertTrue((progress.getCompletedPercentage() >= 0.0f ? 1 : 0) != 0);
                Assertions.assertTrue((progress.getCompletedPercentage() <= 100.0f ? 1 : 0) != 0);
                Thread.sleep(10L);
            } while (state == Schema.IndexState.POPULATING);
            Assertions.assertSame((Object)state, (Object)Schema.IndexState.ONLINE);
            Assertions.assertEquals((double)100.0, (double)progress.getCompletedPercentage(), (double)1.0E-4);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private boolean indexExists(Label label) {
        try (Transaction transaction = this.db.beginTx();){
            Iterable indexes = this.db.schema().getIndexes(label);
            IndexDefinition index = (IndexDefinition)Iterables.firstOrNull((Iterable)indexes);
            boolean exists = index != null;
            transaction.success();
            boolean bl = exists;
            return bl;
        }
    }
}

