/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class PropertyKeyTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lazyLoadWithinWriteTransaction() throws Exception {
        FileSystemAbstraction fileSystem = this.fs.get();
        BatchInserter inserter = BatchInserters.inserter((File)this.testDirectory.databaseDir(), (FileSystemAbstraction)fileSystem);
        int count = 3000;
        long nodeId = inserter.createNode(PropertyKeyTest.mapWithManyProperties(count), new Label[0]);
        inserter.shutdown();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(fileSystem).newImpermanentDatabase(this.testDirectory.databaseDir());
        try (Transaction tx = db.beginTx();){
            db.createNode();
            Node node = db.getNodeById(nodeId);
            Assert.assertEquals((long)count, (long)Iterables.count((Iterable)node.getPropertyKeys()));
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private static Map<String, Object> mapWithManyProperties(int count) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < count; ++i) {
            properties.put("key:" + i, "value");
        }
        return properties;
    }
}

