/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;
import org.neo4j.unsafe.batchinsert.internal.FileSystemClosingBatchInserter;

public class BatchInsertersTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();

    @Test
    public void automaticallyCloseCreatedFileSystemOnShutdown() throws Exception {
        BatchInsertersTest.verifyInserterFileSystemClose(BatchInserters.inserter((File)this.getStoreDir()));
        BatchInsertersTest.verifyInserterFileSystemClose(BatchInserters.inserter((File)this.getStoreDir(), BatchInsertersTest.getConfig()));
        BatchInsertersTest.verifyInserterFileSystemClose(BatchInserters.inserter((File)this.getStoreDir(), BatchInsertersTest.getConfig(), BatchInsertersTest.getKernelExtensions()));
    }

    @Test
    public void providedFileSystemNotClosedAfterShutdown() throws IOException {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        BatchInsertersTest.verifyProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)fs), fs);
        BatchInsertersTest.verifyProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)fs, BatchInsertersTest.getConfig()), fs);
        BatchInsertersTest.verifyProvidedFileSystemOpenAfterShutdown(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)fs, BatchInsertersTest.getConfig(), BatchInsertersTest.getKernelExtensions()), fs);
    }

    private static Iterable<KernelExtensionFactory<?>> getKernelExtensions() {
        return Iterables.asIterable((Object[])new KernelExtensionFactory[]{new NativeLuceneFusionIndexProviderFactory20()});
    }

    private static Map<String, String> getConfig() {
        return MapUtil.stringMap((String[])new String[0]);
    }

    private static void verifyProvidedFileSystemOpenAfterShutdown(BatchInserter inserter, EphemeralFileSystemAbstraction fileSystemAbstraction) {
        inserter.shutdown();
        Assert.assertFalse((boolean)fileSystemAbstraction.isClosed());
    }

    private File getStoreDir() {
        return this.testDirectory.storeDir();
    }

    private static void verifyInserterFileSystemClose(BatchInserter inserter) {
        Assert.assertThat((String)"Expect specific implementation that will do required cleanups.", (Object)inserter, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(FileSystemClosingBatchInserter.class)));
        inserter.shutdown();
    }
}

