/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

@RunWith(value=Parameterized.class)
public class BatchInsertIndexProviderTest {
    private final GraphDatabaseSettings.SchemaIndex schemaIndex;
    private DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private TestDirectory storeDir = TestDirectory.testDirectory();
    private PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.storeDir).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);

    @Parameterized.Parameters(name="{0}")
    public static Collection<GraphDatabaseSettings.SchemaIndex> data() {
        return Arrays.asList(GraphDatabaseSettings.SchemaIndex.values());
    }

    public BatchInsertIndexProviderTest(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.schemaIndex = schemaIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchInserterShouldUseConfiguredIndexProvider() throws Exception {
        Map config = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_schema_provider.name(), this.schemaIndex.providerIdentifier()});
        BatchInserter inserter = this.newBatchInserter(config);
        inserter.createDeferredSchemaIndex((Label)TestLabels.LABEL_ONE).on("key").create();
        inserter.shutdown();
        GraphDatabaseService db = this.graphDatabaseService(this.storeDir.databaseDir(), config);
        try (Transaction tx = db.beginTx();){
            DependencyResolver dependencyResolver = ((GraphDatabaseAPI)db).getDependencyResolver();
            ThreadToStatementContextBridge threadToStatementContextBridge = (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
            KernelTransaction kernelTransaction = threadToStatementContextBridge.getKernelTransactionBoundToThisThread(true);
            TokenRead tokenRead = kernelTransaction.tokenRead();
            SchemaRead schemaRead = kernelTransaction.schemaRead();
            int labelId = tokenRead.nodeLabel(TestLabels.LABEL_ONE.name());
            int propertyId = tokenRead.propertyKey("key");
            IndexReference index = schemaRead.index(labelId, new int[]{propertyId});
            Assert.assertTrue((String)BatchInsertIndexProviderTest.unexpectedIndexProviderMessage(index), (boolean)this.schemaIndex.providerIdentifier().contains(index.providerKey()));
            Assert.assertTrue((String)BatchInsertIndexProviderTest.unexpectedIndexProviderMessage(index), (boolean)this.schemaIndex.providerIdentifier().contains(index.providerVersion()));
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private BatchInserter newBatchInserter(Map<String, String> config) throws Exception {
        return BatchInserters.inserter((File)this.storeDir.databaseDir(), (FileSystemAbstraction)this.fileSystemRule.get(), config);
    }

    private GraphDatabaseService graphDatabaseService(File storeDir, Map<String, String> config) {
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem(this.fileSystemRule.get());
        GraphDatabaseService db = factory.newImpermanentDatabaseBuilder(storeDir).setConfig(config).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        return db;
    }

    private static String unexpectedIndexProviderMessage(IndexReference index) {
        return "Unexpected provider: key=" + index.providerKey() + ", version=" + index.providerVersion();
    }
}

