/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.GeneratingInputIterator;
import org.neo4j.unsafe.impl.batchimport.IdGroupDistribution;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.RandomsStates;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorAssignmentStrategies;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class ParallelBatchImporterTest {
    private static final int NUMBER_OF_ID_GROUPS = 5;
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final RandomRule random = new RandomRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.random).around((TestRule)this.fileSystemRule).around((TestRule)this.suppressOutput);
    private static final int NODE_COUNT = 10000;
    private static final int RELATIONSHIPS_PER_NODE = 5;
    private static final int RELATIONSHIP_COUNT = 50000;
    private static final int RELATIONSHIP_TYPES = 3;
    protected final Configuration config = new Configuration(){

        public int batchSize() {
            return 100;
        }

        public int denseNodeThreshold() {
            return 10;
        }

        public int maxNumberOfProcessors() {
            int cores = Runtime.getRuntime().availableProcessors();
            return ParallelBatchImporterTest.this.random.intBetween(cores, cores + 100);
        }

        public long maxMemoryUsage() {
            double ratio = 10.0;
            long mebi = ByteUnit.mebiBytes((long)1L);
            return ParallelBatchImporterTest.this.random.nextInt((int)(ratio * (double)mebi / 2.0), (int)(ratio * (double)mebi));
        }
    };
    private final InputIdGenerator inputIdGenerator;
    private final Function<Groups, IdMapper> idMapper;
    private static final String[] TOKENS = new String[]{"token1", "token2", "token3", "token4", "token5", "token6", "token7"};

    @Parameterized.Parameters(name="{0},{1},{3}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new LongInputIdGenerator(), groups -> IdMappers.longs((NumberArrayFactory)NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, (Groups)groups)}, {new StringInputIdGenerator(), groups -> IdMappers.strings((NumberArrayFactory)NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, (Groups)groups)});
    }

    public ParallelBatchImporterTest(InputIdGenerator inputIdGenerator, Function<Groups, IdMapper> idMapper) {
        this.inputIdGenerator = inputIdGenerator;
        this.idMapper = idMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void shouldImportCsvData() throws Exception {
        Throwable throwable;
        ExecutionMonitor processorAssigner = ProcessorAssignmentStrategies.eagerRandomSaturation((int)this.config.maxNumberOfProcessors());
        DatabaseLayout databaseLayout = this.directory.databaseLayout("dir" + this.random.nextAlphaNumericString(8, 8));
        boolean successful = false;
        Groups groups = new Groups();
        IdGroupDistribution groupDistribution = new IdGroupDistribution(10000L, 5, this.random.random(), groups);
        long nodeRandomSeed = this.random.nextLong();
        long relationshipRandomSeed = this.random.nextLong();
        ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
        ParallelBatchImporter inserter = new ParallelBatchImporter(databaseLayout, this.fileSystemRule.get(), null, this.config, (LogService)NullLogService.getInstance(), processorAssigner, AdditionalInitialIds.EMPTY, Config.defaults(), this.getFormat(), ImportLogic.NO_MONITOR, (JobScheduler)jobScheduler);
        try {
            inserter.doImport(Inputs.input((InputIterable)this.nodes(nodeRandomSeed, 10000L, this.config.batchSize(), this.inputIdGenerator, groupDistribution), (InputIterable)this.relationships(relationshipRandomSeed, 50000L, this.config.batchSize(), this.inputIdGenerator, groupDistribution), (IdMapper)this.idMapper.apply(groups), (Collector)Collectors.silentBadCollector((long)50000L), (Input.Estimates)Inputs.knownEstimates((long)10000L, (long)50000L, (long)(10000 * TOKENS.length / 2), (long)(50000 * TOKENS.length / 2), (long)(10000 * TOKENS.length / 2 * 8), (long)(50000 * TOKENS.length / 2 * 8), (long)(10000 * TOKENS.length / 2))));
            GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(databaseLayout.databaseDirectory()).setConfig("dbms.backup.enabled", "false").newGraphDatabase();
            try {
                throwable = null;
                try (Transaction tx = db.beginTx();){
                    this.inputIdGenerator.reset();
                    this.verifyData(10000, 50000, db, groupDistribution, nodeRandomSeed, relationshipRandomSeed);
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                db.shutdown();
            }
            this.assertConsistent(databaseLayout);
            successful = true;
            return;
        }
        finally {
            jobScheduler.close();
            if (!successful) {
                File failureFile = new File(databaseLayout.databaseDirectory(), "input");
                throwable = null;
                try (PrintStream out = new PrintStream(failureFile);){
                    out.println("Seed used in this failing run: " + this.random.seed());
                    out.println(this.inputIdGenerator);
                    this.inputIdGenerator.reset();
                    out.println();
                    out.println("Processor assignments");
                    out.println(processorAssigner.toString());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                System.err.println("Additional debug information stored in " + failureFile);
            }
        }
    }

    protected void assertConsistent(DatabaseLayout databaseLayout) throws ConsistencyCheckIncompleteException {
        ConsistencyCheckService consistencyChecker = new ConsistencyCheckService();
        ConsistencyCheckService.Result result = consistencyChecker.runFullConsistencyCheck(databaseLayout, Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m"), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assert.assertTrue((String)("Database contains inconsistencies, there should be a report in " + databaseLayout.databaseDirectory()), (boolean)result.isSuccessful());
    }

    protected RecordFormats getFormat() {
        return Standard.LATEST_RECORD_FORMATS;
    }

    private void verifyData(int nodeCount, int relationshipCount, GraphDatabaseService db, IdGroupDistribution groups, long nodeRandomSeed, long relationshipRandomSeed) throws IOException {
        try (InputIterator nodes = this.nodes(nodeRandomSeed, nodeCount, this.config.batchSize(), this.inputIdGenerator, groups).iterator();
             InputIterator relationships = this.relationships(relationshipRandomSeed, relationshipCount, this.config.batchSize(), this.inputIdGenerator, groups).iterator();
             ResourceIterator dbNodes = db.getAllNodes().iterator();){
            HashMap<String, Node> nodeByInputId = new HashMap<String, Node>(nodeCount);
            while (dbNodes.hasNext()) {
                Node node = (Node)dbNodes.next();
                String id = (String)node.getProperty("id");
                Assert.assertNull((Object)nodeByInputId.put(id, node));
            }
            int verifiedNodes = 0;
            long allNodesScanLabelCount = 0L;
            InputChunk chunk = nodes.newChunk();
            InputEntity input = new InputEntity();
            while (nodes.next(chunk)) {
                while (chunk.next((InputEntityVisitor)input)) {
                    String iid = this.uniqueId(input.idGroup, input.objectId);
                    Node node = (Node)nodeByInputId.get(iid);
                    this.assertNodeEquals(input, node);
                    ++verifiedNodes;
                    this.assertDegrees(node);
                    allNodesScanLabelCount += Iterables.count((Iterable)node.getLabels());
                }
            }
            Assert.assertEquals((long)nodeCount, (long)verifiedNodes);
            long labelScanStoreEntryCount = db.getAllLabels().stream().flatMap(l -> db.findNodes(l).stream()).count();
            Assert.assertEquals((String)String.format("Expected label scan store and node store to have same number labels. But %n#labelsInNodeStore=%d%n#labelsInLabelScanStore=%d%n", allNodesScanLabelCount, labelScanStoreEntryCount), (long)allNodesScanLabelCount, (long)labelScanStoreEntryCount);
            chunk = relationships.newChunk();
            HashMap<String, Relationship> relationshipByName = new HashMap<String, Relationship>();
            for (Relationship relationship : db.getAllRelationships()) {
                relationshipByName.put((String)relationship.getProperty("id"), relationship);
            }
            int verifiedRelationships = 0;
            while (relationships.next(chunk)) {
                while (chunk.next((InputEntityVisitor)input)) {
                    if (!this.inputIdGenerator.isMiss(input.objectStartId) && !this.inputIdGenerator.isMiss(input.objectEndId)) {
                        String name = (String)this.propertyOf(input, "id");
                        Relationship relationship = (Relationship)relationshipByName.get(name);
                        Assert.assertNotNull((String)("Expected there to be a relationship with name '" + name + "'"), (Object)relationship);
                        Assert.assertEquals(nodeByInputId.get(this.uniqueId(input.startIdGroup, input.objectStartId)), (Object)relationship.getStartNode());
                        Assert.assertEquals(nodeByInputId.get(this.uniqueId(input.endIdGroup, input.objectEndId)), (Object)relationship.getEndNode());
                        this.assertRelationshipEquals(input, relationship);
                    }
                    ++verifiedRelationships;
                }
            }
            Assert.assertEquals((long)relationshipCount, (long)verifiedRelationships);
        }
    }

    private void assertDegrees(Node node) {
        for (RelationshipType type : node.getRelationshipTypes()) {
            for (Direction direction : Direction.values()) {
                long degree = node.getDegree(type, direction);
                long actualDegree = Iterables.count((Iterable)node.getRelationships(type, direction));
                Assert.assertEquals((long)actualDegree, (long)degree);
            }
        }
    }

    private String uniqueId(Group group, PropertyContainer entity) {
        return this.uniqueId(group, entity.getProperty("id"));
    }

    private String uniqueId(Group group, Object id) {
        return group.name() + "_" + id;
    }

    private Object propertyOf(InputEntity input, String key) {
        Object[] properties = input.properties();
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i++].equals(key)) continue;
            return properties[i];
        }
        throw new IllegalStateException(key + " not found on " + input);
    }

    private void assertRelationshipEquals(InputEntity input, Relationship relationship) {
        this.assertPropertiesEquals(input, (PropertyContainer)relationship);
        Assert.assertEquals((Object)input.stringType, (Object)relationship.getType().name());
    }

    private void assertNodeEquals(InputEntity input, Node node) {
        this.assertPropertiesEquals(input, (PropertyContainer)node);
        Set expectedLabels = Iterators.asSet((Object[])input.labels());
        for (Label label : node.getLabels()) {
            Assert.assertTrue((boolean)expectedLabels.remove(label.name()));
        }
        Assert.assertTrue((boolean)expectedLabels.isEmpty());
    }

    private void assertPropertiesEquals(InputEntity input, PropertyContainer entity) {
        Object[] properties = input.properties();
        for (int i = 0; i < properties.length; ++i) {
            String key = (String)properties[i++];
            Object value = properties[i];
            this.assertPropertyValueEquals(input, entity, key, value, entity.getProperty(key));
        }
    }

    private void assertPropertyValueEquals(InputEntity input, PropertyContainer entity, String key, Object expected, Object array) {
        if (expected.getClass().isArray()) {
            int length = Array.getLength(expected);
            Assert.assertEquals((String)(input + ", " + entity), (long)length, (long)Array.getLength(array));
            for (int i = 0; i < length; ++i) {
                this.assertPropertyValueEquals(input, entity, key, Array.get(expected, i), Array.get(array, i));
            }
        } else {
            Assert.assertEquals((String)(input + ", " + entity + " for key:" + key), (Object)Values.of((Object)expected), (Object)Values.of((Object)array));
        }
    }

    private InputIterable relationships(long randomSeed, long count, int batchSize, InputIdGenerator idGenerator, IdGroupDistribution groups) {
        return () -> new GeneratingInputIterator(count, batchSize, (LongFunction)new RandomsStates(randomSeed), (randoms, visitor, id) -> {
            this.randomProperties((RandomValues)randoms, "Name " + id, visitor);
            ExistingId startNodeExistingId = idGenerator.randomExisting((RandomValues)randoms);
            Group startNodeGroup = groups.groupOf(startNodeExistingId.nodeIndex);
            ExistingId endNodeExistingId = idGenerator.randomExisting((RandomValues)randoms);
            Group endNodeGroup = groups.groupOf(endNodeExistingId.nodeIndex);
            Object startNode = idGenerator.miss((RandomValues)randoms, startNodeExistingId.id, 0.001f);
            Object endNode = idGenerator.miss((RandomValues)randoms, endNodeExistingId.id, 0.001f);
            visitor.startId(startNode, startNodeGroup);
            visitor.endId(endNode, endNodeGroup);
            String type = idGenerator.randomType((RandomValues)randoms);
            if ((double)randoms.nextFloat() < 5.0E-5) {
                type = type + "_odd";
            }
            visitor.type(type);
        }, 0L);
    }

    private InputIterable nodes(long randomSeed, long count, int batchSize, InputIdGenerator inputIdGenerator, IdGroupDistribution groups) {
        return () -> new GeneratingInputIterator(count, batchSize, (LongFunction)new RandomsStates(randomSeed), (randoms, visitor, id) -> {
            Object nodeId = inputIdGenerator.nextNodeId((RandomValues)randoms, id);
            Group group = groups.groupOf(id);
            visitor.id(nodeId, group);
            this.randomProperties((RandomValues)randoms, this.uniqueId(group, nodeId), visitor);
            visitor.labels((String[])randoms.selection((Object[])TOKENS, 0, TOKENS.length, true));
        }, 0L);
    }

    private void randomProperties(RandomValues randoms, Object id, InputEntityVisitor visitor) {
        String[] keys;
        for (String key : keys = (String[])randoms.selection((Object[])TOKENS, 0, TOKENS.length, false)) {
            visitor.property(key, randoms.nextValue().asObject());
        }
        visitor.property("id", id);
    }

    private static class StringInputIdGenerator
    extends InputIdGenerator {
        private final String[] strings = new String[10000];

        private StringInputIdGenerator() {
        }

        @Override
        void reset() {
            Arrays.fill(this.strings, null);
        }

        @Override
        Object nextNodeId(RandomValues random, long item) {
            String result;
            byte[] randomBytes = random.nextByteArray(10, 10).asObjectCopy();
            this.strings[Math.toIntExact((long)item)] = result = UUID.nameUUIDFromBytes(randomBytes).toString();
            return result;
        }

        @Override
        ExistingId randomExisting(RandomValues random) {
            int index = random.nextInt(this.strings.length);
            return new ExistingId(this.strings[index], index);
        }

        @Override
        Object miss(RandomValues random, Object id, float chance) {
            return random.nextFloat() < chance ? "_" + id : id;
        }

        @Override
        boolean isMiss(Object id) {
            return ((String)id).startsWith("_");
        }
    }

    private static class LongInputIdGenerator
    extends InputIdGenerator {
        private LongInputIdGenerator() {
        }

        @Override
        void reset() {
        }

        @Override
        synchronized Object nextNodeId(RandomValues random, long item) {
            return item;
        }

        @Override
        ExistingId randomExisting(RandomValues random) {
            long index = random.nextInt(10000);
            return new ExistingId(index, index);
        }

        @Override
        Object miss(RandomValues random, Object id, float chance) {
            return random.nextFloat() < chance ? Long.valueOf((Long)id + 100000000L) : id;
        }

        @Override
        boolean isMiss(Object id) {
            return (Long)id >= 100000000L;
        }
    }

    public static abstract class InputIdGenerator {
        abstract void reset();

        abstract Object nextNodeId(RandomValues var1, long var2);

        abstract ExistingId randomExisting(RandomValues var1);

        abstract Object miss(RandomValues var1, Object var2, float var3);

        abstract boolean isMiss(Object var1);

        String randomType(RandomValues random) {
            return "TYPE" + random.nextInt(3);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class ExistingId {
        private final Object id;
        private final long nodeIndex;

        ExistingId(Object id, long nodeIndex) {
            this.id = id;
            this.nodeIndex = nodeIndex;
        }
    }
}

