/*
 * Decompiled with CFR 0.152.
 */
package recovery;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.proc.ProcessUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class TestRecoveryMultipleDataSources {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void recoverNeoAndIndexHavingAllRelationshipTypesAfterRecovery() throws Exception {
        File storeDir = this.testDirectory.storeDir();
        Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{ProcessUtil.getJavaExecutable().toString(), "-Djava.awt.headless=true", "-cp", ProcessUtil.getClassPath(), this.getClass().getName(), storeDir.getAbsolutePath()}).waitFor());
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try (Transaction ignored = db.beginTx();
             ResourceIterator typeResourceIterator = db.getAllRelationshipTypes().iterator();){
            Assert.assertEquals((Object)MyRelTypes.TEST.name(), (Object)((RelationshipType)typeResourceIterator.next()).name());
        }
        finally {
            db.shutdown();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.exit(1);
        }
        File storeDir = new File(args[0]);
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        ((CheckPointer)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        tx = db.beginTx();
        var4_4 = null;
        try {
            db.index().forNodes("index").add((PropertyContainer)db.createNode(), storeDir.getAbsolutePath(), (Object)db.createNode());
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        System.exit(0);
    }
}

