/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.CompositeIndexAccessorCompatibility;
import org.neo4j.kernel.api.index.CompositeIndexPopulatorCompatibility;
import org.neo4j.kernel.api.index.CompositeRandomizedIndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.SimpleIndexAccessorCompatibility;
import org.neo4j.kernel.api.index.SimpleIndexPopulatorCompatibility;
import org.neo4j.kernel.api.index.SimpleRandomizedIndexAccessorCompatibility;
import org.neo4j.kernel.api.index.UniqueConstraintCompatibility;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;
import org.neo4j.test.runner.ParameterizedSuiteRunner;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@RunWith(value=ParameterizedSuiteRunner.class)
@Suite.SuiteClasses(value={SimpleIndexPopulatorCompatibility.General.class, SimpleIndexPopulatorCompatibility.Unique.class, CompositeIndexPopulatorCompatibility.General.class, CompositeIndexPopulatorCompatibility.Unique.class, SimpleIndexAccessorCompatibility.General.class, SimpleIndexAccessorCompatibility.Unique.class, CompositeIndexAccessorCompatibility.General.class, CompositeIndexAccessorCompatibility.Unique.class, UniqueConstraintCompatibility.class, SimpleRandomizedIndexAccessorCompatibility.class, CompositeRandomizedIndexAccessorCompatibility.Exact.class, CompositeRandomizedIndexAccessorCompatibility.Range.class})
public abstract class IndexProviderCompatibilityTestSuite {
    protected abstract IndexProvider createIndexProvider(PageCache var1, FileSystemAbstraction var2, File var3);

    public abstract boolean supportsSpatial();

    public boolean supportsGranularCompositeQueries() {
        return false;
    }

    public boolean supportsBooleanRangeQueries() {
        return false;
    }

    public boolean supportFullValuePrecisionForNumbers() {
        return true;
    }

    public ValueType[] supportedValueTypes() {
        if (!this.supportsSpatial()) {
            return RandomValues.excluding((ValueType[])new ValueType[]{ValueType.CARTESIAN_POINT, ValueType.CARTESIAN_POINT_ARRAY, ValueType.CARTESIAN_POINT_3D, ValueType.CARTESIAN_POINT_3D_ARRAY, ValueType.GEOGRAPHIC_POINT, ValueType.GEOGRAPHIC_POINT_ARRAY, ValueType.GEOGRAPHIC_POINT_3D, ValueType.GEOGRAPHIC_POINT_3D_ARRAY});
        }
        return ValueType.values();
    }

    public void consistencyCheck(IndexAccessor accessor) {
    }

    public void consistencyCheck(IndexPopulator populator) {
    }

    public static abstract class Compatibility {
        private final PageCacheAndDependenciesRule pageCacheAndDependenciesRule;
        final RandomRule random;
        @Rule
        public RuleChain ruleChain;
        protected File graphDbDir;
        protected FileSystemAbstraction fs;
        protected IndexProvider indexProvider;
        protected StoreIndexDescriptor descriptor;
        final IndexProviderCompatibilityTestSuite testSuite;
        final List<NodeAndValue> valueSet1;
        final List<NodeAndValue> valueSet2;

        @Before
        public void setup() {
            this.fs = this.pageCacheAndDependenciesRule.fileSystem();
            this.graphDbDir = this.pageCacheAndDependenciesRule.directory().databaseDir();
            PageCache pageCache = this.pageCacheAndDependenciesRule.pageCache();
            this.indexProvider = this.testSuite.createIndexProvider(pageCache, this.fs, this.graphDbDir);
        }

        public Compatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
            this.testSuite = testSuite;
            this.descriptor = descriptor.withId(17L);
            this.valueSet1 = Compatibility.allValues(testSuite.supportsSpatial(), Arrays.asList(Values.of((Object)"string1"), Values.of((Object)42), Values.of((Object)true), Values.of((Object)new char[]{'a', 'z'}), Values.of((Object)new String[]{"arrayString1", "arraysString2"}), Values.of((Object)new byte[]{1, 12}), Values.of((Object)new short[]{314, 1337}), Values.of((Object)new int[]{3140, 13370}), Values.of((Object)new long[]{31400L, 133700L}), Values.of((Object)new boolean[]{true, true})), Arrays.asList(DateValue.epochDate((long)2L), LocalTimeValue.localTime((long)100000L), TimeValue.time((long)43200000000000L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)43201000000000L, (ZoneOffset)ZoneOffset.UTC), TimeValue.time((long)43200000000000L, (ZoneOffset)ZoneOffset.of("+01:00")), TimeValue.time((long)46800000000000L, (ZoneOffset)ZoneOffset.UTC), LocalDateTimeValue.localDateTime((int)2018, (int)3, (int)1, (int)13, (int)50, (int)42, (int)1337), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"UTC"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"Europe/Stockholm"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2015, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)4, (int)25, (int)12, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)26, (int)12, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)13, (int)45, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)46, (int)13, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)14, (int)7474, (String)"+05:00"), DateTimeValue.datetime((int)2014, (int)3, (int)25, (int)12, (int)45, (int)13, (int)7475, (String)"+05:00"), DateTimeValue.datetime((int)2038, (int)1, (int)18, (int)9, (int)14, (int)7, (int)0, (String)"-18:00"), DateTimeValue.datetime((long)10000L, (long)100L, (ZoneOffset)ZoneOffset.ofTotalSeconds(3)), DateTimeValue.datetime((long)10000L, (long)101L, (ZoneOffset)ZoneOffset.ofTotalSeconds(-3)), DurationValue.duration((long)10L, (long)20L, (long)30L, (long)40L), DurationValue.duration((long)11L, (long)20L, (long)30L, (long)40L), DurationValue.duration((long)10L, (long)21L, (long)30L, (long)40L), DurationValue.duration((long)10L, (long)20L, (long)31L, (long)40L), DurationValue.duration((long)10L, (long)20L, (long)30L, (long)41L), Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{ZonedDateTime.of(2018, 10, 9, 8, 7, 6, 5, ZoneId.of("UTC")), ZonedDateTime.of(2017, 9, 8, 7, 6, 5, 4, ZoneId.of("UTC"))}), Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{LocalDateTime.of(2018, 10, 9, 8, 7, 6, 5), LocalDateTime.of(2018, 10, 9, 8, 7, 6, 5)}), Values.timeArray((OffsetTime[])new OffsetTime[]{OffsetTime.of(20, 8, 7, 6, ZoneOffset.UTC), OffsetTime.of(20, 8, 7, 6, ZoneOffset.UTC)}), Values.dateArray((LocalDate[])new LocalDate[]{LocalDate.of(1, 12, 28), LocalDate.of(1, 12, 28)}), Values.localTimeArray((LocalTime[])new LocalTime[]{LocalTime.of(9, 28), LocalTime.of(9, 28)}), Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((long)12L, (long)10L, (long)10L, (long)10L), DurationValue.duration((long)12L, (long)10L, (long)10L, (long)10L)})), Arrays.asList(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.78, 56.7})));
            this.valueSet2 = Compatibility.allValues(testSuite.supportsSpatial(), Arrays.asList(Values.of((Object)"string2"), Values.of((Object)1337), Values.of((Object)false), Values.of((Object)new char[]{'b', 'c'}), Values.of((Object)new String[]{"someString1", "someString2"}), Values.of((Object)new byte[]{9, 9}), Values.of((Object)new short[]{99, 999}), Values.of((Object)new int[]{99999, 99999}), Values.of((Object)new long[]{999999L, 999999L}), Values.of((Object)new boolean[]{false, false})), Arrays.asList(DateValue.epochDate((long)42L), LocalTimeValue.localTime((long)2000L), TimeValue.time((long)100L, (ZoneOffset)ZoneOffset.UTC), LocalDateTimeValue.localDateTime((int)2018, (int)2, (int)28, (int)11, (int)5, (int)1, (int)42), DateTimeValue.datetime((int)1999, (int)12, (int)31, (int)23, (int)59, (int)59, (int)123456789, (String)"Europe/London"), DurationValue.duration((long)4L, (long)3L, (long)2L, (long)1L), Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{ZonedDateTime.of(999, 10, 9, 8, 7, 6, 5, ZoneId.of("UTC")), ZonedDateTime.of(999, 9, 8, 7, 6, 5, 4, ZoneId.of("UTC"))}), Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{LocalDateTime.of(999, 10, 9, 8, 7, 6, 5), LocalDateTime.of(999, 10, 9, 8, 7, 6, 5)}), Values.timeArray((OffsetTime[])new OffsetTime[]{OffsetTime.of(19, 8, 7, 6, ZoneOffset.UTC), OffsetTime.of(19, 8, 7, 6, ZoneOffset.UTC)}), Values.dateArray((LocalDate[])new LocalDate[]{LocalDate.of(999, 12, 28), LocalDate.of(999, 12, 28)}), Values.localTimeArray((LocalTime[])new LocalTime[]{LocalTime.of(19, 28), LocalTime.of(19, 28)}), Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((long)99L, (long)10L, (long)10L, (long)10L), DurationValue.duration((long)99L, (long)10L, (long)10L, (long)10L)})), Arrays.asList(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{90.0, 90.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{9.21, 9.65})));
            this.pageCacheAndDependenciesRule = new PageCacheAndDependenciesRule().with((FileSystemRule)new DefaultFileSystemRule()).with(testSuite.getClass());
            this.random = new RandomRule();
            this.ruleChain = RuleChain.outerRule((TestRule)this.pageCacheAndDependenciesRule).around((TestRule)this.random);
        }

        void withPopulator(IndexPopulator populator, ThrowingConsumer<IndexPopulator, Exception> runWithPopulator) throws Exception {
            this.withPopulator(populator, runWithPopulator, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void withPopulator(IndexPopulator populator, ThrowingConsumer<IndexPopulator, Exception> runWithPopulator, boolean closeSuccessfully) throws Exception {
            try {
                populator.create();
                runWithPopulator.accept((Object)populator);
                if (closeSuccessfully) {
                    this.testSuite.consistencyCheck(populator);
                }
            }
            finally {
                populator.close(closeSuccessfully);
            }
        }

        List<IndexEntryUpdate<?>> updates(List<NodeAndValue> values) {
            return this.updates(values, 0L);
        }

        List<IndexEntryUpdate<?>> updates(List<NodeAndValue> values, long nodeIdOffset) {
            ArrayList updates = new ArrayList();
            values.forEach(entry -> updates.add(IndexEntryUpdate.add((long)(nodeIdOffset + entry.nodeId), (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{entry.value})));
            return updates;
        }

        private static List<NodeAndValue> allValues(boolean supportsSpatial, List<Value> common, List<Value> temporal, List<Value> spatial) {
            long nodeIds = 0L;
            ArrayList<NodeAndValue> result = new ArrayList<NodeAndValue>();
            for (Value value : common) {
                result.add(new NodeAndValue(nodeIds++, value));
            }
            if (supportsSpatial) {
                for (Value value : spatial) {
                    result.add(new NodeAndValue(nodeIds++, value));
                }
            }
            for (Value value : temporal) {
                result.add(new NodeAndValue(nodeIds++, value));
            }
            return result;
        }

        static class NodeAndValue {
            final long nodeId;
            final Value value;

            NodeAndValue(long nodeId, Value value) {
                this.nodeId = nodeId;
                this.value = value;
            }
        }
    }
}

