/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class SimpleRandomizedIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public SimpleRandomizedIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, TestIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100}));
    }

    @Test
    public void testExactMatchOnRandomValues() throws Exception {
        ValueType[] types = this.randomSetOfSupportedTypes();
        List<Value> values = this.generateValuesFromType(types);
        List<IndexEntryUpdate<?>> updates = this.generateUpdatesFromValues(values);
        this.updateAndCommit(updates);
        for (IndexEntryUpdate<?> update : updates) {
            List<Long> hits = this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)update.values()[0])});
            Assert.assertEquals((String)hits.toString(), (long)1L, (long)hits.size());
            Assert.assertThat((Object)Iterables.single(hits), (Matcher)Matchers.equalTo((Object)update.getEntityId()));
        }
    }

    @Test
    public void testRangeMatchInOrderOnRandomValues() throws Exception {
        Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
        Object[] types = this.randomSetOfSupportedAndSortableTypes();
        List<Value> values = this.generateValuesFromType((ValueType[])types);
        List<IndexEntryUpdate<?>> updates = this.generateUpdatesFromValues(values);
        this.updateAndCommit(updates);
        TreeSet<IndexEntryUpdate> sortedValues = new TreeSet<IndexEntryUpdate>((u1, u2) -> Values.COMPARATOR.compare(u1.values()[0], u2.values()[0]));
        sortedValues.addAll(updates);
        for (int i = 0; i < 100; ++i) {
            IndexOrder[] indexOrders;
            Value to;
            ValueType type = (ValueType)this.random.among(types);
            Value from = this.random.randomValues().nextValueOfType(type);
            if (Values.COMPARATOR.compare(from, to = this.random.randomValues().nextValueOfType(type)) > 0) {
                Value tmp = from;
                from = to;
                to = tmp;
            }
            boolean fromInclusive = this.random.nextBoolean();
            boolean toInclusive = this.random.nextBoolean();
            IndexQuery.RangePredicate predicate = IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
            List<Long> expectedIds = this.expectedIds(sortedValues, from, to, fromInclusive, toInclusive);
            for (IndexOrder order : indexOrders = this.indexProvider.getCapability(this.descriptor).orderCapability(new ValueCategory[]{predicate.valueGroup().category()})) {
                List<Long> actualIds = this.assertInOrder(order, new IndexQuery[]{predicate});
                actualIds.sort(Long::compare);
                Assert.assertThat(actualIds, (Matcher)Matchers.equalTo(expectedIds));
            }
        }
    }

    private List<Long> expectedIds(TreeSet<IndexEntryUpdate> sortedValues, Value from, Value to, boolean fromInclusive, boolean toInclusive) {
        return sortedValues.subSet(IndexQueryHelper.add((long)0L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{from}), fromInclusive, IndexQueryHelper.add((long)0L, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{to}), toInclusive).stream().map(IndexEntryUpdate::getEntityId).sorted(Long::compare).collect(Collectors.toList());
    }

    private List<Value> generateValuesFromType(ValueType[] types) {
        ArrayList<Value> values = new ArrayList<Value>();
        HashSet<Value> duplicateChecker = new HashSet<Value>();
        for (long i = 0L; i < 30000L; ++i) {
            Value value;
            while (!duplicateChecker.add(value = this.random.randomValues().nextValueOfTypes(types))) {
            }
            values.add(value);
        }
        return values;
    }

    private List<IndexEntryUpdate<?>> generateUpdatesFromValues(List<Value> values) {
        ArrayList updates = new ArrayList();
        int id = 0;
        for (Value value : values) {
            updates.add(IndexQueryHelper.add((long)id++, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{value}));
        }
        return updates;
    }
}

