/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NeoStoreIndexStoreViewTest {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule();
    private final Map<Long, Lock> lockMocks = new HashMap<Long, Lock>();
    private final Label label = Label.label((String)"Person");
    private final RelationshipType relationshipType = RelationshipType.withName((String)"Knows");
    private GraphDatabaseAPI graphDb;
    private NeoStoreIndexStoreView storeView;
    private int labelId;
    private int relTypeId;
    private int propertyKeyId;
    private int relPropertyKeyId;
    private Node alistair;
    private Node stefan;
    private LockService locks;
    private NeoStores neoStores;
    private Relationship aKnowsS;
    private Relationship sKnowsA;
    private StorageReader reader;

    @Before
    public void before() throws KernelException {
        this.graphDb = this.dbRule.getGraphDatabaseAPI();
        this.createAlistairAndStefanNodes();
        this.getOrCreateIds();
        this.neoStores = ((RecordStorageEngine)this.graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.locks = (LockService)Mockito.mock(LockService.class);
        Mockito.when((Object)this.locks.acquireNodeLock(ArgumentMatchers.anyLong(), (LockService.LockType)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArgument(0);
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        Mockito.when((Object)this.locks.acquireRelationshipLock(ArgumentMatchers.anyLong(), (LockService.LockType)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArgument(0);
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        this.storeView = new NeoStoreIndexStoreView(this.locks, this.neoStores);
        this.reader = new RecordStorageReader(this.neoStores);
    }

    @After
    public void after() {
        this.reader.close();
    }

    @Test
    public void shouldScanExistingNodesForALabel() throws Exception {
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor, false);
        storeScan.run();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new EntityUpdates[]{this.add(this.alistair.getId(), this.propertyKeyId, "Alistair", new long[]{this.labelId}), this.add(this.stefan.getId(), this.propertyKeyId, "Stefan", new long[]{this.labelId})}), visitor.getUpdates());
    }

    @Test
    public void shouldScanExistingRelationshipsForARelationshiptype() throws Exception {
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (Visitor)visitor);
        storeScan.run();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new EntityUpdates[]{this.add(this.aKnowsS.getId(), this.relPropertyKeyId, "long", new long[]{this.relTypeId}), this.add(this.sKnowsA.getId(), this.relPropertyKeyId, "lengthy", new long[]{this.relTypeId})}), visitor.getUpdates());
    }

    @Test
    public void shouldIgnoreDeletedNodesDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor, false);
        storeScan.run();
        Assert.assertEquals(Collections.emptySet(), visitor.getUpdates());
    }

    @Test
    public void shouldIgnoreDeletedRelationshipsDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (Visitor)visitor);
        storeScan.run();
        Assert.assertEquals(Collections.emptySet(), visitor.getUpdates());
    }

    @Test
    public void shouldLockNodesWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, visitor, null, false);
        storeScan.run();
        MatcherAssert.assertThat((String)("allocated locks: " + this.lockMocks.keySet()), (Object)this.lockMocks.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        Assert.assertNotNull((String)"Lock[node=0] never acquired", (Object)lock0);
        Assert.assertNotNull((String)"Lock[node=1] never acquired", (Object)lock1);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
    }

    @Test
    public void shouldLockRelationshipsWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, visitor);
        storeScan.run();
        MatcherAssert.assertThat((String)("allocated locks: " + this.lockMocks.keySet()), (Object)this.lockMocks.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        Assert.assertNotNull((String)"Lock[relationship=0] never acquired", (Object)lock0);
        Assert.assertNotNull((String)"Lock[relationship=1] never acquired", (Object)lock1);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireRelationshipLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireRelationshipLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
    }

    @Test
    public void shouldReadProperties() throws EntityNotFoundException {
        Value value = this.storeView.getNodePropertyValue(this.alistair.getId(), this.propertyKeyId);
        Assert.assertTrue((boolean)value.equals(Values.of((Object)"Alistair")));
    }

    @Test
    public void processAllNodeProperties() throws Exception {
        CopyUpdateVisitor propertyUpdateVisitor = new CopyUpdateVisitor();
        StoreViewNodeStoreScan storeViewNodeStoreScan = new StoreViewNodeStoreScan((StorageReader)new RecordStorageReader(this.neoStores), this.locks, null, (Visitor)propertyUpdateVisitor, new int[]{this.labelId}, id -> true);
        try (StorageNodeCursor nodeCursor = this.reader.allocateNodeCursor();){
            nodeCursor.single(1L);
            nodeCursor.next();
            storeViewNodeStoreScan.process(nodeCursor);
        }
        EntityUpdates propertyUpdates = propertyUpdateVisitor.getPropertyUpdates();
        Assert.assertNotNull((String)"Visitor should contain container with updates.", (Object)propertyUpdates);
        LabelSchemaDescriptor index1 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        LabelSchemaDescriptor index2 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        LabelSchemaDescriptor index3 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1});
        LabelSchemaDescriptor index4 = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        List<org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index4);
        MatcherAssert.assertThat((Object)Iterables.map(IndexEntryUpdate::indexKey, (Iterable)propertyUpdates.forIndexKeys(indexes)), (Matcher)Matchers.containsInAnyOrder((Object[])new org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor[]{index1, index2, index3}));
    }

    @Test
    public void processAllRelationshipProperties() throws Exception {
        this.createAlistairAndStefanNodes();
        CopyUpdateVisitor propertyUpdateVisitor = new CopyUpdateVisitor();
        RelationshipStoreScan relationshipStoreScan = new RelationshipStoreScan((StorageReader)new RecordStorageReader(this.neoStores), this.locks, (Visitor)propertyUpdateVisitor, new int[]{this.relTypeId}, id -> true);
        try (StorageRelationshipScanCursor relationshipScanCursor = this.reader.allocateRelationshipScanCursor();){
            relationshipScanCursor.single(1L);
            relationshipScanCursor.next();
            relationshipStoreScan.process(relationshipScanCursor);
        }
        EntityUpdates propertyUpdates = propertyUpdateVisitor.getPropertyUpdates();
        Assert.assertNotNull((String)"Visitor should contain container with updates.", (Object)propertyUpdates);
        RelationTypeSchemaDescriptor index1 = SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{2});
        RelationTypeSchemaDescriptor index2 = SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{3});
        RelationTypeSchemaDescriptor index3 = SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{2, 3});
        RelationTypeSchemaDescriptor index4 = SchemaDescriptorFactory.forRelType((int)1, (int[])new int[]{3});
        List<RelationTypeSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index4);
        MatcherAssert.assertThat((Object)Iterables.map(IndexEntryUpdate::indexKey, (Iterable)propertyUpdates.forIndexKeys(indexes)), (Matcher)Matchers.containsInAnyOrder((Object[])new RelationTypeSchemaDescriptor[]{index1, index2, index3}));
    }

    EntityUpdates add(long nodeId, int propertyKeyId, Object value, long[] labels) {
        return EntityUpdates.forEntity((long)nodeId).withTokens(labels).added(propertyKeyId, Values.of((Object)value)).build();
    }

    private void createAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair = this.graphDb.createNode(new Label[]{this.label});
            this.alistair.setProperty("name", (Object)"Alistair");
            this.alistair.setProperty("country", (Object)"UK");
            this.stefan = this.graphDb.createNode(new Label[]{this.label});
            this.stefan.setProperty("name", (Object)"Stefan");
            this.stefan.setProperty("country", (Object)"Deutschland");
            this.aKnowsS = this.alistair.createRelationshipTo(this.stefan, this.relationshipType);
            this.aKnowsS.setProperty("duration", (Object)"long");
            this.aKnowsS.setProperty("irrelevant", (Object)"prop");
            this.sKnowsA = this.stefan.createRelationshipTo(this.alistair, this.relationshipType);
            this.sKnowsA.setProperty("duration", (Object)"lengthy");
            this.sKnowsA.setProperty("irrelevant", (Object)"prop");
            tx.success();
        }
    }

    private void deleteAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.aKnowsS.delete();
            this.sKnowsA.delete();
            this.alistair.delete();
            this.stefan.delete();
            tx.success();
        }
    }

    private void getOrCreateIds() throws KernelException {
        try (Transaction tx = this.graphDb.beginTx();){
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)this.graphDb.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            TokenWrite tokenWrite = bridge.getKernelTransactionBoundToThisThread(true).tokenWrite();
            this.labelId = tokenWrite.labelGetOrCreateForName("Person");
            this.relTypeId = tokenWrite.relationshipTypeGetOrCreateForName("Knows");
            this.propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName("name");
            this.relPropertyKeyId = tokenWrite.propertyKeyGetOrCreateForName("duration");
            tx.success();
        }
    }

    class EntityUpdateCollectingVisitor
    implements Visitor<EntityUpdates, Exception> {
        private final Set<EntityUpdates> updates = new HashSet<EntityUpdates>();

        EntityUpdateCollectingVisitor() {
        }

        public boolean visit(EntityUpdates propertyUpdates) {
            this.updates.add(propertyUpdates);
            return false;
        }

        Set<EntityUpdates> getUpdates() {
            return this.updates;
        }
    }

    private static class CopyUpdateVisitor
    implements Visitor<EntityUpdates, RuntimeException> {
        private EntityUpdates propertyUpdates;

        private CopyUpdateVisitor() {
        }

        public boolean visit(EntityUpdates element) throws RuntimeException {
            this.propertyUpdates = element;
            return true;
        }

        public EntityUpdates getPropertyUpdates() {
            return this.propertyUpdates;
        }
    }
}

