/*
 * Decompiled with CFR 0.152.
 */
package visibility;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestDatasourceCommitOrderDataVisibility {
    private static final String INDEX_NAME = "foo";
    private static final String INDEX_KEY = "bar";
    private static final String INDEX_VALUE = "baz";
    private static final String PROPERTY_NAME = "quux";
    private static final int PROPERTY_VALUE = 42;
    private GraphDatabaseService graphDatabaseService;

    @Before
    public void setUp() {
        this.graphDatabaseService = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void tearDown() {
        this.graphDatabaseService.shutdown();
    }

    @Test
    public void shouldNotMakeIndexWritesVisibleUntilCommit() throws Exception {
        Node commonNode;
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            commonNode = this.graphDatabaseService.createNode();
            tx.success();
        }
        var3_2 = null;
        try (Transaction transaction = this.graphDatabaseService.beginTx();){
            this.graphDatabaseService.index().forNodes(INDEX_NAME).add((PropertyContainer)commonNode, INDEX_KEY, (Object)INDEX_VALUE);
            commonNode.setProperty(PROPERTY_NAME, (Object)42);
            this.assertNodeIsNotIndexedOutsideThisTransaction();
            this.assertNodeIsUnchangedOutsideThisTransaction(commonNode);
            transaction.success();
            this.assertNodeIsNotIndexedOutsideThisTransaction();
            this.assertNodeIsUnchangedOutsideThisTransaction(commonNode);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        this.assertNodeIsIndexed(commonNode);
        this.assertNodeHasBeenUpdated(commonNode);
    }

    private void assertNodeIsNotIndexedOutsideThisTransaction() throws Exception {
        HashSet problems = new HashSet();
        Thread thread = new Thread(() -> {
            try (Transaction ignored = this.graphDatabaseService.beginTx();
                 IndexHits indexHits = this.graphDatabaseService.index().forNodes(INDEX_NAME).get(INDEX_KEY, (Object)INDEX_VALUE);){
                Assert.assertThat((Object)indexHits.size(), (Matcher)Is.is((Object)0));
            }
            catch (Throwable t) {
                problems.add(new Exception(t));
            }
        });
        thread.start();
        thread.join();
        if (problems.size() > 0) {
            throw (Exception)problems.iterator().next();
        }
    }

    private void assertNodeIsUnchangedOutsideThisTransaction(Node commonNode) throws Exception {
        HashSet problems = new HashSet();
        Thread thread = new Thread(() -> {
            try (Transaction ignored = this.graphDatabaseService.beginTx();){
                Assert.assertThat((Object)commonNode.hasProperty(PROPERTY_NAME), (Matcher)Is.is((Object)false));
            }
            catch (Throwable t) {
                problems.add(new Exception(t));
            }
        });
        thread.start();
        thread.join();
        if (problems.size() > 0) {
            throw (Exception)problems.iterator().next();
        }
    }

    private void assertNodeIsIndexed(Node commonNode) throws Exception {
        HashSet problems = new HashSet();
        Thread thread = new Thread(() -> {
            try (Transaction ignored = this.graphDatabaseService.beginTx();){
                Node node = (Node)this.graphDatabaseService.index().forNodes(INDEX_NAME).get(INDEX_KEY, (Object)INDEX_VALUE).getSingle();
                Assert.assertThat((Object)node, (Matcher)Is.is((Object)commonNode));
            }
            catch (Throwable t) {
                problems.add(new Exception(t));
            }
        });
        thread.start();
        thread.join();
        if (problems.size() > 0) {
            throw (Exception)problems.iterator().next();
        }
    }

    private void assertNodeHasBeenUpdated(Node commonNode) throws Exception {
        HashSet problems = new HashSet();
        Thread thread = new Thread(() -> {
            try (Transaction ignored = this.graphDatabaseService.beginTx();){
                Assert.assertThat((Object)commonNode.getProperty(PROPERTY_NAME), (Matcher)Is.is((Object)42));
            }
            catch (Throwable t) {
                problems.add(new Exception(t));
            }
        });
        thread.start();
        thread.join();
        if (problems.size() > 0) {
            throw (Exception)problems.iterator().next();
        }
    }
}

