/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public abstract class CompositeIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public CompositeIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByString() throws Exception {
        this.testIndexScanAndSeekExactWithExact("a", "b");
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByNumber() throws Exception {
        this.testIndexScanAndSeekExactWithExact(333, 101);
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByBoolean() throws Exception {
        this.testIndexScanAndSeekExactWithExact(true, false);
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByTemporal() throws Exception {
        this.testIndexScanAndSeekExactWithExact((Value)DateValue.epochDate((long)303L), (Value)DateValue.epochDate((long)101L));
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByStringArray() throws Exception {
        this.testIndexScanAndSeekExactWithExact(new String[]{"a", "c"}, new String[]{"b", "c"});
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByNumberArray() throws Exception {
        this.testIndexScanAndSeekExactWithExact(new int[]{333, 900}, new int[]{101, 900});
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByBooleanArray() throws Exception {
        this.testIndexScanAndSeekExactWithExact(new boolean[]{true, true}, new boolean[]{false, true});
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByTemporalArray() throws Exception {
        this.testIndexScanAndSeekExactWithExact((Value)CompositeIndexAccessorCompatibility.dateArray(333, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(101, 900));
    }

    private void testIndexScanAndSeekExactWithExact(Object a, Object b) throws Exception {
        this.testIndexScanAndSeekExactWithExact(Values.of((Object)a), Values.of((Object)b));
    }

    private void testIndexScanAndSeekExactWithExact(Value a, Value b) throws Exception {
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), a, a), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), b, b), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), a, b)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)a), IndexQueryHelper.exact((int)1, (Value)a)), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)b), IndexQueryHelper.exact((int)1, (Value)b)), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)a), IndexQueryHelper.exact((int)1, (Value)b)), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
    }

    @Test
    public void testIndexScanAndSeekExactWithExactByPoint() throws Exception {
        Assume.assumeTrue((String)"Assume support for spatial", (boolean)this.testSuite.supportsSpatial());
        PointValue gps = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.6, 56.7});
        PointValue car = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{12.6, 56.7});
        PointValue gps3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.6, 56.7, 100.0});
        PointValue car3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{12.6, 56.7, 100.0});
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), (Value)gps, (Value)gps), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), (Value)car, (Value)car), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), (Value)gps, (Value)car), CompositeIndexAccessorCompatibility.add(4L, this.descriptor.schema(), (Value)gps3d, (Value)gps3d), CompositeIndexAccessorCompatibility.add(5L, this.descriptor.schema(), (Value)car3d, (Value)car3d), CompositeIndexAccessorCompatibility.add(6L, this.descriptor.schema(), (Value)gps, (Value)car3d)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)gps), IndexQueryHelper.exact((int)1, (Value)gps)), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)car), IndexQueryHelper.exact((int)1, (Value)car)), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)gps), IndexQueryHelper.exact((int)1, (Value)car)), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)gps3d), IndexQueryHelper.exact((int)1, (Value)gps3d)), (Matcher)Matchers.equalTo(Collections.singletonList(4L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)car3d), IndexQueryHelper.exact((int)1, (Value)car3d)), (Matcher)Matchers.equalTo(Collections.singletonList(5L)));
        Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)gps), IndexQueryHelper.exact((int)1, (Value)car3d)), (Matcher)Matchers.equalTo(Collections.singletonList(6L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L)));
    }

    @Test
    public void testIndexSeekExactWithRangeByString() throws Exception {
        this.testIndexSeekExactWithRange(Values.of((Object)"a"), Values.of((Object)"b"), Values.of((Object)"Anabelle"), Values.of((Object)"Anna"), Values.of((Object)"Bob"), Values.of((Object)"Harriet"), Values.of((Object)"William"));
    }

    @Test
    public void testIndexSeekExactWithRangeByNumber() throws Exception {
        this.testIndexSeekExactWithRange(Values.of((Object)303), Values.of((Object)101), Values.of((Object)111), Values.of((Object)222), Values.of((Object)333), Values.of((Object)444), Values.of((Object)555));
    }

    @Test
    public void testIndexSeekExactWithRangeByTemporal() throws Exception {
        this.testIndexSeekExactWithRange((Value)DateValue.epochDate((long)303L), (Value)DateValue.epochDate((long)101L), (Value)DateValue.epochDate((long)111L), (Value)DateValue.epochDate((long)222L), (Value)DateValue.epochDate((long)333L), (Value)DateValue.epochDate((long)444L), (Value)DateValue.epochDate((long)555L));
    }

    @Test
    public void testIndexSeekExactWithRangeByBoolean() throws Exception {
        Assume.assumeTrue((String)"Assume support for boolean range queries", (boolean)this.testSuite.supportsBooleanRangeQueries());
        this.testIndexSeekExactWithRangeByBooleanType((Value)BooleanValue.TRUE, (Value)BooleanValue.FALSE, (Value)BooleanValue.FALSE, (Value)BooleanValue.TRUE);
    }

    @Test
    public void testIndexSeekExactWithRangeByStringArray() throws Exception {
        this.testIndexSeekExactWithRange((Value)Values.stringArray((String[])new String[]{"a", "c"}), (Value)Values.stringArray((String[])new String[]{"b", "c"}), (Value)Values.stringArray((String[])new String[]{"Anabelle", "c"}), (Value)Values.stringArray((String[])new String[]{"Anna", "c"}), (Value)Values.stringArray((String[])new String[]{"Bob", "c"}), (Value)Values.stringArray((String[])new String[]{"Harriet", "c"}), (Value)Values.stringArray((String[])new String[]{"William", "c"}));
    }

    @Test
    public void testIndexSeekExactWithRangeByNumberArray() throws Exception {
        this.testIndexSeekExactWithRange((Value)Values.longArray((long[])new long[]{333L, 9000L}), (Value)Values.longArray((long[])new long[]{101L, 900L}), (Value)Values.longArray((long[])new long[]{111L, 900L}), (Value)Values.longArray((long[])new long[]{222L, 900L}), (Value)Values.longArray((long[])new long[]{333L, 900L}), (Value)Values.longArray((long[])new long[]{444L, 900L}), (Value)Values.longArray((long[])new long[]{555L, 900L}));
    }

    @Test
    public void testIndexSeekExactWithRangeByBooleanArray() throws Exception {
        this.testIndexSeekExactWithRange((Value)Values.booleanArray((boolean[])new boolean[]{true, true}), (Value)Values.booleanArray((boolean[])new boolean[]{false, false}), (Value)Values.booleanArray((boolean[])new boolean[]{false, false}), (Value)Values.booleanArray((boolean[])new boolean[]{false, true}), (Value)Values.booleanArray((boolean[])new boolean[]{true, false}), (Value)Values.booleanArray((boolean[])new boolean[]{true, true}), (Value)Values.booleanArray((boolean[])new boolean[]{true, true, true}));
    }

    @Test
    public void testIndexSeekExactWithRangeByTemporalArray() throws Exception {
        this.testIndexSeekExactWithRange((Value)CompositeIndexAccessorCompatibility.dateArray(303, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(101, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(111, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(222, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(333, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(444, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(555, 900));
    }

    @Test
    public void testIndexSeekExactWithRangeBySpatial() throws Exception {
        this.testIndexSeekExactWithRange((Value)Values.intValue((int)100), (Value)Values.intValue((int)10), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-10.0, -10.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-1.0, -1.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 1.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{10.0, 10.0}));
    }

    private void testIndexSeekExactWithRange(Value base1, Value base2, Value obj1, Value obj2, Value obj3, Value obj4, Value obj5) throws Exception {
        Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), base1, obj1), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), base1, obj2), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), base1, obj3), CompositeIndexAccessorCompatibility.add(4L, this.descriptor.schema(), base1, obj4), CompositeIndexAccessorCompatibility.add(5L, this.descriptor.schema(), base1, obj5), CompositeIndexAccessorCompatibility.add(6L, this.descriptor.schema(), base2, obj1), CompositeIndexAccessorCompatibility.add(7L, this.descriptor.schema(), base2, obj2), CompositeIndexAccessorCompatibility.add(8L, this.descriptor.schema(), base2, obj3), CompositeIndexAccessorCompatibility.add(9L, this.descriptor.schema(), base2, obj4), CompositeIndexAccessorCompatibility.add(10L, this.descriptor.schema(), base2, obj5)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj2, (boolean)true, (Value)obj4, (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(2L, 3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj4, (boolean)true, null, (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(4L, 5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj4, (boolean)false, null, (boolean)true)}), (Matcher)Matchers.equalTo(Collections.singletonList(5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj5, (boolean)false, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, null, (boolean)false, (Value)obj3, (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, null, (boolean)true, (Value)obj3, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj3, (boolean)false)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj2, (boolean)true, (Value)obj4, (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(7L, 8L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj4, (boolean)true, null, (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(9L, 10L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj4, (boolean)false, null, (boolean)true)}), (Matcher)Matchers.equalTo(Collections.singletonList(10L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj5, (boolean)false, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, null, (boolean)false, (Value)obj3, (boolean)false)}), (Matcher)Matchers.equalTo(Arrays.asList(6L, 7L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, null, (boolean)true, (Value)obj3, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(6L, 7L, 8L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo(Collections.singletonList(7L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj3, (boolean)false)}), (Matcher)Matchers.equalTo(Collections.singletonList(7L)));
        ValueGroup valueGroup = obj1.valueGroup();
        if (valueGroup != ValueGroup.GEOMETRY && valueGroup != ValueGroup.GEOMETRY_ARRAY) {
            Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (ValueGroup)valueGroup)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (ValueGroup)valueGroup)}), (Matcher)Matchers.equalTo(Arrays.asList(6L, 7L, 8L, 9L, 10L)));
        } else {
            CoordinateReferenceSystem crs = this.getCrs(obj1);
            Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (CoordinateReferenceSystem)crs)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
            Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (CoordinateReferenceSystem)crs)}), (Matcher)Matchers.equalTo(Arrays.asList(6L, 7L, 8L, 9L, 10L)));
        }
    }

    private CoordinateReferenceSystem getCrs(Value value) {
        if (Values.isGeometryValue((Value)value)) {
            return ((PointValue)value).getCoordinateReferenceSystem();
        }
        if (Values.isGeometryArray((Value)value)) {
            PointArray array = (PointArray)value;
            return array.pointValue(0).getCoordinateReferenceSystem();
        }
        throw new IllegalArgumentException("Expected some geometry value to get CRS from, but got " + value);
    }

    private void testIndexSeekExactWithRangeByBooleanType(Value base1, Value base2, Value obj1, Value obj2) throws Exception {
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), base1, obj1), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), base1, obj2), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), base2, obj1), CompositeIndexAccessorCompatibility.add(4L, this.descriptor.schema(), base2, obj2)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj1, (boolean)true, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj1, (boolean)true, (Value)obj2, (boolean)false)}), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)false)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, null, (boolean)true, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj1, (boolean)true, null, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (ValueGroup)obj1.valueGroup())}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base1), IndexQuery.range((int)1, (Value)obj2, (boolean)true, (Value)obj1, (boolean)true)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj1, (boolean)true, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo(Collections.singletonList(4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj1, (boolean)true, (Value)obj2, (boolean)false)}), (Matcher)Matchers.equalTo(Collections.singletonList(3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)false)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, null, (boolean)true, (Value)obj2, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj1, (boolean)true, null, (boolean)true)}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (ValueGroup)obj1.valueGroup())}), (Matcher)Matchers.equalTo(Arrays.asList(3L, 4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)base2), IndexQuery.range((int)1, (Value)obj2, (boolean)true, (Value)obj1, (boolean)true)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
    }

    @Test
    public void testIndexSeekExactWithPrefixRangeByString() throws Exception {
        Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), "a", "a"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), "a", "A"), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), "a", "apa"), CompositeIndexAccessorCompatibility.add(4L, this.descriptor.schema(), "a", "apA"), CompositeIndexAccessorCompatibility.add(5L, this.descriptor.schema(), "a", "b"), CompositeIndexAccessorCompatibility.add(6L, this.descriptor.schema(), "b", "a"), CompositeIndexAccessorCompatibility.add(7L, this.descriptor.schema(), "b", "A"), CompositeIndexAccessorCompatibility.add(8L, this.descriptor.schema(), "b", "apa"), CompositeIndexAccessorCompatibility.add(9L, this.descriptor.schema(), "b", "apA"), CompositeIndexAccessorCompatibility.add(10L, this.descriptor.schema(), "b", "b")));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Object)"a"), IndexQuery.stringPrefix((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Object)"a"), IndexQuery.stringPrefix((int)1, (String)"A")}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Object)"a"), IndexQuery.stringPrefix((int)1, (String)"ba")}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Object)"a"), IndexQuery.stringPrefix((int)1, (String)"")}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Object)"b"), IndexQuery.stringPrefix((int)1, (String)"a")}), (Matcher)Matchers.equalTo(Arrays.asList(6L, 8L, 9L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Object)"b"), IndexQuery.stringPrefix((int)1, (String)"A")}), (Matcher)Matchers.equalTo(Collections.singletonList(7L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Object)"b"), IndexQuery.stringPrefix((int)1, (String)"ba")}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Object)"b"), IndexQuery.stringPrefix((int)1, (String)"")}), (Matcher)Matchers.equalTo(Arrays.asList(6L, 7L, 8L, 9L, 10L)));
    }

    @Test
    public void testIndexSeekPrefixRangeWithExistsByString() throws Exception {
        Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), "a", 1), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), "A", DateValue.epochDate((long)2L)), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), "apa", "..."), CompositeIndexAccessorCompatibility.add(4L, this.descriptor.schema(), "apA", "someString"), CompositeIndexAccessorCompatibility.add(5L, this.descriptor.schema(), "b", true), CompositeIndexAccessorCompatibility.add(6L, this.descriptor.schema(), "a", 100), CompositeIndexAccessorCompatibility.add(7L, this.descriptor.schema(), "A", DateValue.epochDate((long)200L)), CompositeIndexAccessorCompatibility.add(8L, this.descriptor.schema(), "apa", "!!!"), CompositeIndexAccessorCompatibility.add(9L, this.descriptor.schema(), "apA", "someOtherString"), CompositeIndexAccessorCompatibility.add(10L, this.descriptor.schema(), "b", false)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)0, (String)"a"), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L, 4L, 6L, 8L, 9L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)0, (String)"A"), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(2L, 7L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)0, (String)"ba"), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.stringPrefix((int)0, (String)""), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L)));
    }

    @Test
    public void testIndexSeekExactWithExistsByString() throws Exception {
        this.testIndexSeekExactWithExists("a", "b");
    }

    @Test
    public void testIndexSeekExactWithExistsByNumber() throws Exception {
        this.testIndexSeekExactWithExists(303, 101);
    }

    @Test
    public void testIndexSeekExactWithExistsByTemporal() throws Exception {
        this.testIndexSeekExactWithExists((Value)DateValue.epochDate((long)303L), (Value)DateValue.epochDate((long)101L));
    }

    @Test
    public void testIndexSeekExactWithExistsByBoolean() throws Exception {
        this.testIndexSeekExactWithExists(true, false);
    }

    @Test
    public void testIndexSeekExactWithExistsByStringArray() throws Exception {
        this.testIndexSeekExactWithExists(new String[]{"a", "c"}, new String[]{"b", "c"});
    }

    @Test
    public void testIndexSeekExactWithExistsByNumberArray() throws Exception {
        this.testIndexSeekExactWithExists(new long[]{303L, 900L}, new long[]{101L, 900L});
    }

    @Test
    public void testIndexSeekExactWithExistsByBooleanArray() throws Exception {
        this.testIndexSeekExactWithExists(new boolean[]{true, true}, new boolean[]{false, true});
    }

    @Test
    public void testIndexSeekExactWithExistsByTemporalArray() throws Exception {
        this.testIndexSeekExactWithExists((Value)CompositeIndexAccessorCompatibility.dateArray(303, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(101, 900));
    }

    @Test
    public void testIndexSeekExactWithExistsBySpatial() throws Exception {
        this.testIndexSeekExactWithExists((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{100.0, 100.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}));
    }

    @Test
    public void testIndexSeekExactWithExistsBySpatialArray() throws Exception {
        this.testIndexSeekExactWithExists((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{100.0, 100.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{101.0, 101.0})}), (Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0})}));
    }

    private void testIndexSeekExactWithExists(Object a, Object b) throws Exception {
        this.testIndexSeekExactWithExists(Values.of((Object)a), Values.of((Object)b));
    }

    private void testIndexSeekExactWithExists(Value a, Value b) throws Exception {
        Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), a, Values.of((Object)1)), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), b, Values.of((Object)"abv")), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), a, Values.of((Object)false))));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)a), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQueryHelper.exact((int)0, (Value)b), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
    }

    @Test
    public void testIndexSeekRangeWithExistsByString() throws Exception {
        this.testIndexSeekRangeWithExists("Anabelle", "Anna", "Bob", "Harriet", "William");
    }

    @Test
    public void testIndexSeekRangeWithExistsByNumber() throws Exception {
        this.testIndexSeekRangeWithExists(-5, 0, 5.5, 10.0, 100.0);
    }

    @Test
    public void testIndexSeekRangeWithExistsByTemporal() throws Exception {
        DateTimeValue d1 = DateTimeValue.datetime((long)9999L, (long)100L, (ZoneId)ZoneId.of("+18:00"));
        DateTimeValue d2 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("UTC"));
        DateTimeValue d3 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+01:00"));
        DateTimeValue d4 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("Europe/Stockholm"));
        DateTimeValue d5 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+03:00"));
        this.testIndexSeekRangeWithExists((Value)d1, (Value)d2, (Value)d3, (Value)d4, (Value)d5);
    }

    @Test
    public void testIndexSeekRangeWithExistsByBoolean() throws Exception {
        Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
        Assume.assumeTrue((String)"Assume support for boolean range queries", (boolean)this.testSuite.supportsBooleanRangeQueries());
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), false, "someString"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), true, 1000)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)true, (Value)BooleanValue.TRUE, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)false, (Value)BooleanValue.TRUE, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)true, (Value)BooleanValue.TRUE, (boolean)false), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Collections.singletonList(1L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)false, (Value)BooleanValue.TRUE, (boolean)false), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, null, (boolean)true, (Value)BooleanValue.TRUE, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)true, null, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)BooleanValue.TRUE, (boolean)true, (Value)BooleanValue.FALSE, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
    }

    @Test
    public void testIndexSeekRangeWithExistsByStringArray() throws Exception {
        this.testIndexSeekRangeWithExists(new String[]{"Anabelle", "Anabelle"}, new String[]{"Anabelle", "Anablo"}, new String[]{"Anna", "Anabelle"}, new String[]{"Anna", "Anablo"}, new String[]{"Bob"});
    }

    @Test
    public void testIndexSeekRangeWithExistsByNumberArray() throws Exception {
        this.testIndexSeekRangeWithExists(new long[]{303L, 303L}, new long[]{303L, 404L}, new long[]{600L, 303L}, new long[]{600L, 404L}, new long[]{900L});
    }

    @Test
    public void testIndexSeekRangeWithExistsByBooleanArray() throws Exception {
        this.testIndexSeekRangeWithExists(new boolean[]{false, false}, new boolean[]{false, true}, new boolean[]{true, false}, new boolean[]{true, true}, new boolean[]{true, true, false});
    }

    @Test
    public void testIndexSeekRangeWithExistsByTemporalArray() throws Exception {
        this.testIndexSeekRangeWithExists((Value)CompositeIndexAccessorCompatibility.dateArray(303, 303), (Value)CompositeIndexAccessorCompatibility.dateArray(303, 404), (Value)CompositeIndexAccessorCompatibility.dateArray(404, 303), (Value)CompositeIndexAccessorCompatibility.dateArray(404, 404), (Value)CompositeIndexAccessorCompatibility.dateArray(404, 404, 303));
    }

    @Test
    public void testIndexSeekRangeWithExistsBySpatial() throws Exception {
        this.testIndexSeekRangeWithExists((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{2.0, 2.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{3.0, 3.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{4.0, 4.0}));
    }

    @Test
    public void testIndexSeekRangeWithExistsBySpatialArray() throws Exception {
        this.testIndexSeekRangeWithExists((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 1.0})}), (Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{10.0, 1.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{10.0, 2.0})}), (Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{20.0, 2.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{20.0, 3.0})}), (Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{30.0, 3.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{30.0, 4.0})}), (Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{40.0, 4.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{40.0, 5.0})}));
    }

    @Test
    public void testExactMatchOnRandomCompositeValues() throws Exception {
        ValueType[] types = this.randomSetOfSupportedTypes();
        ArrayList updates = new ArrayList();
        HashSet<ValueTuple> duplicateChecker = new HashSet<ValueTuple>();
        for (long id = 0L; id < 10000L; ++id) {
            IndexEntryUpdate<SchemaDescriptor> update;
            while (!duplicateChecker.add(ValueTuple.of((Value[])(update = CompositeIndexAccessorCompatibility.add(id, this.descriptor.schema(), this.random.randomValues().nextValueOfTypes(types), this.random.randomValues().nextValueOfTypes(types))).values()))) {
            }
            updates.add(update);
        }
        this.updateAndCommit(updates);
        for (IndexEntryUpdate indexEntryUpdate : updates) {
            List<Long> hits = this.query(IndexQueryHelper.exact((int)0, (Value)indexEntryUpdate.values()[0]), IndexQueryHelper.exact((int)1, (Value)indexEntryUpdate.values()[1]));
            Assert.assertEquals((String)(indexEntryUpdate + " " + hits.toString()), (long)1L, (long)hits.size());
            Assert.assertThat((Object)Iterables.single(hits), (Matcher)Matchers.equalTo((Object)indexEntryUpdate.getEntityId()));
        }
    }

    private void testIndexSeekRangeWithExists(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) throws Exception {
        this.testIndexSeekRangeWithExists(Values.of((Object)obj1), Values.of((Object)obj2), Values.of((Object)obj3), Values.of((Object)obj4), Values.of((Object)obj5));
    }

    private void testIndexSeekRangeWithExists(Value obj1, Value obj2, Value obj3, Value obj4, Value obj5) throws Exception {
        Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), obj1, Values.of((Object)100)), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), obj2, Values.of((Object)"someString")), CompositeIndexAccessorCompatibility.add(3L, this.descriptor.schema(), obj3, Values.of((Object)DateValue.epochDate((long)300L))), CompositeIndexAccessorCompatibility.add(4L, this.descriptor.schema(), obj4, Values.of((Object)true)), CompositeIndexAccessorCompatibility.add(5L, this.descriptor.schema(), obj5, Values.of((Object)42))));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)obj2, (boolean)true, (Value)obj4, (boolean)false), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(2L, 3L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)obj4, (boolean)true, null, (boolean)false), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(4L, 5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)obj4, (boolean)false, null, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Collections.singletonList(5L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)obj5, (boolean)false, (Value)obj2, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo((Object)Collections.EMPTY_LIST));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, null, (boolean)false, (Value)obj3, (boolean)false), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, null, (boolean)true, (Value)obj3, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L)));
        ValueGroup valueGroup = obj1.valueGroup();
        if (valueGroup != ValueGroup.GEOMETRY && valueGroup != ValueGroup.GEOMETRY_ARRAY) {
            Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (ValueGroup)obj1.valueGroup()), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 4L, 5L)));
        }
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
        Assert.assertThat(this.query(new IndexQuery[]{IndexQuery.range((int)0, (Value)obj1, (boolean)false, (Value)obj3, (boolean)false), IndexQuery.exists((int)1)}), (Matcher)Matchers.equalTo(Collections.singletonList(2L)));
    }

    @Test
    public void shouldRangeSeekInOrderNumberAscending() throws Exception {
        Integer o0 = 0;
        Integer o1 = 1;
        Integer o2 = 2;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderNumberDescending() throws Exception {
        Integer o0 = 0;
        Integer o1 = 1;
        Integer o2 = 2;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderStringAscending() throws Exception {
        String o0 = "0";
        String o1 = "1";
        String o2 = "2";
        String o3 = "3";
        String o4 = "4";
        String o5 = "5";
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderStringDescending() throws Exception {
        String o0 = "0";
        String o1 = "1";
        String o2 = "2";
        String o3 = "3";
        String o4 = "4";
        String o5 = "5";
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingDate() throws Exception {
        LocalDate o0 = DateValue.epochDateRaw((long)0L);
        LocalDate o1 = DateValue.epochDateRaw((long)1L);
        LocalDate o2 = DateValue.epochDateRaw((long)2L);
        LocalDate o3 = DateValue.epochDateRaw((long)3L);
        LocalDate o4 = DateValue.epochDateRaw((long)4L);
        LocalDate o5 = DateValue.epochDateRaw((long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingDate() throws Exception {
        LocalDate o0 = DateValue.epochDateRaw((long)0L);
        LocalDate o1 = DateValue.epochDateRaw((long)1L);
        LocalDate o2 = DateValue.epochDateRaw((long)2L);
        LocalDate o3 = DateValue.epochDateRaw((long)3L);
        LocalDate o4 = DateValue.epochDateRaw((long)4L);
        LocalDate o5 = DateValue.epochDateRaw((long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingLocalTime() throws Exception {
        LocalTime o0 = LocalTimeValue.localTimeRaw((long)0L);
        LocalTime o1 = LocalTimeValue.localTimeRaw((long)1L);
        LocalTime o2 = LocalTimeValue.localTimeRaw((long)2L);
        LocalTime o3 = LocalTimeValue.localTimeRaw((long)3L);
        LocalTime o4 = LocalTimeValue.localTimeRaw((long)4L);
        LocalTime o5 = LocalTimeValue.localTimeRaw((long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingLocalTime() throws Exception {
        LocalTime o0 = LocalTimeValue.localTimeRaw((long)0L);
        LocalTime o1 = LocalTimeValue.localTimeRaw((long)1L);
        LocalTime o2 = LocalTimeValue.localTimeRaw((long)2L);
        LocalTime o3 = LocalTimeValue.localTimeRaw((long)3L);
        LocalTime o4 = LocalTimeValue.localTimeRaw((long)4L);
        LocalTime o5 = LocalTimeValue.localTimeRaw((long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingTime() throws Exception {
        OffsetTime o0 = TimeValue.timeRaw((long)0L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o1 = TimeValue.timeRaw((long)1L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o2 = TimeValue.timeRaw((long)2L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o3 = TimeValue.timeRaw((long)3L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o4 = TimeValue.timeRaw((long)4L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o5 = TimeValue.timeRaw((long)5L, (ZoneOffset)ZoneOffset.ofHours(0));
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingTime() throws Exception {
        OffsetTime o0 = TimeValue.timeRaw((long)0L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o1 = TimeValue.timeRaw((long)1L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o2 = TimeValue.timeRaw((long)2L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o3 = TimeValue.timeRaw((long)3L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o4 = TimeValue.timeRaw((long)4L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o5 = TimeValue.timeRaw((long)5L, (ZoneOffset)ZoneOffset.ofHours(0));
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingLocalDateTime() throws Exception {
        LocalDateTime o0 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)0L);
        LocalDateTime o1 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)1L);
        LocalDateTime o2 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)2L);
        LocalDateTime o3 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)3L);
        LocalDateTime o4 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)4L);
        LocalDateTime o5 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingLocalDateTime() throws Exception {
        LocalDateTime o0 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)0L);
        LocalDateTime o1 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)1L);
        LocalDateTime o2 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)2L);
        LocalDateTime o3 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)3L);
        LocalDateTime o4 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)4L);
        LocalDateTime o5 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingDateTime() throws Exception {
        ZonedDateTime o0 = DateTimeValue.datetimeRaw((long)1L, (long)0L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o1 = DateTimeValue.datetimeRaw((long)1L, (long)1L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o2 = DateTimeValue.datetimeRaw((long)1L, (long)2L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o3 = DateTimeValue.datetimeRaw((long)1L, (long)3L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o4 = DateTimeValue.datetimeRaw((long)1L, (long)4L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o5 = DateTimeValue.datetimeRaw((long)1L, (long)5L, (ZoneId)ZoneId.of("UTC"));
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingDateTime() throws Exception {
        ZonedDateTime o0 = DateTimeValue.datetimeRaw((long)1L, (long)0L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o1 = DateTimeValue.datetimeRaw((long)1L, (long)1L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o2 = DateTimeValue.datetimeRaw((long)1L, (long)2L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o3 = DateTimeValue.datetimeRaw((long)1L, (long)3L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o4 = DateTimeValue.datetimeRaw((long)1L, (long)4L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o5 = DateTimeValue.datetimeRaw((long)1L, (long)5L, (ZoneId)ZoneId.of("UTC"));
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingDuration() throws Exception {
        Duration o0 = Duration.ofMillis(0L);
        Duration o1 = Duration.ofMillis(1L);
        Duration o2 = Duration.ofMillis(2L);
        Duration o3 = Duration.ofMillis(3L);
        Duration o4 = Duration.ofMillis(4L);
        Duration o5 = Duration.ofMillis(5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingDuration() throws Exception {
        Duration o0 = Duration.ofMillis(0L);
        Duration o1 = Duration.ofMillis(1L);
        Duration o2 = Duration.ofMillis(2L);
        Duration o3 = Duration.ofMillis(3L);
        Duration o4 = Duration.ofMillis(4L);
        Duration o5 = Duration.ofMillis(5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingNumberArray() throws Exception {
        int[] o0 = new int[]{0};
        int[] o1 = new int[]{1};
        int[] o2 = new int[]{2};
        int[] o3 = new int[]{3};
        int[] o4 = new int[]{4};
        int[] o5 = new int[]{5};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingNumberArray() throws Exception {
        int[] o0 = new int[]{0};
        int[] o1 = new int[]{1};
        int[] o2 = new int[]{2};
        int[] o3 = new int[]{3};
        int[] o4 = new int[]{4};
        int[] o5 = new int[]{5};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingStringArray() throws Exception {
        String[] o0 = new String[]{"0"};
        String[] o1 = new String[]{"1"};
        String[] o2 = new String[]{"2"};
        String[] o3 = new String[]{"3"};
        String[] o4 = new String[]{"4"};
        String[] o5 = new String[]{"5"};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingStringArray() throws Exception {
        String[] o0 = new String[]{"0"};
        String[] o1 = new String[]{"1"};
        String[] o2 = new String[]{"2"};
        String[] o3 = new String[]{"3"};
        String[] o4 = new String[]{"4"};
        String[] o5 = new String[]{"5"};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingBooleanArray() throws Exception {
        boolean[] o0 = new boolean[]{false};
        boolean[] o1 = new boolean[]{false, false};
        boolean[] o2 = new boolean[]{false, true};
        boolean[] o3 = new boolean[]{true};
        boolean[] o4 = new boolean[]{true, false};
        boolean[] o5 = new boolean[]{true, true};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingBooleanArray() throws Exception {
        boolean[] o0 = new boolean[]{false};
        boolean[] o1 = new boolean[]{false, false};
        boolean[] o2 = new boolean[]{false, true};
        boolean[] o3 = new boolean[]{true};
        boolean[] o4 = new boolean[]{true, false};
        boolean[] o5 = new boolean[]{true, true};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingDateTimeArray() throws Exception {
        ZonedDateTime[] o0 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 0, ZoneId.of("UTC"))};
        ZonedDateTime[] o1 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 1, ZoneId.of("UTC"))};
        ZonedDateTime[] o2 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 2, ZoneId.of("UTC"))};
        ZonedDateTime[] o3 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 3, ZoneId.of("UTC"))};
        ZonedDateTime[] o4 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 4, ZoneId.of("UTC"))};
        ZonedDateTime[] o5 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 5, ZoneId.of("UTC"))};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingDateTimeArray() throws Exception {
        ZonedDateTime[] o0 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 0, ZoneId.of("UTC"))};
        ZonedDateTime[] o1 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 1, ZoneId.of("UTC"))};
        ZonedDateTime[] o2 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 2, ZoneId.of("UTC"))};
        ZonedDateTime[] o3 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 3, ZoneId.of("UTC"))};
        ZonedDateTime[] o4 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 4, ZoneId.of("UTC"))};
        ZonedDateTime[] o5 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 5, ZoneId.of("UTC"))};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingLocalDateTimeArray() throws Exception {
        LocalDateTime[] o0 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 0)};
        LocalDateTime[] o1 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 1)};
        LocalDateTime[] o2 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 2)};
        LocalDateTime[] o3 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 3)};
        LocalDateTime[] o4 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 4)};
        LocalDateTime[] o5 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 5)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingLocalDateTimeArray() throws Exception {
        LocalDateTime[] o0 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 0)};
        LocalDateTime[] o1 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 1)};
        LocalDateTime[] o2 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 2)};
        LocalDateTime[] o3 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 3)};
        LocalDateTime[] o4 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 4)};
        LocalDateTime[] o5 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 5)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingTimeArray() throws Exception {
        OffsetTime[] o0 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 0, ZoneOffset.ofHours(0))};
        OffsetTime[] o1 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 1, ZoneOffset.ofHours(0))};
        OffsetTime[] o2 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 2, ZoneOffset.ofHours(0))};
        OffsetTime[] o3 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 3, ZoneOffset.ofHours(0))};
        OffsetTime[] o4 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 4, ZoneOffset.ofHours(0))};
        OffsetTime[] o5 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 5, ZoneOffset.ofHours(0))};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingTimeArray() throws Exception {
        OffsetTime[] o0 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 0, ZoneOffset.ofHours(0))};
        OffsetTime[] o1 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 1, ZoneOffset.ofHours(0))};
        OffsetTime[] o2 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 2, ZoneOffset.ofHours(0))};
        OffsetTime[] o3 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 3, ZoneOffset.ofHours(0))};
        OffsetTime[] o4 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 4, ZoneOffset.ofHours(0))};
        OffsetTime[] o5 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 5, ZoneOffset.ofHours(0))};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingDateArray() throws Exception {
        LocalDate[] o0 = new LocalDate[]{LocalDate.of(10, 10, 1)};
        LocalDate[] o1 = new LocalDate[]{LocalDate.of(10, 10, 2)};
        LocalDate[] o2 = new LocalDate[]{LocalDate.of(10, 10, 3)};
        LocalDate[] o3 = new LocalDate[]{LocalDate.of(10, 10, 4)};
        LocalDate[] o4 = new LocalDate[]{LocalDate.of(10, 10, 5)};
        LocalDate[] o5 = new LocalDate[]{LocalDate.of(10, 10, 6)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingDateArray() throws Exception {
        LocalDate[] o0 = new LocalDate[]{LocalDate.of(10, 10, 1)};
        LocalDate[] o1 = new LocalDate[]{LocalDate.of(10, 10, 2)};
        LocalDate[] o2 = new LocalDate[]{LocalDate.of(10, 10, 3)};
        LocalDate[] o3 = new LocalDate[]{LocalDate.of(10, 10, 4)};
        LocalDate[] o4 = new LocalDate[]{LocalDate.of(10, 10, 5)};
        LocalDate[] o5 = new LocalDate[]{LocalDate.of(10, 10, 6)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingLocalTimeArray() throws Exception {
        LocalTime[] o0 = new LocalTime[]{LocalTime.of(10, 0)};
        LocalTime[] o1 = new LocalTime[]{LocalTime.of(10, 1)};
        LocalTime[] o2 = new LocalTime[]{LocalTime.of(10, 2)};
        LocalTime[] o3 = new LocalTime[]{LocalTime.of(10, 3)};
        LocalTime[] o4 = new LocalTime[]{LocalTime.of(10, 4)};
        LocalTime[] o5 = new LocalTime[]{LocalTime.of(10, 5)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingLocalTimeArray() throws Exception {
        LocalTime[] o0 = new LocalTime[]{LocalTime.of(10, 0)};
        LocalTime[] o1 = new LocalTime[]{LocalTime.of(10, 1)};
        LocalTime[] o2 = new LocalTime[]{LocalTime.of(10, 2)};
        LocalTime[] o3 = new LocalTime[]{LocalTime.of(10, 3)};
        LocalTime[] o4 = new LocalTime[]{LocalTime.of(10, 4)};
        LocalTime[] o5 = new LocalTime[]{LocalTime.of(10, 5)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderAscendingDurationArray() throws Exception {
        Duration[] o0 = new Duration[]{Duration.of(0L, ChronoUnit.SECONDS)};
        Duration[] o1 = new Duration[]{Duration.of(1L, ChronoUnit.SECONDS)};
        Duration[] o2 = new Duration[]{Duration.of(2L, ChronoUnit.SECONDS)};
        Duration[] o3 = new Duration[]{Duration.of(3L, ChronoUnit.SECONDS)};
        Duration[] o4 = new Duration[]{Duration.of(4L, ChronoUnit.SECONDS)};
        Duration[] o5 = new Duration[]{Duration.of(5L, ChronoUnit.SECONDS)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    public void shouldRangeSeekInOrderDescendingDurationArray() throws Exception {
        Duration[] o0 = new Duration[]{Duration.of(0L, ChronoUnit.SECONDS)};
        Duration[] o1 = new Duration[]{Duration.of(1L, ChronoUnit.SECONDS)};
        Duration[] o2 = new Duration[]{Duration.of(2L, ChronoUnit.SECONDS)};
        Duration[] o3 = new Duration[]{Duration.of(3L, ChronoUnit.SECONDS)};
        Duration[] o4 = new Duration[]{Duration.of(4L, ChronoUnit.SECONDS)};
        Duration[] o5 = new Duration[]{Duration.of(5L, ChronoUnit.SECONDS)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    private void shouldSeekInOrderExactWithRange(IndexOrder order, Object o0, Object o1, Object o2, Object o3, Object o4, Object o5) throws Exception {
        Integer baseValue = 1;
        IndexQuery exact = IndexQueryHelper.exact((int)100, (Object)baseValue);
        IndexQuery.RangePredicate range = IndexQuery.range((int)200, (Value)Values.of((Object)o0), (boolean)true, (Value)Values.of((Object)o5), (boolean)true);
        Object[] indexOrders = this.orderCapability(new IndexQuery[]{exact, range});
        Assume.assumeTrue((String)("Assume support for order " + order), (boolean)ArrayUtils.contains((Object[])indexOrders, (Object)order));
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), baseValue, o0), CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), baseValue, o5), CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), baseValue, o1), CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), baseValue, o4), CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), baseValue, o2), CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), baseValue, o3)));
        SimpleNodeValueClient client = new SimpleNodeValueClient();
        try (AutoCloseable ignored = this.query(client, order, new IndexQuery[]{exact, range});){
            List<Long> seenIds = this.assertClientReturnValuesInOrder(client, order);
            Assert.assertThat((Object)seenIds.size(), (Matcher)Matchers.equalTo((Object)6));
        }
    }

    private static ArrayValue dateArray(int ... epochDays) {
        LocalDate[] localDates = new LocalDate[epochDays.length];
        for (int i = 0; i < epochDays.length; ++i) {
            localDates[i] = LocalDate.ofEpochDay(epochDays[i]);
        }
        return Values.dateArray((LocalDate[])localDates);
    }

    private static IndexEntryUpdate<SchemaDescriptor> add(long nodeId, SchemaDescriptor schema, Object value1, Object value2) {
        return CompositeIndexAccessorCompatibility.add(nodeId, schema, Values.of((Object)value1), Values.of((Object)value2));
    }

    private static IndexEntryUpdate<SchemaDescriptor> add(long nodeId, SchemaDescriptor schema, Value value1, Value value2) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)schema, (Value[])new Value[]{value1, value2});
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends CompositeIndexAccessorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, TestIndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), "a", "a"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), "a", "a")));
            Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Object)"a"), IndexQueryHelper.exact((int)1, (Object)"a")), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends CompositeIndexAccessorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, TestIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void testDuplicatesInIndexSeekByString() throws Exception {
            String value = "a";
            this.testDuplicatesInIndexSeek(value);
        }

        @Test
        public void testDuplicatesInIndexSeekByNumber() throws Exception {
            this.testDuplicatesInIndexSeek(333);
        }

        @Test
        public void testDuplicatesInIndexSeekByPoint() throws Exception {
            Assume.assumeTrue((String)"Assume support for spatial", (boolean)this.testSuite.supportsSpatial());
            this.testDuplicatesInIndexSeek((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.6, 56.7}));
        }

        @Test
        public void testDuplicatesInIndexSeekByBoolean() throws Exception {
            this.testDuplicatesInIndexSeek(true);
        }

        @Test
        public void testDuplicatesInIndexSeekByTemporal() throws Exception {
            this.testDuplicatesInIndexSeek(LocalDate.ofEpochDay(303L));
        }

        @Test
        public void testDuplicatesInIndexSeekByStringArray() throws Exception {
            this.testDuplicatesInIndexSeek(new String[]{"anabelle", "anabollo"});
        }

        @Test
        public void testDuplicatesInIndexSeekByNumberArray() throws Exception {
            this.testDuplicatesInIndexSeek(new long[]{303L, 606L});
        }

        @Test
        public void testDuplicatesInIndexSeekByBooleanArray() throws Exception {
            this.testDuplicatesInIndexSeek(new boolean[]{true, false});
        }

        @Test
        public void testDuplicatesInIndexSeekByTemporalArray() throws Exception {
            this.testDuplicatesInIndexSeek((Value)CompositeIndexAccessorCompatibility.dateArray(new int[]{303, 606}));
        }

        @Test
        public void testDuplicatesInIndexSeekByPointArray() throws Exception {
            Assume.assumeTrue((String)"Assume support for spatial", (boolean)this.testSuite.supportsSpatial());
            this.testDuplicatesInIndexSeek((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.6, 56.7}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.6, 56.7})}));
        }

        private void testDuplicatesInIndexSeek(Object value) throws Exception {
            this.testDuplicatesInIndexSeek(Values.of((Object)value));
        }

        private void testDuplicatesInIndexSeek(Value value) throws Exception {
            this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor.schema(), value, value), CompositeIndexAccessorCompatibility.add(2L, this.descriptor.schema(), value, value)));
            Assert.assertThat(this.query(IndexQueryHelper.exact((int)0, (Value)value), IndexQueryHelper.exact((int)1, (Value)value)), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
        }
    }
}

