/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.collections.api.iterator.LongIterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.index.TestNodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.QueryResultComparingIndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class SimpleIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    final IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());

    public SimpleIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Test
    public void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        String failure = "The contrived failure";
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.markAsFailed(failure)), false);
        Assert.assertThat((Object)this.indexProvider.getPopulationFailure(this.descriptor), (Matcher)Matchers.containsString((String)failure));
    }

    @Test
    public void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            String failure = "The contrived failure";
            p.markAsFailed(failure);
            p.close(false);
            Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(this.descriptor));
        }), false);
    }

    @Test
    public void shouldBeAbleToDropAClosedIndexPopulator() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexPopulator p = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig);
        p.close(false);
        p.drop();
    }

    @Test
    public void shouldApplyUpdatesIdempotently() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        Value propertyValue = Values.of((Object)"value1");
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            long nodeId = 1L;
            IndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{propertyValue});
            p.add(Collections.singletonList(update));
            try (IndexUpdater updater = p.newPopulatingUpdater((node, propertyId) -> propertyValue);){
                updater.process(update);
            }
        }));
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, indexSamplingConfig);
             QueryResultComparingIndexReader reader = new QueryResultComparingIndexReader(accessor.newReader());){
            int propertyKeyId = this.descriptor.schema().getPropertyId();
            PrimitiveLongResourceIterator nodes = reader.query(new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)propertyValue)});
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodes));
        }
    }

    @Test
    public void shouldPopulateWithAllValues() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(this.updates(this.valueSet1))));
        this.assertHasAllValues(this.valueSet1);
    }

    @Test
    public void shouldUpdateWithAllValuesDuringPopulation() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            try (IndexUpdater updater = p.newPopulatingUpdater(this::valueSet1Lookup);){
                for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : this.valueSet1) {
                    updater.process(IndexEntryUpdate.add((long)entry.nodeId, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{entry.value}));
                }
            }
        }));
        this.assertHasAllValues(this.valueSet1);
    }

    @Test
    public void shouldPopulateAndUpdate() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(this.updates(this.valueSet1))));
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig);){
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE);){
                List<IndexEntryUpdate<?>> updates = this.updates(this.valueSet2);
                for (IndexEntryUpdate<?> update : updates) {
                    updater.process(update);
                }
            }
            var4_6 = null;
            try (QueryResultComparingIndexReader reader = new QueryResultComparingIndexReader(accessor.newReader());){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : Iterables.concat((Iterable[])new Iterable[]{this.valueSet1, this.valueSet2})) {
                    NodeValueIterator nodes = new NodeValueIterator();
                    reader.query((IndexProgressor.NodeValueClient)nodes, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                    Assert.assertEquals((long)entry.nodeId, (long)nodes.next());
                    Assert.assertFalse((boolean)nodes.hasNext());
                }
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
        }
    }

    private Value valueSet1Lookup(long nodeId, int propertyId) {
        for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue x : this.valueSet1) {
            if (x.nodeId != nodeId) continue;
            return x.value;
        }
        return Values.NO_VALUE;
    }

    private void assertHasAllValues(List<IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> values) throws IOException, IndexNotApplicableKernelException {
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig);
             QueryResultComparingIndexReader reader = new QueryResultComparingIndexReader(accessor.newReader());){
            int propertyKeyId = this.descriptor.schema().getPropertyId();
            for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : values) {
                NodeValueIterator nodes = new NodeValueIterator();
                reader.query((IndexProgressor.NodeValueClient)nodes, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                Assert.assertEquals((long)entry.nodeId, (long)nodes.next());
                Assert.assertFalse((boolean)nodes.hasNext());
            }
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends SimpleIndexPopulatorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, TestIndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void shouldProvidePopulatorThatEnforcesUniqueConstraints() throws Exception {
            Value value = Values.of((Object)"value1");
            int nodeId1 = 1;
            int nodeId2 = 2;
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                try {
                    p.add(Arrays.asList(IndexEntryUpdate.add((long)nodeId1, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{value}), IndexEntryUpdate.add((long)nodeId2, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{value})));
                    TestNodePropertyAccessor propertyAccessor = new TestNodePropertyAccessor((long)nodeId1, this.descriptor.schema(), new Value[]{value});
                    propertyAccessor.addNode((long)nodeId2, this.descriptor.schema(), new Value[]{value});
                    p.verifyDeferredConstraints((NodePropertyAccessor)propertyAccessor);
                    Assert.fail((String)"expected exception");
                }
                catch (Exception e) {
                    Throwable root = Exceptions.rootCause((Throwable)e);
                    if (root instanceof IndexEntryConflictException) {
                        IndexEntryConflictException conflict = (IndexEntryConflictException)root;
                        Assert.assertEquals((long)nodeId1, (long)conflict.getExistingNodeId());
                        Assert.assertEquals((Object)ValueTuple.of((Value[])new Value[]{value}), (Object)conflict.getPropertyValues());
                        Assert.assertEquals((long)nodeId2, (long)conflict.getAddedNodeId());
                    }
                    throw e;
                }
            }));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends SimpleIndexPopulatorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, TestIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            long offset = this.valueSet1.size();
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.add(this.updates(this.valueSet1, 0L));
                p.add(this.updates(this.valueSet1, offset));
            }));
            try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig);
                 QueryResultComparingIndexReader reader = new QueryResultComparingIndexReader(accessor.newReader());){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : this.valueSet1) {
                    NodeValueIterator nodes = new NodeValueIterator();
                    reader.query((IndexProgressor.NodeValueClient)nodes, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                    Assert.assertEquals((String)entry.value.toString(), (Object)Iterators.asSet((Object[])new Long[]{entry.nodeId, entry.nodeId + offset}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodes));
                }
            }
        }
    }
}

