/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class BuiltInSchemaProceduresIT
extends KernelIntegrationTest {
    private final String[] nodesProcedureName = new String[]{"db", "schema", "nodeTypeProperties"};
    private final String[] relsProcedureName = new String[]{"db", "schema", "relTypeProperties"};

    @Test
    public void testWeirdLabelName() throws Throwable {
        this.createNode(Arrays.asList("`This:is_a:label`"), Arrays.asList("color"), Arrays.asList(Values.stringValue((String)"red")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher)IsEqual.equalTo((Object)this.nodeEntry(":``This:is_a:label``", Arrays.asList("`This:is_a:label`"), "color", Arrays.asList("String"), true))));
    }

    @Test
    public void testNodePropertiesRegardlessOfCreationOrder1() throws Throwable {
        this.createNode(Arrays.asList("A"), Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        this.createNode(Arrays.asList("A"), Arrays.asList("origin"), Arrays.asList(Values.stringValue((String)"Kenya")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry(":`A`", Arrays.asList("A"), "color", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`A`", Arrays.asList("A"), "size", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`A`", Arrays.asList("A"), "origin", Arrays.asList("String"), false))}));
    }

    @Test
    public void testNodePropertiesRegardlessOfCreationOrder2() throws Throwable {
        this.createNode(Arrays.asList("B"), Arrays.asList("origin"), Arrays.asList(Values.stringValue((String)"Kenya")));
        this.createNode(Arrays.asList("B"), Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "color", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "size", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "origin", Arrays.asList("String"), false))}));
    }

    @Test
    public void testNodePropertiesRegardlessOfCreationOrder3() throws Throwable {
        this.createNode(Arrays.asList("C"), Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        this.createNode(Arrays.asList("C"), Arrays.asList("origin", "active"), Arrays.asList(Values.stringValue((String)"Kenya"), Values.booleanValue((boolean)true)));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry(":`C`", Arrays.asList("C"), "color", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`C`", Arrays.asList("C"), "size", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`C`", Arrays.asList("C"), "origin", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`C`", Arrays.asList("C"), "active", Arrays.asList("Boolean"), false))}));
    }

    @Test
    public void testRelsPropertiesRegardlessOfCreationOrder1() throws Throwable {
        long emptyNode = this.createEmptyNode();
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("origin"), Arrays.asList(Values.stringValue((String)"Kenya")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`R`", "color", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "size", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "origin", Arrays.asList("String"), false))}));
    }

    @Test
    public void testRelsPropertiesRegardlessOfCreationOrder2() throws Throwable {
        long emptyNode = this.createEmptyNode();
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("origin"), Arrays.asList(Values.stringValue((String)"Kenya")));
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`R`", "color", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "size", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "origin", Arrays.asList("String"), false))}));
    }

    @Test
    public void testRelsPropertiesRegardlessOfCreationOrder3() throws Throwable {
        long emptyNode = this.createEmptyNode();
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("color", "size"), Arrays.asList(Values.stringValue((String)"red"), Values.stringValue((String)"M")));
        this.createRelationship(emptyNode, "R", emptyNode, Arrays.asList("origin", "active"), Arrays.asList(Values.stringValue((String)"Kenya"), Values.booleanValue((boolean)true)));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`R`", "color", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "size", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "origin", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "active", Arrays.asList("Boolean"), false))}));
    }

    @Test
    public void testNodesShouldNotDependOnOrderOfCreationWithOverlap() throws Throwable {
        this.createNode(Arrays.asList("B"), Arrays.asList("type"), Arrays.asList(Values.stringValue((String)"B1")));
        this.createNode(Arrays.asList("B"), Arrays.asList("type", "size"), Arrays.asList(Values.stringValue((String)"B2"), Values.intValue((int)5)));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "type", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "size", Arrays.asList("Integer"), false))}));
    }

    @Test
    public void testNodesShouldNotDependOnOrderOfCreationWithOverlap2() throws Throwable {
        this.createNode(Arrays.asList("B"), Arrays.asList("type", "size"), Arrays.asList(Values.stringValue((String)"B2"), Values.intValue((int)5)));
        this.createNode(Arrays.asList("B"), Arrays.asList("type"), Arrays.asList(Values.stringValue((String)"B1")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "type", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "size", Arrays.asList("Integer"), false))}));
    }

    @Test
    public void testRelsShouldNotDependOnOrderOfCreationWithOverlap() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "B", nodeId1, Arrays.asList("type"), Arrays.asList(Values.stringValue((String)"B1")));
        this.createRelationship(nodeId1, "B", nodeId1, Arrays.asList("type", "size"), Arrays.asList(Values.stringValue((String)"B1"), Values.intValue((int)5)));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`B`", "type", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.relEntry(":`B`", "size", Arrays.asList("Integer"), false))}));
    }

    @Test
    public void testRelsShouldNotDependOnOrderOfCreationWithOverlap2() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "B", nodeId1, Arrays.asList("type", "size"), Arrays.asList(Values.stringValue((String)"B1"), Values.intValue((int)5)));
        this.createRelationship(nodeId1, "B", nodeId1, Arrays.asList("type"), Arrays.asList(Values.stringValue((String)"B1")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`B`", "type", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.relEntry(":`B`", "size", Arrays.asList("Integer"), false))}));
    }

    @Test
    public void testWithAllDifferentNodes() throws Throwable {
        this.createNode(Arrays.asList("A", "B"), Arrays.asList("prop1", "prop2"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12)));
        this.createNode(Arrays.asList("B"), Arrays.asList("prop1"), Arrays.asList(Values.booleanValue((boolean)true)));
        this.createEmptyNode();
        this.createNode(Arrays.asList("C"), Arrays.asList("prop1"), Arrays.asList(Values.stringArray((String[])new String[]{"Test", "Success"})));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry(":`A`:`B`", Arrays.asList("A", "B"), "prop1", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.nodeEntry(":`A`:`B`", Arrays.asList("A", "B"), "prop2", Arrays.asList("Integer"), true)), IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "prop1", Arrays.asList("Boolean"), true)), IsEqual.equalTo((Object)this.nodeEntry(":`C`", Arrays.asList("C"), "prop1", Arrays.asList("StringArray"), true)), IsEqual.equalTo((Object)this.nodeEntry("", Arrays.asList(new String[0]), null, null, false))}));
    }

    @Test
    public void testWithSimilarNodes() throws Throwable {
        this.createNode(Arrays.asList("A"), Arrays.asList("prop1"), Arrays.asList(Values.stringValue((String)"Test")));
        this.createNode(Arrays.asList("A"), Arrays.asList("prop1"), Arrays.asList(Values.stringValue((String)"Test2")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)this.nodeEntry(":`A`", Arrays.asList("A"), "prop1", Arrays.asList("String"), true))));
    }

    @Test
    public void testWithSimilarNodesHavingDifferentPropertyValueTypes() throws Throwable {
        this.createNode(Arrays.asList(new String[0]), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createNode(Arrays.asList(new String[0]), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.floatValue((float)1.5f), Values.stringValue((String)"Test")));
        this.createNode(Arrays.asList(new String[0]), Arrays.asList("prop1"), Arrays.asList(Values.stringValue((String)"Test")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry("", Arrays.asList(new String[0]), "prop1", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.nodeEntry("", Arrays.asList(new String[0]), "prop2", Arrays.asList("Integer", "Float"), false)), IsEqual.equalTo((Object)this.nodeEntry("", Arrays.asList(new String[0]), "prop3", Arrays.asList("String", "Boolean"), false))}));
    }

    @Test
    public void testWithSimilarNodesShouldNotDependOnOrderOfCreation() throws Throwable {
        this.createEmptyNode();
        this.createNode(Arrays.asList(new String[0]), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createNode(Arrays.asList(new String[0]), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.floatValue((float)1.5f), Values.stringValue((String)"Test")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry("", Arrays.asList(new String[0]), "prop1", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry("", Arrays.asList(new String[0]), "prop2", Arrays.asList("Integer", "Float"), false)), IsEqual.equalTo((Object)this.nodeEntry("", Arrays.asList(new String[0]), "prop3", Arrays.asList("String", "Boolean"), false))}));
    }

    @Test
    public void testWithAllDifferentRelationships() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12)));
        this.createRelationship(nodeId1, "X", nodeId1, Arrays.asList("prop1"), Arrays.asList(Values.booleanValue((boolean)true)));
        this.createRelationship(nodeId1, "Z", nodeId1, Arrays.asList(new String[0]), Arrays.asList(new Value[0]));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`R`", "prop1", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.relEntry(":`R`", "prop2", Arrays.asList("Integer"), true)), IsEqual.equalTo((Object)this.relEntry(":`X`", "prop1", Arrays.asList("Boolean"), true)), IsEqual.equalTo((Object)this.relEntry(":`Z`", null, null, false))}));
    }

    @Test
    public void testWithSimilarRelationships() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1"), Arrays.asList(Values.stringValue((String)"Test")));
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1"), Arrays.asList(Values.stringValue((String)"Test2")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher)IsEqual.equalTo((Object)this.relEntry(":`R`", "prop1", Arrays.asList("String"), true))));
    }

    @Test
    public void testSchemaWithRelationshipWithoutProperties() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList(new String[0]), Arrays.asList(new Value[0]));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`R`", "prop1", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "prop2", Arrays.asList("Integer"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "prop3", Arrays.asList("Boolean"), false))}));
    }

    @Test
    public void testWithSimilarRelationshipsHavingDifferentPropertyValueTypes() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.floatValue((float)1.5f), Values.stringValue((String)"Test")));
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1"), Arrays.asList(Values.stringValue((String)"Test")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`R`", "prop1", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.relEntry(":`R`", "prop2", Arrays.asList("Integer", "Float"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "prop3", Arrays.asList("String", "Boolean"), false))}));
    }

    @Test
    public void testWithSimilarRelationshipsShouldNotDependOnOrderOfCreation() throws Throwable {
        long nodeId1 = this.createEmptyNode();
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList(new String[0]), Arrays.asList(new Value[0]));
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createRelationship(nodeId1, "R", nodeId1, Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.floatValue((float)1.5f), Values.stringValue((String)"Test")));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.relsProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.relEntry(":`R`", "prop1", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "prop2", Arrays.asList("Integer", "Float"), false)), IsEqual.equalTo((Object)this.relEntry(":`R`", "prop3", Arrays.asList("String", "Boolean"), false))}));
    }

    @Test
    public void testWithNullableProperties() throws Throwable {
        this.createNode(Arrays.asList("A"), Arrays.asList("prop1", "prop2", "prop3"), Arrays.asList(Values.stringValue((String)"Test"), Values.intValue((int)12), Values.booleanValue((boolean)true)));
        this.createNode(Arrays.asList("A"), Arrays.asList("prop1", "prop3"), Arrays.asList(Values.stringValue((String)"Test2"), Values.booleanValue((boolean)false)));
        this.createNode(Arrays.asList("A"), Arrays.asList("prop1", "prop2"), Arrays.asList(Values.stringValue((String)"Test3"), Values.intValue((int)42)));
        this.createNode(Arrays.asList("B"), Arrays.asList("prop1", "prop2"), Arrays.asList(Values.stringValue((String)"Test4"), Values.intValue((int)21)));
        this.createNode(Arrays.asList("B"), Arrays.asList(new String[0]), Arrays.asList(new Value[0]));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])this.nodesProcedureName)).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)this.nodeEntry(":`A`", Arrays.asList("A"), "prop1", Arrays.asList("String"), true)), IsEqual.equalTo((Object)this.nodeEntry(":`A`", Arrays.asList("A"), "prop2", Arrays.asList("Integer"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`A`", Arrays.asList("A"), "prop3", Arrays.asList("Boolean"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "prop1", Arrays.asList("String"), false)), IsEqual.equalTo((Object)this.nodeEntry(":`B`", Arrays.asList("B"), "prop2", Arrays.asList("Integer"), false))}));
    }

    private Object[] nodeEntry(String escapedLabels, List<String> labels, String propertyName, List<String> propertyValueTypes, Boolean mandatory) {
        return new Object[]{escapedLabels, labels, propertyName, propertyValueTypes, mandatory};
    }

    private Object[] relEntry(String labelsOrRelType, String propertyName, List<String> propertyValueTypes, Boolean mandatory) {
        return new Object[]{labelsOrRelType, propertyName, propertyValueTypes, mandatory};
    }

    private long createEmptyNode() throws Throwable {
        return this.createNode(Arrays.asList(new String[0]), Arrays.asList(new String[0]), Arrays.asList(new Value[0]));
    }

    private long createNode(List<String> labels, List<String> propKeys, List<Value> propValues) throws Throwable {
        assert (labels != null);
        assert (propKeys.size() == propValues.size());
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        for (String labelname : labels) {
            int labelId = transaction.tokenWrite().labelGetOrCreateForName(labelname);
            transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        }
        for (int i = 0; i < propKeys.size(); ++i) {
            String propKeyName = propKeys.get(i);
            Value propValue = propValues.get(i);
            int propKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(propKeyName);
            transaction.dataWrite().nodeSetProperty(nodeId, propKeyId, propValue);
        }
        this.commit();
        return nodeId;
    }

    private void createRelationship(long startNode, String type, long endNode, List<String> propKeys, List<Value> propValues) throws Throwable {
        assert (type != null && !type.equals(""));
        assert (propKeys.size() == propValues.size());
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int typeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName(type);
        long relId = transaction.dataWrite().relationshipCreate(startNode, typeId, endNode);
        for (int i = 0; i < propKeys.size(); ++i) {
            String propKeyName = propKeys.get(i);
            Value propValue = propValues.get(i);
            int propKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(propKeyName);
            transaction.dataWrite().relationshipSetProperty(relId, propKeyId, propValue);
        }
        this.commit();
    }

    private void printStream(RawIterator<Object[], ProcedureException> stream) throws Throwable {
        Iterator iterator = Iterators.asList(stream).iterator();
        while (iterator.hasNext()) {
            Object[] row;
            for (Object column : row = (Object[])iterator.next()) {
                System.out.println(column);
            }
            System.out.println();
        }
    }
}

