/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.storable.Values;

public class SchemaProcedureIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testEmptyGraph() throws Throwable {
        Procedures procs = this.procs();
        RawIterator stream = procs.procedureCallRead(procs.procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"})).id(), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{new ArrayList(), new ArrayList()})));
        this.commit();
    }

    @Test
    public void testLabelIndex() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("Person");
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        int propertyIdName = transaction.tokenWrite().propertyKeyGetOrCreateForName("name");
        int propertyIdAge = transaction.tokenWrite().propertyKeyGetOrCreateForName("age");
        transaction.dataWrite().nodeSetProperty(nodeId, propertyIdName, Values.of((Object)"Emil"));
        this.commit();
        SchemaWrite schemaOps = this.schemaWriteInNewTransaction();
        schemaOps.indexCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyIdName}));
        schemaOps.uniquePropertyConstraintCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyIdAge}));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"})).id(), new Object[0]);
        while (stream.hasNext()) {
            Object[] next = (Object[])stream.next();
            Assert.assertEquals((long)2L, (long)next.length);
            ArrayList nodes = (ArrayList)next[0];
            Assert.assertEquals((long)1L, (long)nodes.size());
            MatcherAssert.assertThat((Object)((Node)nodes.get(0)).getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Person"))));
            Assert.assertEquals((Object)"Person", ((Node)nodes.get(0)).getAllProperties().get("name"));
            Assert.assertEquals(Collections.singletonList("name"), ((Node)nodes.get(0)).getAllProperties().get("indexes"));
            Assert.assertEquals(Collections.singletonList("CONSTRAINT ON ( person:Person ) ASSERT person.age IS UNIQUE"), ((Node)nodes.get(0)).getAllProperties().get("constraints"));
        }
        this.commit();
    }

    @Test
    public void testRelationShip() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeIdPerson = transaction.dataWrite().nodeCreate();
        int labelIdPerson = transaction.tokenWrite().labelGetOrCreateForName("Person");
        transaction.dataWrite().nodeAddLabel(nodeIdPerson, labelIdPerson);
        long nodeIdLocation = transaction.dataWrite().nodeCreate();
        int labelIdLocation = transaction.tokenWrite().labelGetOrCreateForName("Location");
        transaction.dataWrite().nodeAddLabel(nodeIdLocation, labelIdLocation);
        int relationshipTypeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName("LIVES_IN");
        transaction.dataWrite().relationshipCreate(nodeIdPerson, relationshipTypeId, nodeIdLocation);
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"})).id(), new Object[0]);
        while (stream.hasNext()) {
            Object[] next = (Object[])stream.next();
            Assert.assertEquals((long)2L, (long)next.length);
            LinkedList relationships = (LinkedList)next[1];
            Assert.assertEquals((long)1L, (long)relationships.size());
            Assert.assertEquals((Object)"LIVES_IN", (Object)((Relationship)relationships.get(0)).getType().name());
            MatcherAssert.assertThat((Object)((Relationship)relationships.get(0)).getStartNode().getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Person"))));
            MatcherAssert.assertThat((Object)((Relationship)relationships.get(0)).getEndNode().getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Location"))));
        }
        this.commit();
    }
}

