/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class CompositeCountsTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    private Supplier<KernelTransaction> transactionSupplier;

    @Test
    public void shouldReportNumberOfRelationshipsFromNodesWithGivenLabel() {
        try (Transaction tx = this.db.beginTx();){
            Node foo = this.db.createNode(new Label[]{Label.label((String)"Foo")});
            Node fooBar = this.db.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"ALPHA"));
            foo.createRelationshipTo(fooBar, RelationshipType.withName((String)"BETA"));
            fooBar.createRelationshipTo(this.db.createNode(new Label[]{Label.label((String)"Bar")}), RelationshipType.withName((String)"BETA"));
            fooBar.createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"GAMMA"));
            bar.createRelationshipTo(this.db.createNode(new Label[]{Label.label((String)"Foo")}), RelationshipType.withName((String)"GAMMA"));
            tx.success();
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"ALPHA"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BETA"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"GAMMA"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"ALPHA"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"BETA"), Label.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"GAMMA"), Label.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"ALPHA"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"BETA"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"GAMMA"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"ALPHA"), Label.label((String)"Bar")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"BETA"), Label.label((String)"Bar")).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"GAMMA"), Label.label((String)"Bar")).shouldBe(0L);
    }

    @Test
    public void shouldMaintainCountsOnRelationshipCreate() {
        Node bar;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo")});
            bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    public void shouldMaintainCountsOnRelationshipDelete() {
        Relationship relationship;
        try (Transaction tx = this.db.beginTx();){
            relationship = this.db.createNode(new Label[]{Label.label((String)"Foo")}).createRelationshipTo(this.db.createNode(new Label[]{Label.label((String)"Bar")}), RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            relationship.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(0L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    public void shouldMaintainCountsOnLabelAdd() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode();
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.addLabel(Label.label((String)"Foo"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    public void shouldMaintainCountsOnLabelRemove() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.removeLabel(Label.label((String)"Foo"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    public void shouldMaintainCountsOnLabelAddAndRelationshipCreate() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.addLabel(Label.label((String)"Bar"));
            foo.createRelationshipTo(this.db.createNode(new Label[]{Label.label((String)"Foo")}), RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
    }

    @Test
    public void shouldMaintainCountsOnLabelRemoveAndRelationshipDelete() {
        Relationship rel;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            rel = bar.createRelationshipTo(foo, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var5_2 = null;
        try {
            foo.removeLabel(Label.label((String)"Bar"));
            rel.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    public void shouldMaintainCountsOnLabelAddAndRelationshipDelete() {
        Relationship rel;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            rel = bar.createRelationshipTo(foo, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var5_2 = null;
        try {
            foo.addLabel(Label.label((String)"Bar"));
            rel.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
    }

    @Test
    public void shouldMaintainCountsOnLabelRemoveAndRelationshipCreate() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.removeLabel(Label.label((String)"Bar"));
            foo.createRelationshipTo(this.db.createNode(new Label[]{Label.label((String)"Foo")}), RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    public void shouldNotUpdateCountsIfCreatedRelationshipIsDeletedInSameTransaction() {
        Node bar;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo")});
            bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS")).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(0L);
    }

    private MatchingRelationships numberOfRelationshipsMatching(Label lhs, RelationshipType type, Label rhs) {
        try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
            long nodeCount = this.countsForRelationship(lhs, type, rhs);
            tx.success();
            MatchingRelationships matchingRelationships = new MatchingRelationships(String.format("(%s)-%s->(%s)", lhs == null ? "" : ":" + lhs.name(), type == null ? "" : "[:" + type.name() + "]", rhs == null ? "" : ":" + rhs.name()), nodeCount);
            return matchingRelationships;
        }
    }

    private long countsForRelationship(Label start, RelationshipType type, Label end) {
        KernelTransaction transaction = this.transactionSupplier.get();
        try (Statement ignore = transaction.acquireStatement();){
            int endId;
            int typeId;
            int startId;
            TokenRead tokenRead = transaction.tokenRead();
            if (start == null) {
                startId = -1;
            } else {
                startId = tokenRead.nodeLabel(start.name());
                if (-1 == startId) {
                    long l = 0L;
                    return l;
                }
            }
            if (type == null) {
                typeId = -1;
            } else {
                typeId = tokenRead.relationshipType(type.name());
                if (-1 == typeId) {
                    long l = 0L;
                    return l;
                }
            }
            if (end == null) {
                endId = -1;
            } else {
                endId = tokenRead.nodeLabel(end.name());
                if (-1 == endId) {
                    long l = 0L;
                    return l;
                }
            }
            long l = transaction.dataRead().countsForRelationship(startId, typeId, endId);
            return l;
        }
    }

    @Before
    public void exposeGuts() {
        this.transactionSupplier = () -> ((ThreadToStatementContextBridge)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }

    private static class MatchingRelationships {
        private final String message;
        private final long count;

        MatchingRelationships(String message, long count) {
            this.message = message;
            this.count = count;
        }

        public void shouldBe(long expected) {
            Assert.assertEquals((String)this.message, (long)expected, (long)this.count);
        }
    }
}

