/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.index.schema.FailingGenericNativeIndexProviderFactory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DbIndexesFailureMessageIT
extends KernelIntegrationTest {
    private AtomicBoolean failNextIndexPopulation = new AtomicBoolean();

    @Test
    public void listAllIndexesWithFailedIndex() throws Throwable {
        Transaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int failedLabel = transaction.tokenWrite().labelGetOrCreateForName("Fail");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        this.failNextIndexPopulation.set(true);
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)failedLabel, (int[])new int[]{propertyKeyId1});
        transaction.schemaWrite().indexCreate((SchemaDescriptor)descriptor);
        this.commit();
        try (org.neo4j.graphdb.Transaction ignored2 = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Assert.fail((String)"Expected to fail when awaiting for index to come online");
        }
        catch (IllegalStateException ignored2) {
            // empty catch block
        }
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"})).id(), new Object[0]);
        Assert.assertTrue((boolean)stream.hasNext());
        Object[] result = (Object[])stream.next();
        Assert.assertFalse((boolean)stream.hasNext());
        Assert.assertEquals((Object)"INDEX ON :Fail(foo)", (Object)result[0]);
        Assert.assertEquals((Object)"Unnamed index", (Object)result[1]);
        Assert.assertEquals(Collections.singletonList("Fail"), (Object)result[2]);
        Assert.assertEquals(Collections.singletonList("foo"), (Object)result[3]);
        Assert.assertEquals((Object)"FAILED", (Object)result[4]);
        Assert.assertEquals((Object)"node_label_property", (Object)result[5]);
        Assert.assertEquals((Object)0.0, (Object)result[6]);
        Map providerDescriptionMap = MapUtil.stringMap((String[])new String[]{"key", GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey(), "version", GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion()});
        Assert.assertEquals((Object)providerDescriptionMap, (Object)result[7]);
        Assert.assertEquals((Object)this.indexingService.getIndexId((SchemaDescriptor)descriptor), (Object)result[8]);
        MatcherAssert.assertThat((Object)((String)result[9]), (Matcher)Matchers.containsString((String)"java.lang.RuntimeException: Fail on update during population"));
        this.commit();
    }

    @Override
    protected TestGraphDatabaseFactory createGraphDatabaseFactory() {
        return super.createGraphDatabaseFactory().removeKernelExtensions(TestGraphDatabaseFactory.INDEX_PROVIDERS_FILTER).addKernelExtension((KernelExtensionFactory)new FailingGenericNativeIndexProviderFactory(new FailingGenericNativeIndexProviderFactory.FailureType[]{FailingGenericNativeIndexProviderFactory.FailureType.POPULATION}));
    }
}

