/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanChunk;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

public class StoreScanChunkIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void differentChunksHaveDifferentCursors() {
        GraphDatabaseAPI database = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.storeDir());
        try {
            RecordStorageEngine recordStorageEngine = (RecordStorageEngine)database.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = recordStorageEngine.testAccessNeoStores();
            RecordStorageReader storageReader = new RecordStorageReader(neoStores);
            TestStoreScanChunk scanChunk1 = new TestStoreScanChunk(storageReader, false);
            TestStoreScanChunk scanChunk2 = new TestStoreScanChunk(storageReader, false);
            Assert.assertNotSame((Object)scanChunk1.getCursor(), (Object)scanChunk2.getCursor());
            Assert.assertNotSame((Object)scanChunk1.getStorePropertyCursor(), (Object)scanChunk2.getStorePropertyCursor());
        }
        finally {
            database.shutdown();
        }
    }

    private class TestStoreScanChunk
    extends StoreScanChunk<StorageNodeCursor> {
        TestStoreScanChunk(RecordStorageReader storageReader, boolean requiresPropertyMigration) {
            super((StorageEntityCursor)storageReader.allocateNodeCursor(), storageReader, requiresPropertyMigration);
        }

        protected void read(StorageNodeCursor cursor, long id) {
            cursor.single(id);
        }

        void visitRecord(StorageNodeCursor record, InputEntityVisitor visitor) {
        }

        StorageNodeCursor getCursor() {
            return (StorageNodeCursor)this.cursor;
        }

        StoragePropertyCursor getStorePropertyCursor() {
            return this.storePropertyCursor;
        }
    }
}

