/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.locking;

import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.CommunityLockClient;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.RootCauseMatcher;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class CommunityLockAcquisitionTimeoutIT {
    @ClassRule
    public static final TestDirectory directory = TestDirectory.testDirectory();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private final OtherThreadExecutor<Void> secondTransactionExecutor = new OtherThreadExecutor("transactionExecutor", null);
    private final OtherThreadExecutor<Void> clockExecutor = new OtherThreadExecutor("clockExecutor", null);
    private static final int TEST_TIMEOUT = 5000;
    private static final String TEST_PROPERTY_NAME = "a";
    private static final Label marker = Label.label((String)"marker");
    private static final FakeClock fakeClock = Clocks.fakeClock();
    private static GraphDatabaseService database;

    @BeforeClass
    public static void setUp() {
        CustomClockFacadeFactory facadeFactory = new CustomClockFacadeFactory();
        database = new CustomClockTestGraphDatabaseFactory(facadeFactory).newEmbeddedDatabaseBuilder(directory.storeDir()).setConfig(GraphDatabaseSettings.lock_acquisition_timeout, "2s").setConfig("dbms.backup.enabled", "false").newGraphDatabase();
        CommunityLockAcquisitionTimeoutIT.createTestNode(marker);
    }

    @AfterClass
    public static void tearDownClass() {
        database.shutdown();
    }

    @After
    public void tearDown() {
        this.secondTransactionExecutor.close();
        this.clockExecutor.close();
    }

    @Test(timeout=5000L)
    public void timeoutOnAcquiringExclusiveLock() throws Exception {
        this.expectedException.expect((Matcher)new RootCauseMatcher(LockAcquisitionTimeoutException.class, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Unable to acquire lock within configured timeout (dbms.lock.acquisition.timeout). Unable to acquire lock for resource: NODE with id: 0 within 2000 millis."));
        try (Transaction ignored = database.beginTx();){
            ResourceIterator nodes = database.findNodes(marker);
            Node node = (Node)nodes.next();
            node.setProperty(TEST_PROPERTY_NAME, (Object)"b");
            Future propertySetFuture = this.secondTransactionExecutor.executeDontWait(state -> {
                try (Transaction transaction1 = database.beginTx();){
                    node.setProperty(TEST_PROPERTY_NAME, (Object)"b");
                    transaction1.success();
                }
                return null;
            });
            this.secondTransactionExecutor.waitUntilWaiting(this.exclusiveLockWaitingPredicate());
            this.clockExecutor.execute(state -> {
                fakeClock.forward(3L, TimeUnit.SECONDS);
                return null;
            });
            propertySetFuture.get();
            Assert.fail((String)"Should throw termination exception.");
        }
    }

    @Test(timeout=5000L)
    public void timeoutOnAcquiringSharedLock() throws Exception {
        this.expectedException.expect((Matcher)new RootCauseMatcher(LockAcquisitionTimeoutException.class, "The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Unable to acquire lock within configured timeout (dbms.lock.acquisition.timeout). Unable to acquire lock for resource: LABEL with id: 1 within 2000 millis."));
        try (Transaction ignored = database.beginTx();){
            Locks lockManger = this.getLockManager();
            lockManger.newClient().acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{1L});
            Future propertySetFuture = this.secondTransactionExecutor.executeDontWait(state -> {
                try (Transaction nestedTransaction = database.beginTx();){
                    ResourceIterator nodes = database.findNodes(marker);
                    Node node = (Node)nodes.next();
                    node.addLabel(Label.label((String)"anotherLabel"));
                    nestedTransaction.success();
                }
                return null;
            });
            this.secondTransactionExecutor.waitUntilWaiting(this.sharedLockWaitingPredicate());
            this.clockExecutor.execute(state -> {
                fakeClock.forward(3L, TimeUnit.SECONDS);
                return null;
            });
            propertySetFuture.get();
            Assert.fail((String)"Should throw termination exception.");
        }
    }

    protected Locks getLockManager() {
        return (Locks)this.getDependencyResolver().resolveDependency(CommunityLockManger.class);
    }

    protected DependencyResolver getDependencyResolver() {
        return ((GraphDatabaseAPI)database).getDependencyResolver();
    }

    protected Predicate<OtherThreadExecutor.WaitDetails> exclusiveLockWaitingPredicate() {
        return waitDetails -> waitDetails.isAt(CommunityLockClient.class, "acquireExclusive");
    }

    protected Predicate<OtherThreadExecutor.WaitDetails> sharedLockWaitingPredicate() {
        return waitDetails -> waitDetails.isAt(CommunityLockClient.class, "acquireShared");
    }

    private static void createTestNode(Label marker) {
        try (Transaction transaction = database.beginTx();){
            database.createNode(new Label[]{marker});
            transaction.success();
        }
    }

    private static class CustomClockFacadeFactory
    extends GraphDatabaseFacadeFactory {
        CustomClockFacadeFactory() {
            super(DatabaseInfo.COMMUNITY, CommunityEditionModule::new);
        }

        protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return new PlatformModule(storeDir, config, this.databaseInfo, dependencies){

                protected SystemNanoClock createClock() {
                    return fakeClock;
                }
            };
        }
    }

    private static class CustomClockTestGraphDatabaseFactory
    extends TestGraphDatabaseFactory {
        private GraphDatabaseFacadeFactory customFacadeFactory;

        CustomClockTestGraphDatabaseFactory(GraphDatabaseFacadeFactory customFacadeFactory) {
            this.customFacadeFactory = customFacadeFactory;
        }

        protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(final File storeDir, final GraphDatabaseFactoryState state) {
            return new GraphDatabaseBuilder.DatabaseCreator(){

                public GraphDatabaseService newDatabase(Config config) {
                    return customFacadeFactory.newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies()));
                }
            };
        }
    }
}

