/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Rule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public abstract class AbstractMandatoryTransactionsTest<T> {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule();

    public T obtainEntity() {
        GraphDatabaseAPI graphDatabaseService = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = graphDatabaseService.beginTx();){
            T result = this.obtainEntityInTransaction((GraphDatabaseService)graphDatabaseService);
            tx.success();
            T t = result;
            return t;
        }
    }

    public void obtainEntityInTerminatedTransaction(Consumer<T> f) {
        GraphDatabaseAPI graphDatabaseService = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = graphDatabaseService.beginTx();){
            T result = this.obtainEntityInTransaction((GraphDatabaseService)graphDatabaseService);
            tx.terminate();
            f.accept(result);
        }
    }

    protected abstract T obtainEntityInTransaction(GraphDatabaseService var1);

    public static <T> void assertFacadeMethodsThrowNotInTransaction(T entity, Consumer<T>[] methods) {
        for (Consumer<T> method : methods) {
            try {
                method.accept(entity);
                Assert.fail((String)("Transactions are mandatory, also for reads: " + method));
            }
            catch (NotInTransactionException notInTransactionException) {
                // empty catch block
            }
        }
    }

    public void assertFacadeMethodsThrowAfterTerminate(Consumer<T>[] methods) {
        for (Consumer method : methods) {
            this.obtainEntityInTerminatedTransaction(entity -> {
                try {
                    method.accept(entity);
                    Assert.fail((String)("Transaction was terminated, yet not exception thrown in: " + method));
                }
                catch (TransactionTerminatedException transactionTerminatedException) {
                    // empty catch block
                }
            });
        }
    }
}

