/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.IntPredicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexPopulationJobTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    private GraphDatabaseAPI db;
    private final Label FIRST = Label.label((String)"FIRST");
    private final Label SECOND = Label.label((String)"SECOND");
    private final RelationshipType likes = RelationshipType.withName((String)"likes");
    private final RelationshipType knows = RelationshipType.withName((String)"knows");
    private final String name = "name";
    private final String age = "age";
    private Kernel kernel;
    private IndexStoreView indexStoreView;
    private DatabaseSchemaState stateHolder;
    private int labelId;

    @Before
    public void before() throws Exception {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.record_id_batch_size, "1").newGraphDatabase();
        this.kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        this.stateHolder = new DatabaseSchemaState((LogProvider)NullLogProvider.getInstance());
        this.indexStoreView = this.indexStoreView();
        try (Transaction tx = this.kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);){
            this.labelId = tx.tokenWrite().labelGetOrCreateForName(this.FIRST.name());
            tx.tokenWrite().labelGetOrCreateForName(this.SECOND.name());
            tx.success();
        }
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    @Test
    public void shouldPopulateIndexWithOneNode() throws Exception {
        String value = "Taylor";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        IndexPopulationJob job = this.newIndexPopulationJob(populator, new FlippableIndexProxy(), EntityType.NODE, IndexDescriptorFactory.forSchema((SchemaDescriptor)descriptor));
        job.run();
        IndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update);
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)2))).add((Collection)ArgumentMatchers.any(Collection.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).sampleResult();
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
    }

    @Test
    public void shouldPopulateIndexWithOneRelationship() throws Exception {
        String value = "Taylor";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        long relationship = this.createRelationship(MapUtil.map((Object[])new Object[]{"name", "age"}), this.likes, nodeId, nodeId);
        IndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{0}));
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(descriptor));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, new FlippableIndexProxy(), EntityType.RELATIONSHIP, descriptor);
        job.run();
        IndexEntryUpdate update = IndexEntryUpdate.add((long)relationship, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)"age")});
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update);
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)2))).add((Collection)ArgumentMatchers.any(Collection.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).sampleResult();
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
    }

    @Test
    public void shouldFlushSchemaStateAfterPopulation() throws Exception {
        String value = "Taylor";
        this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        this.stateHolder.put((Object)"key", (Object)"original_value");
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, new FlippableIndexProxy(), EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
        job.run();
        String result = (String)this.stateHolder.get((Object)"key");
        Assert.assertNull((Object)result);
    }

    @Test
    public void shouldPopulateIndexWithASmallDataset() throws Exception {
        String value = "Mattias";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.SECOND);
        this.createNode(MapUtil.map((Object[])new Object[]{"age", 31}), this.FIRST);
        long node4 = this.createNode(MapUtil.map((Object[])new Object[]{"age", 35, "name", value}), this.FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        IndexPopulationJob job = this.newIndexPopulationJob(populator, new FlippableIndexProxy(), EntityType.NODE, IndexDescriptorFactory.forSchema((SchemaDescriptor)descriptor));
        job.run();
        IndexEntryUpdate update1 = IndexEntryUpdate.add((long)node1, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        IndexEntryUpdate update2 = IndexEntryUpdate.add((long)node4, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update1);
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update2);
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)2))).add(ArgumentMatchers.anyCollection());
        ((IndexPopulator)Mockito.verify((Object)populator)).sampleResult();
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
    }

    @Test
    public void shouldPopulateRelatonshipIndexWithASmallDataset() throws Exception {
        String value = "Philip J.Fry";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.SECOND);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{"age", 31}), this.FIRST);
        long node4 = this.createNode(MapUtil.map((Object[])new Object[]{"age", 35, "name", value}), this.FIRST);
        long rel1 = this.createRelationship(MapUtil.map((Object[])new Object[]{"name", value}), this.likes, node1, node3);
        this.createRelationship(MapUtil.map((Object[])new Object[]{"name", value}), this.knows, node3, node1);
        this.createRelationship(MapUtil.map((Object[])new Object[]{"age", 31}), this.likes, node2, node1);
        long rel4 = this.createRelationship(MapUtil.map((Object[])new Object[]{"age", 35, "name", value}), this.likes, node4, node4);
        IndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{0}));
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(descriptor));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, new FlippableIndexProxy(), EntityType.RELATIONSHIP, descriptor);
        job.run();
        IndexEntryUpdate update1 = IndexEntryUpdate.add((long)rel1, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        IndexEntryUpdate update2 = IndexEntryUpdate.add((long)rel4, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{Values.of((Object)value)});
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update1);
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update2);
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)2))).add(ArgumentMatchers.anyCollection());
        ((IndexPopulator)Mockito.verify((Object)populator)).sampleResult();
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
    }

    @Test
    public void shouldIndexConcurrentUpdatesWhilePopulating() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        String changedValue = "changed";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value1}), this.FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value2}), this.FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value3}), this.FIRST);
        long changeNode = node1;
        int propertyKeyId = this.getPropertyKeyForName("name");
        NodeChangingWriter populator = new NodeChangingWriter(changeNode, propertyKeyId, value1, changedValue, this.labelId);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
        populator.setJob(job);
        job.run();
        Set expected = Iterators.asSet((Object[])new Pair[]{Pair.of((Object)node1, (Object)value1), Pair.of((Object)node2, (Object)value2), Pair.of((Object)node3, (Object)value3), Pair.of((Object)node1, (Object)changedValue)});
        Assert.assertEquals((Object)expected, (Object)populator.added);
    }

    @Test
    public void shouldRemoveViaConcurrentIndexUpdatesWhilePopulating() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value1}), this.FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value2}), this.FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value3}), this.FIRST);
        int propertyKeyId = this.getPropertyKeyForName("name");
        NodeDeletingWriter populator = new NodeDeletingWriter(node2, propertyKeyId, value2, this.labelId);
        IndexPopulationJob job = this.newIndexPopulationJob((IndexPopulator)populator, new FlippableIndexProxy(), EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
        populator.setJob(job);
        job.run();
        Map expectedAdded = MapUtil.genericMap((Object[])new Object[]{node1, value1, node2, value2, node3, value3});
        Assert.assertEquals((Object)expectedAdded, (Object)populator.added);
        Map expectedRemoved = MapUtil.genericMap((Object[])new Object[]{node2, value2});
        Assert.assertEquals((Object)expectedRemoved, (Object)populator.removed);
    }

    @Test
    public void shouldTransitionToFailedStateIfPopulationJobCrashes() throws Exception {
        IndexPopulator failingPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("BORK BORK")}).when((Object)failingPopulator)).add((Collection)ArgumentMatchers.any(Collection.class));
        FlippableIndexProxy index = new FlippableIndexProxy();
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "Taylor"}), this.FIRST);
        IndexPopulationJob job = this.newIndexPopulationJob(failingPopulator, index, EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
        job.run();
        MatcherAssert.assertThat((Object)index.getState(), (Matcher)IsEqual.equalTo((Object)InternalIndexState.FAILED));
    }

    @Test
    public void shouldBeAbleToCancelPopulationJob() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        ControlledStoreScan storeScan = new ControlledStoreScan();
        Mockito.when((Object)storeView.visitNodes((int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class), (Visitor)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)storeScan);
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, storeView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
        OtherThreadExecutor populationJobRunner = (OtherThreadExecutor)this.cleanup.add((AutoCloseable)new OtherThreadExecutor("Population job test runner", null));
        Future runFuture = populationJobRunner.executeDontWait(state -> {
            job.run();
            return null;
        });
        storeScan.latch.waitForAllToStart();
        job.cancel().get();
        storeScan.latch.waitForAllToFinish();
        runFuture.get();
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)1))).close(false);
        ((FlippableIndexProxy)Mockito.verify((Object)index, (VerificationMode)Mockito.never())).flip((Callable)ArgumentMatchers.any(), (FailedIndexProxyFactory)ArgumentMatchers.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLogJobProgress() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)index.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        try {
            IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (LogProvider)logProvider, EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
            job.run();
            AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(IndexPopulationJob.class);
            logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{match.info("Index population started: [%s]", new Object[]{":FIRST(name)"}), match.info("Index creation finished. Index [%s] is %s.", new Object[]{":FIRST(name)", "ONLINE"}), match.info(Matchers.containsString((String)"TIME/PHASE Final: SCAN["))});
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void logConstraintJobProgress() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)index.getState()).thenReturn((Object)InternalIndexState.POPULATING);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        try {
            IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (LogProvider)logProvider, EntityType.NODE, this.indexDescriptor(this.FIRST, "name", true));
            job.run();
            AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(IndexPopulationJob.class);
            logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{match.info("Index population started: [%s]", new Object[]{":FIRST(name)"}), match.info("Index created. Starting data checks. Index [%s] is %s.", new Object[]{":FIRST(name)", "POPULATING"}), match.info(Matchers.containsString((String)"TIME/PHASE Final: SCAN["))});
        }
        finally {
            populator.close(true);
        }
    }

    @Test
    public void shouldLogJobFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (LogProvider)logProvider, EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).create();
        job.run();
        AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(IndexPopulationJob.class);
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{match.error(Matchers.is((Object)"Failed to populate index: [:FIRST(name)]"), Matchers.sameInstance((Object)failure))});
    }

    @Test
    public void shouldFlipToFailedUsingFailedIndexProxyFactory() throws Exception {
        FailedIndexProxyFactory failureDelegateFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(failureDelegateFactory, populator, new FlippableIndexProxy(), this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).close(true);
        job.run();
        ((FailedIndexProxyFactory)Mockito.verify((Object)failureDelegateFactory)).create((Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    public void shouldCloseAndFailOnFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.indexPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(populator, index, this.indexStoreView, (LogProvider)logProvider, EntityType.NODE, this.indexDescriptor(this.FIRST, "name", false));
        String failureMessage = "not successful";
        IllegalStateException failure = new IllegalStateException(failureMessage);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)populator)).create();
        job.run();
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(ArgumentMatchers.contains((String)failureMessage));
    }

    @Test
    public void shouldCloseMultiPopulatorOnSuccessfulPopulation() {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        TrackingMultipleIndexPopulator populator = new TrackingMultipleIndexPopulator(IndexStoreView.EMPTY, (LogProvider)logProvider, EntityType.NODE, (SchemaState)new DatabaseSchemaState((LogProvider)logProvider));
        IndexPopulationJob populationJob = new IndexPopulationJob((MultipleIndexPopulator)populator, IndexingService.NO_MONITOR, false);
        populationJob.run();
        Assert.assertTrue((boolean)populator.closed);
    }

    @Test
    public void shouldCloseMultiPopulatorOnFailedPopulation() {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        IndexStoreView.Adaptor failingStoreView = new IndexStoreView.Adaptor(){

            public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdateVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
                return new StoreScan<FAILURE>(){

                    public void run() {
                        throw new RuntimeException("Just failing");
                    }

                    public void stop() {
                    }

                    public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
                    }

                    public PopulationProgress getProgress() {
                        return null;
                    }
                };
            }
        };
        TrackingMultipleIndexPopulator populator = new TrackingMultipleIndexPopulator((IndexStoreView)failingStoreView, (LogProvider)logProvider, EntityType.NODE, (SchemaState)new DatabaseSchemaState((LogProvider)logProvider));
        IndexPopulationJob populationJob = new IndexPopulationJob((MultipleIndexPopulator)populator, IndexingService.NO_MONITOR, false);
        populationJob.run();
        Assert.assertTrue((boolean)populator.closed);
    }

    private IndexPopulator indexPopulator(boolean constraint) throws TransactionFailureException, IllegalTokenNameException, TooManyLabelsException {
        IndexDescriptor descriptor = this.indexDescriptor(this.FIRST, "name", constraint);
        return this.indexPopulator(descriptor);
    }

    private IndexPopulator indexPopulator(IndexDescriptor descriptor) {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexProvider indexProvider = ((DefaultIndexProviderMap)this.db.getDependencyResolver().resolveDependency(DefaultIndexProviderMap.class)).getDefaultProvider();
        return indexProvider.getPopulator(descriptor.withId(21L), samplingConfig, ByteBufferFactory.heapBufferFactory((int)1024));
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, EntityType type, IndexDescriptor descriptor) {
        return this.newIndexPopulationJob(populator, flipper, this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), type, descriptor);
    }

    private IndexPopulationJob newIndexPopulationJob(IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, LogProvider logProvider, EntityType type, IndexDescriptor descriptor) {
        return this.newIndexPopulationJob((FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class), populator, flipper, storeView, logProvider, type, descriptor);
    }

    private IndexPopulationJob newIndexPopulationJob(FailedIndexProxyFactory failureDelegateFactory, IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, LogProvider logProvider, EntityType type, IndexDescriptor descriptor) {
        long indexId = 0L;
        flipper.setFlipTarget((IndexProxyFactory)Mockito.mock(IndexProxyFactory.class));
        MultipleIndexPopulator multiPopulator = new MultipleIndexPopulator(storeView, logProvider, type, (SchemaState)this.stateHolder);
        IndexPopulationJob job = new IndexPopulationJob(multiPopulator, IndexingService.NO_MONITOR, false);
        job.addPopulator(populator, descriptor.withId(indexId).withoutCapabilities(), String.format(":%s(%s)", this.FIRST.name(), "name"), flipper, failureDelegateFactory);
        return job;
    }

    private IndexDescriptor indexDescriptor(Label label, String propertyKey, boolean constraint) throws TransactionFailureException, IllegalTokenNameException, TooManyLabelsException {
        try (Transaction tx = this.kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);){
            int labelId = tx.tokenWrite().labelGetOrCreateForName(label.name());
            int propertyKeyId = tx.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
            LabelSchemaDescriptor schema = SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId});
            IndexDescriptor descriptor = constraint ? IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR) : IndexDescriptorFactory.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
            tx.success();
            IndexDescriptor indexDescriptor = descriptor;
            return indexDescriptor;
        }
    }

    private long createNode(Map<String, Object> properties, Label ... labels) {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    private long createRelationship(Map<String, Object> properties, RelationshipType relType, long fromNode, long toNode) {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            Node node1 = this.db.getNodeById(fromNode);
            Node node2 = this.db.getNodeById(toNode);
            Relationship relationship = node1.createRelationshipTo(node2, relType);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                relationship.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            long l = relationship.getId();
            return l;
        }
    }

    private int getPropertyKeyForName(String name) throws TransactionFailureException {
        try (Transaction tx = this.kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);){
            int result = tx.tokenRead().propertyKey(name);
            tx.success();
            int n = result;
            return n;
        }
    }

    private IndexStoreView indexStoreView() {
        return (IndexStoreView)this.db.getDependencyResolver().resolveDependency(IndexStoreView.class);
    }

    private static class TrackingMultipleIndexPopulator
    extends MultipleIndexPopulator {
        private volatile boolean closed;

        TrackingMultipleIndexPopulator(IndexStoreView storeView, LogProvider logProvider, EntityType type, SchemaState schemaState) {
            super(storeView, logProvider, type, schemaState);
        }

        public void close(boolean populationCompletedSuccessfully) {
            this.closed = true;
            super.close(populationCompletedSuccessfully);
        }
    }

    private class NodeDeletingWriter
    extends IndexPopulator.Adapter {
        private final Map<Long, Object> added = new HashMap<Long, Object>();
        private final Map<Long, Object> removed = new HashMap<Long, Object>();
        private final long nodeToDelete;
        private IndexPopulationJob job;
        private final Value valueToDelete;
        private final org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor index;

        NodeDeletingWriter(long nodeToDelete, int propertyKeyId, Object valueToDelete, int label) {
            this.nodeToDelete = nodeToDelete;
            this.valueToDelete = Values.of((Object)valueToDelete);
            this.index = SchemaDescriptorFactory.forLabel((int)label, (int[])new int[]{propertyKeyId});
        }

        public void setJob(IndexPopulationJob job) {
            this.job = job;
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
            for (IndexEntryUpdate<?> update : updates) {
                this.add(update);
            }
        }

        void add(IndexEntryUpdate<?> update) {
            if (update.getEntityId() == 2L) {
                this.job.update(IndexEntryUpdate.remove((long)this.nodeToDelete, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{this.valueToDelete}));
            }
            this.added.put(update.getEntityId(), update.values()[0].asObjectCopy());
        }

        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor nodePropertyAccessor) {
            return new IndexUpdater(){

                public void process(IndexEntryUpdate<?> update) {
                    switch (update.updateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            NodeDeletingWriter.this.added.put(update.getEntityId(), update.values()[0].asObjectCopy());
                            break;
                        }
                        case REMOVED: {
                            NodeDeletingWriter.this.removed.put(update.getEntityId(), update.values()[0].asObjectCopy());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(update.updateMode().name());
                        }
                    }
                }

                public void close() {
                }
            };
        }
    }

    private class NodeChangingWriter
    extends IndexPopulator.Adapter {
        private final Set<Pair<Long, Object>> added = new HashSet<Pair<Long, Object>>();
        private IndexPopulationJob job;
        private final long nodeToChange;
        private final Value newValue;
        private final Value previousValue;
        private final org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor index;

        NodeChangingWriter(long nodeToChange, int propertyKeyId, Object previousValue, Object newValue, int label) {
            this.nodeToChange = nodeToChange;
            this.previousValue = Values.of((Object)previousValue);
            this.newValue = Values.of((Object)newValue);
            this.index = SchemaDescriptorFactory.forLabel((int)label, (int[])new int[]{propertyKeyId});
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
            for (IndexEntryUpdate<?> update : updates) {
                this.add(update);
            }
        }

        void add(IndexEntryUpdate<?> update) {
            if (update.getEntityId() == 2L) {
                this.job.update(IndexEntryUpdate.change((long)this.nodeToChange, (SchemaDescriptorSupplier)this.index, (Value)this.previousValue, (Value)this.newValue));
            }
            this.added.add((Pair<Long, Object>)Pair.of((Object)update.getEntityId(), (Object)update.values()[0].asObjectCopy()));
        }

        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor nodePropertyAccessor) {
            return new IndexUpdater(){

                public void process(IndexEntryUpdate<?> update) {
                    switch (update.updateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            NodeChangingWriter.this.added.add(Pair.of((Object)update.getEntityId(), (Object)update.values()[0].asObjectCopy()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(update.updateMode().name());
                        }
                    }
                }

                public void close() {
                }
            };
        }

        public void setJob(IndexPopulationJob job) {
            this.job = job;
        }
    }

    private static class ControlledStoreScan
    implements StoreScan<RuntimeException> {
        private final DoubleLatch latch = new DoubleLatch();

        private ControlledStoreScan() {
        }

        public void run() {
            this.latch.startAndWaitForAllToStartAndFinish();
        }

        public void stop() {
            this.latch.finish();
        }

        public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
        }

        public PopulationProgress getProgress() {
            return PopulationProgress.single((long)42L, (long)100L);
        }
    }
}

