/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReaderTestBase;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;

public class RecordStorageReaderSchemaTest
extends RecordStorageReaderTestBase {
    @Test
    public void shouldListAllIndexes() {
        this.createIndex(this.label1, "name");
        this.createIndex(this.label2, "name");
        Set indexes = Iterators.asSet((Iterator)this.storageReader.indexesGetAll());
        Set expectedIndexes = Iterators.asSet((Object[])new IndexDescriptor[]{this.indexDescriptor(this.label1, "name"), this.indexDescriptor(this.label2, "name")});
        Assert.assertEquals((Object)expectedIndexes, (Object)indexes);
    }

    @Test
    public void shouldListAllIndexesAtTimeOfSnapshot() {
        this.createIndex(this.label1, "name");
        StorageSchemaReader snapshot = this.storageReader.schemaSnapshot();
        this.createIndex(this.label2, "name");
        Set indexes = Iterators.asSet((Iterator)snapshot.indexesGetAll());
        Set expectedIndexes = Iterators.asSet((Object[])new IndexDescriptor[]{this.indexDescriptor(this.label1, "name")});
        Assert.assertEquals((Object)expectedIndexes, (Object)indexes);
    }

    @Test
    public void gettingIndexStateOfDroppedIndexViaSnapshotShouldThrow() {
        this.createIndex(this.label1, "name");
        StorageSchemaReader snapshot = this.storageReader.schemaSnapshot();
        this.dropIndex(this.label1, "name");
        try {
            snapshot.indexGetState(this.indexDescriptor(this.label1, "name"));
            Assert.fail((String)"Should have thrown exception when asking for state of dropped index.");
        }
        catch (IndexNotFoundKernelException indexNotFoundKernelException) {
            // empty catch block
        }
    }

    @Test
    public void shouldListAllConstraints() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label2, "name");
        Set constraints = Iterators.asSet((Iterator)this.storageReader.constraintsGetAll());
        Set expectedConstraints = Iterators.asSet((Object[])new ConstraintDescriptor[]{this.uniqueConstraintDescriptor(this.label1, "name"), this.uniqueConstraintDescriptor(this.label2, "name")});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    @Test
    public void shouldListAllConstraintsAtTimeOfSnapshot() {
        this.createUniquenessConstraint(this.label1, "name");
        StorageSchemaReader snapshot = this.storageReader.schemaSnapshot();
        this.createUniquenessConstraint(this.label2, "name");
        Set constraints = Iterators.asSet((Iterator)snapshot.constraintsGetAll());
        Set expectedConstraints = Iterators.asSet((Object[])new ConstraintDescriptor[]{this.uniqueConstraintDescriptor(this.label1, "name")});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    @Test
    public void shouldListAllConstraintsForLabel() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label2, "name");
        Set constraints = Iterators.asSet((Iterator)this.storageReader.constraintsGetForLabel(this.labelId(this.label1)));
        Set expectedConstraints = Iterators.asSet((Object[])new ConstraintDescriptor[]{this.uniqueConstraintDescriptor(this.label1, "name")});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    @Test
    public void shouldListAllConstraintsForLabelAtTimeOfSnapshot() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label2, "name");
        StorageSchemaReader snapshot = this.storageReader.schemaSnapshot();
        this.createUniquenessConstraint(this.label1, "age");
        Set constraints = Iterators.asSet((Iterator)snapshot.constraintsGetForLabel(this.labelId(this.label1)));
        Set expectedConstraints = Iterators.asSet((Object[])new ConstraintDescriptor[]{this.uniqueConstraintDescriptor(this.label1, "name")});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    @Test
    public void shouldListAllConstraintsForLabelAndProperty() {
        this.createUniquenessConstraint(this.label1, "name");
        this.createUniquenessConstraint(this.label1, "age");
        Set constraints = Iterators.asSet((Iterator)this.storageReader.constraintsGetForSchema(this.uniqueConstraintDescriptor(this.label1, "name").schema()));
        Set expectedConstraints = Iterators.asSet((Object[])new ConstraintDescriptor[]{this.uniqueConstraintDescriptor(this.label1, "name")});
        Assert.assertEquals((Object)expectedConstraints, (Object)constraints);
    }

    private void createIndex(Label label, String propertyKey) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(label).on(propertyKey).create();
            tx.success();
        }
    }

    private void dropIndex(Label label, String propertyKey) {
        try (Transaction tx = this.db.beginTx();){
            Iterable indexes = this.db.schema().getIndexes(label);
            for (IndexDefinition index : indexes) {
                Iterator keys = index.getPropertyKeys().iterator();
                if (!keys.hasNext() || !((String)keys.next()).equals(propertyKey) || keys.hasNext()) continue;
                index.drop();
            }
            tx.success();
        }
    }

    private void createUniquenessConstraint(Label label, String propertyKey) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
        }
    }

    private IndexDescriptor indexDescriptor(Label label, String propertyKey) {
        int labelId = this.labelId(label);
        int propKeyId = this.propertyKeyId(propertyKey);
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propKeyId}));
    }

    private ConstraintDescriptor uniqueConstraintDescriptor(Label label, String propertyKey) {
        int labelId = this.labelId(label);
        int propKeyId = this.propertyKeyId(propertyKey);
        return ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propKeyId});
    }
}

