/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.availability.DatabaseAvailability;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class GraphDatabaseServiceTest {
    @ClassRule
    public static final DatabaseRule globalDb = new ImpermanentDatabaseRule().withSetting(GraphDatabaseSettings.shutdown_transaction_end_timeout, "10s");
    private final ExpectedException exception = ExpectedException.none();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final OtherThreadRule<Void> t2 = new OtherThreadRule("T2-" + this.getClass().getName());
    private final OtherThreadRule<Void> t3 = new OtherThreadRule("T3-" + this.getClass().getName());
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.exception).around(this.t2).around(this.t3);

    @Test
    public void givenShutdownDatabaseWhenBeginTxThenExceptionIsThrown() {
        GraphDatabaseService db = this.getTemporaryDatabase();
        db.shutdown();
        this.exception.expect(DatabaseShutdownException.class);
        db.beginTx();
    }

    @Test
    public void givenDatabaseAndStartedTxWhenShutdownThenWaitForTxToFinish() throws Exception {
        GraphDatabaseService db = this.getTemporaryDatabase();
        Barrier.Control barrier = new Barrier.Control();
        Future txFuture = this.t2.execute(state -> {
            try (Transaction tx = db.beginTx();){
                barrier.reached();
                db.createNode();
                tx.success();
            }
            return null;
        });
        barrier.await();
        Future shutdownFuture = this.t3.execute(state -> {
            db.shutdown();
            return null;
        });
        this.t3.get().waitUntilWaiting(location -> location.isAt(DatabaseAvailability.class, "stop"));
        barrier.release();
        try {
            txFuture.get();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        shutdownFuture.get();
    }

    @Test
    public void terminateTransactionThrowsExceptionOnNextOperation() {
        DatabaseRule db = globalDb;
        try (Transaction tx = db.beginTx();){
            tx.terminate();
            try {
                db.createNode();
                Assert.fail((String)"Failed to throw TransactionTerminateException");
            }
            catch (TransactionTerminatedException transactionTerminatedException) {
                // empty catch block
            }
        }
    }

    @Test
    public void terminateNestedTransactionThrowsExceptionOnNextOperation() {
        DatabaseRule db = globalDb;
        try (Transaction tx = db.beginTx();){
            try (Transaction nested = db.beginTx();){
                tx.terminate();
            }
            try {
                db.createNode();
                Assert.fail((String)"Failed to throw TransactionTerminateException");
            }
            catch (TransactionTerminatedException transactionTerminatedException) {
                // empty catch block
            }
        }
    }

    @Test
    public void terminateNestedTransactionThrowsExceptionOnNextNestedOperation() {
        DatabaseRule db = globalDb;
        try (Transaction tx = db.beginTx();
             Transaction nested = db.beginTx();){
            tx.terminate();
            try {
                db.createNode();
                Assert.fail((String)"Failed to throw TransactionTerminateException");
            }
            catch (TransactionTerminatedException transactionTerminatedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void terminateNestedTransactionThrowsExceptionOnNextNestedOperationMultiThreadedVersion() throws Exception {
        GraphDatabaseService db = this.getTemporaryDatabase();
        try {
            CountDownLatch txSet = new CountDownLatch(1);
            CountDownLatch terminated = new CountDownLatch(1);
            Transaction[] outer = new Transaction[]{null};
            Exception[] threadFail = new Exception[]{null};
            Thread worker = new Thread(() -> {
                try (Transaction inner = db.beginTx();){
                    outer[0] = inner;
                    txSet.countDown();
                    terminated.await();
                    db.createNode();
                    Assert.fail((String)"should have failed earlier");
                }
                catch (Exception e) {
                    threadFail[0] = e;
                }
            });
            worker.start();
            txSet.await();
            outer[0].terminate();
            terminated.countDown();
            worker.join();
            Assert.assertThat((Object)threadFail[0], (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void terminateNestedTransactionThrowsExceptionOnNextNestedOperationMultiThreadedVersionWithNestedTx() throws Exception {
        GraphDatabaseService db = this.getTemporaryDatabase();
        try {
            CountDownLatch txSet = new CountDownLatch(1);
            CountDownLatch terminated = new CountDownLatch(1);
            Transaction[] outer = new Transaction[]{null};
            Exception[] threadFail = new Exception[]{null};
            Thread worker = new Thread(() -> {
                try (Transaction transaction = db.beginTx();
                     Transaction inner = db.beginTx();){
                    outer[0] = inner;
                    txSet.countDown();
                    terminated.await();
                    db.createNode();
                    Assert.fail((String)"should have failed earlier");
                }
            });
            worker.start();
            txSet.await();
            outer[0].terminate();
            terminated.countDown();
            worker.join();
            Assert.assertThat((Object)threadFail[0], (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void givenDatabaseAndStartedTxWhenShutdownAndStartNewTxThenBeginTxTimesOut() throws Exception {
        GraphDatabaseService db = this.getTemporaryDatabase();
        Barrier.Control barrier = new Barrier.Control();
        this.t2.execute(state -> {
            try (Transaction tx = db.beginTx();){
                barrier.reached();
            }
            return null;
        });
        barrier.await();
        Future shutdownFuture = this.t3.execute(state -> {
            db.shutdown();
            return null;
        });
        this.t3.get().waitUntilWaiting(location -> location.isAt(DatabaseAvailability.class, "stop"));
        barrier.release();
        shutdownFuture.get();
        try {
            db.beginTx();
            Assert.fail((String)"Should fail");
        }
        catch (DatabaseShutdownException databaseShutdownException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLetDetectedDeadlocksDuringCommitBeThrownInTheirOriginalForm() throws Exception {
        DatabaseRule db = globalDb;
        Node n1 = this.createNode((GraphDatabaseService)db);
        Node n2 = this.createNode((GraphDatabaseService)db);
        Relationship r3 = this.createRelationship(n1);
        Relationship r2 = this.createRelationship(n1);
        Relationship r1 = this.createRelationship(n1);
        Transaction t1Tx = db.beginTx();
        Transaction t2Tx = (Transaction)this.t2.execute(this.beginTx((GraphDatabaseService)db)).get();
        n2.setProperty("locked", (Object)"indeed");
        this.t2.execute(this.setProperty((PropertyContainer)r1, "locked", "absolutely")).get();
        Future t2n2Wait = this.t2.execute(this.setProperty((PropertyContainer)n2, "locked", "In my dreams"));
        this.t2.get().waitUntilWaiting();
        r2.delete();
        t1Tx.success();
        try {
            t1Tx.close();
            Assert.fail((String)"Should throw exception about deadlock");
        }
        catch (Exception e) {
            Assert.assertEquals(DeadlockDetectedException.class, e.getClass());
        }
        finally {
            t2n2Wait.get();
            this.t2.execute(this.close(t2Tx)).get();
        }
    }

    @Test
    public void terminationOfClosedTransactionDoesNotInfluenceNextTransaction() {
        Transaction transaction;
        DatabaseRule db = globalDb;
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        try (Transaction tx = transaction = db.beginTx();){
            db.createNode();
            tx.success();
        }
        transaction.terminate();
        tx = db.beginTx();
        var4_6 = null;
        try {
            Assert.assertThat((Object)db.getAllNodes(), (Matcher)Matchers.is((Matcher)Matchers.iterableWithSize((int)2)));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private OtherThreadExecutor.WorkerCommand<Void, Transaction> beginTx(GraphDatabaseService db) {
        return state -> db.beginTx();
    }

    private OtherThreadExecutor.WorkerCommand<Void, Object> setProperty(PropertyContainer entity, String key, String value) {
        return state -> {
            entity.setProperty(key, (Object)value);
            return null;
        };
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> close(Transaction tx) {
        return state -> {
            tx.close();
            return null;
        };
    }

    private Relationship createRelationship(Node node) {
        try (Transaction tx = node.getGraphDatabase().beginTx();){
            Relationship rel = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            tx.success();
            Relationship relationship = rel;
            return relationship;
        }
    }

    private Node createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private GraphDatabaseService getTemporaryDatabase() {
        return new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder(this.testDirectory.directory("impermanent")).setConfig(GraphDatabaseSettings.shutdown_transaction_end_timeout, "10s").newGraphDatabase();
    }
}

