/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.CleanupRule;

public class DiagnosticsLoggingTest {
    @Rule
    public CleanupRule cleanupRule = new CleanupRule();

    @Test
    public void shouldSeeExpectedDiagnostics() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)logProvider).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.dump_configuration, "true").setConfig(GraphDatabaseSettings.pagecache_memory, "4M").newGraphDatabase();
        this.cleanupRule.add((Object)db);
        logProvider.rawMessageMatcher().assertContains("Network information");
        logProvider.rawMessageMatcher().assertContains("Disk space on partition");
        logProvider.rawMessageMatcher().assertContains("Local timezone");
        logProvider.rawMessageMatcher().assertContains("Page cache: 4M");
        for (MetaDataStore.Position position : MetaDataStore.Position.values()) {
            logProvider.rawMessageMatcher().assertContains(position.name());
        }
        logProvider.rawMessageMatcher().assertContains("Transaction log");
        logProvider.rawMessageMatcher().assertContains("TimeZone version: ");
    }
}

