/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;

class RelationshipsIterationTest {
    private static final TestGraphDatabaseFactory FACTORY = new TestGraphDatabaseFactory();
    private static final int DENSE_NODE_THRESHOLD = 51;
    private static GraphDatabaseService DATABASE;
    private GraphDatabaseService db;
    private RelationshipType typeA = RelationshipType.withName((String)"A");
    private RelationshipType typeB = RelationshipType.withName((String)"B");
    private RelationshipType typeC = RelationshipType.withName((String)"C");
    private RelationshipType typeD = RelationshipType.withName((String)"D");
    private RelationshipType typeX = RelationshipType.withName((String)"X");

    RelationshipsIterationTest() {
    }

    @BeforeAll
    static void setUp() {
        DATABASE = FACTORY.newImpermanentDatabase();
    }

    @AfterAll
    static void tearDown() {
        DATABASE.shutdown();
    }

    @BeforeEach
    void setUpEach() {
        this.db = DATABASE;
        try (Transaction tx = this.db.beginTx();){
            this.db.getAllRelationships().forEach(Relationship::delete);
            this.db.getAllNodes().forEach(Node::delete);
            tx.success();
        }
    }

    private static interface Check {
        public void check(Node var1, Node var2, Node var3);
    }

    @Nested
    class WithDenseUnrelatedNode
    extends RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        WithDenseUnrelatedNode() {
        }

        @Override
        @BeforeEach
        void setUp() {
            super.setUp();
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                Node unrelated = RelationshipsIterationTest.this.db.getNodeById(this.notMatching);
                for (int i = 0; i < 51; ++i) {
                    unrelated.createRelationshipTo(unrelated, RelationshipsIterationTest.this.typeX);
                }
                tx.success();
            }
        }
    }

    @Nested
    class WithDenseSecondNode
    extends RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        WithDenseSecondNode() {
        }

        @Override
        @BeforeEach
        void setUp() {
            super.setUp();
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                Node second = RelationshipsIterationTest.this.db.getNodeById(this.matchingSecond);
                for (int i = 0; i < 51; ++i) {
                    second.createRelationshipTo(second, RelationshipsIterationTest.this.typeX);
                }
                tx.success();
            }
        }
    }

    @Nested
    class WithDenseFirstNode
    extends RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        WithDenseFirstNode() {
        }

        @Override
        @BeforeEach
        void setUp() {
            super.setUp();
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                Node first = RelationshipsIterationTest.this.db.getNodeById(this.matchingFirst);
                for (int i = 0; i < 51; ++i) {
                    first.createRelationshipTo(first, RelationshipsIterationTest.this.typeX);
                }
                tx.success();
            }
        }
    }

    @Nested
    class WithNoDenseNodes
    extends RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        WithNoDenseNodes() {
        }
    }

    abstract class RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships {
        long matchingFirst;
        long notMatching;
        long matchingSecond;

        RelationshipTraversalCursorReuseMustNotFalselyMatchRelationships() {
        }

        @BeforeEach
        void setUp() {
            Node first;
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                first = RelationshipsIterationTest.this.db.createNode();
                Node unrelated = RelationshipsIterationTest.this.db.createNode();
                Node second = RelationshipsIterationTest.this.db.createNode();
                this.matchingFirst = first.getId();
                this.notMatching = unrelated.getId();
                this.matchingSecond = second.getId();
                first.createRelationshipTo(second, RelationshipsIterationTest.this.typeA);
                first.createRelationshipTo(second, RelationshipsIterationTest.this.typeB);
                first.createRelationshipTo(unrelated, RelationshipsIterationTest.this.typeC);
                second.createRelationshipTo(unrelated, RelationshipsIterationTest.this.typeD);
                tx.success();
            }
            tx = RelationshipsIterationTest.this.db.beginTx();
            var2_2 = null;
            try {
                first = RelationshipsIterationTest.this.db.getNodeById(this.matchingFirst);
                Node second = RelationshipsIterationTest.this.db.getNodeById(this.matchingSecond);
                first.createRelationshipTo(second, RelationshipsIterationTest.this.typeA);
                first.createRelationshipTo(second, RelationshipsIterationTest.this.typeB);
                tx.success();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var2_2 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }

        @Test
        void matchNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertTrue((boolean)second.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMatch3() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertFalse((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeD}));
                Assert.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMatch4() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)second.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void matchNotMisdir1() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
                Assert.assertFalse((boolean)unrelated.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.BOTH));
                Assert.assertFalse((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
            });
        }

        @Test
        void matchNotMisdir2() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
                Assert.assertFalse((boolean)unrelated.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.BOTH));
                Assert.assertFalse((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
            });
        }

        @Test
        void misdirNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertFalse((boolean)unrelated.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.BOTH));
                Assert.assertTrue((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
            });
        }

        @Test
        void misdirNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
                Assert.assertFalse((boolean)unrelated.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.BOTH));
                Assert.assertTrue((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
            });
        }

        @Test
        void notMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertTrue((boolean)second.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void notMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void misdirMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertTrue((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
            });
        }

        @Test
        void misdirMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
                Assert.assertTrue((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
            });
        }

        @Test
        void matchMisdirMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
                Assert.assertFalse((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertTrue((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
            });
        }

        @Test
        void matchMisdirMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertFalse((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertTrue((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
            });
        }

        @Test
        void matchMisdirMatch3() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertFalse((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertTrue((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
            });
        }

        @Test
        void matchMisdirMatch4() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
                Assert.assertFalse((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertTrue((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
            });
        }

        @Test
        void matchMisdirMatch5() {
            this.check((first, unrelated, second) -> {
                Assert.assertTrue((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
                Assert.assertFalse((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
                Assert.assertTrue((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
            });
        }

        @Test
        void notMisdir1() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)unrelated.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.BOTH));
                Assert.assertFalse((boolean)second.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.OUTGOING));
            });
        }

        @Test
        void notMisdir2() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)unrelated.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.BOTH));
                Assert.assertFalse((boolean)first.hasRelationship(RelationshipsIterationTest.this.typeA, Direction.INCOMING));
            });
        }

        @Test
        void notMatchNot1() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertTrue((boolean)first.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void notMatchNot2() {
            this.check((first, unrelated, second) -> {
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertTrue((boolean)second.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
                Assert.assertFalse((boolean)unrelated.hasRelationship(new RelationshipType[]{RelationshipsIterationTest.this.typeA}));
            });
        }

        @Test
        void countMatchNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMatch3() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeD, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeD})));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMatch4() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMatchNotMisdir1() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(RelationshipsIterationTest.this.typeA, Direction.BOTH)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
            });
        }

        @Test
        void countMatchNotMisdir2() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(RelationshipsIterationTest.this.typeA, Direction.BOTH)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
            });
        }

        @Test
        void countMisdirNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(RelationshipsIterationTest.this.typeA, Direction.BOTH)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
            });
        }

        @Test
        void countMisdirNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(RelationshipsIterationTest.this.typeA, Direction.BOTH)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
            });
        }

        @Test
        void countNotMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countNotMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countMisdirMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
            });
        }

        @Test
        void countMisdirMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
            });
        }

        @Test
        void countMatchMisdirMatch1() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
            });
        }

        @Test
        void countMatchMisdirMatch2() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
            });
        }

        @Test
        void countMatchMisdirMatch3() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
            });
        }

        @Test
        void countMatchMisdirMatch4() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
            });
        }

        @Test
        void countMatchMisdirMatch5() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
            });
        }

        @Test
        void countNotMisdir1() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(RelationshipsIterationTest.this.typeA, Direction.BOTH)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(RelationshipsIterationTest.this.typeA, Direction.OUTGOING)));
            });
        }

        @Test
        void countNotMisdir2() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(RelationshipsIterationTest.this.typeA, Direction.BOTH)));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(RelationshipsIterationTest.this.typeA, Direction.INCOMING)));
            });
        }

        @Test
        void countNotMatchNot1() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, first.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        @Test
        void countNotMatchNot2() {
            this.check((first, unrelated, second) -> {
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)2L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, second.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
                Assert.assertEquals((long)0L, (long)this.countTypes(RelationshipsIterationTest.this.typeA, unrelated.getRelationships(new RelationshipType[]{RelationshipsIterationTest.this.typeA})));
            });
        }

        private void check(Check check) {
            try (Transaction tx = RelationshipsIterationTest.this.db.beginTx();){
                Node first = RelationshipsIterationTest.this.db.getNodeById(this.matchingFirst);
                Node unrelated = RelationshipsIterationTest.this.db.getNodeById(this.notMatching);
                Node second = RelationshipsIterationTest.this.db.getNodeById(this.matchingSecond);
                check.check(first, unrelated, second);
            }
        }

        private int countTypes(RelationshipType type, Iterable<Relationship> iterable) {
            int count = 0;
            for (Relationship relationship : iterable) {
                Assert.assertEquals((Object)type, (Object)relationship.getType());
                ++count;
            }
            return count;
        }
    }
}

