/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.test.Race;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class ConsistentPropertyReadsIT {
    @Rule
    public DatabaseRule db = new EmbeddedDatabaseRule();

    @Test
    public void shouldReadConsistentPropertyValues() throws Throwable {
        int i;
        Node[] nodes = new Node[10];
        String[] keys = new String[]{"1", "2", "3"};
        String[] values = new String[]{this.longString('a'), this.longString('b'), this.longString('c')};
        try (Transaction tx = this.db.beginTx();){
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                nodes[i2] = this.db.createNode();
                for (String key : keys) {
                    nodes[i2].setProperty(key, (Object)values[0]);
                }
            }
            tx.success();
        }
        int updaters = 10;
        AtomicLong updatersDone = new AtomicLong(updaters);
        Race race = new Race();
        for (i = 0; i < updaters; ++i) {
            race.addContestant(() -> {
                try {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    for (int j = 0; j < 100; ++j) {
                        Node node = nodes[random.nextInt(nodes.length)];
                        String key = keys[random.nextInt(keys.length)];
                        try (Transaction tx = this.db.beginTx();){
                            node.removeProperty(key);
                            tx.success();
                        }
                        tx = this.db.beginTx();
                        var10_10 = null;
                        try {
                            node.setProperty(key, (Object)values[random.nextInt(values.length)]);
                            tx.success();
                            continue;
                        }
                        catch (Throwable throwable) {
                            var10_10 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (tx != null) {
                                if (var10_10 != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable) {
                                        var10_10.addSuppressed(throwable);
                                    }
                                } else {
                                    tx.close();
                                }
                            }
                        }
                    }
                }
                finally {
                    updatersDone.decrementAndGet();
                }
            });
        }
        for (i = 0; i < 100; ++i) {
            race.addContestant(() -> {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                while (updatersDone.get() > 0L) {
                    Transaction tx = this.db.beginTx();
                    Throwable throwable = null;
                    try {
                        String value = (String)nodes[random.nextInt(nodes.length)].getProperty(keys[random.nextInt(keys.length)], null);
                        Assert.assertTrue((String)value, (value == null || ArrayUtil.contains((Object[])values, (Object)value) ? 1 : 0) != 0);
                        tx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
            });
        }
        race.go();
    }

    private String longString(char c) {
        char[] chars = new char[ThreadLocalRandom.current().nextInt(800, 1000)];
        Arrays.fill(chars, c);
        return new String(chars);
    }
}

