/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.function.Consumer;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public enum NodeFacadeMethods implements Consumer<Node>
{
    HAS_PROPERTY((FacadeMethod<Node>)new FacadeMethod("boolean hasProperty( String key )", n -> n.hasProperty("foo"))),
    GET_PROPERTY((FacadeMethod<Node>)new FacadeMethod("Object getProperty( String key )", n -> n.getProperty("foo"))),
    GET_PROPERTY_WITH_DEFAULT((FacadeMethod<Node>)new FacadeMethod("Object getProperty( String key, Object defaultValue )", n -> n.getProperty("foo", (Object)42))),
    SET_PROPERTY((FacadeMethod<Node>)new FacadeMethod("void setProperty( String key, Object value )", n -> n.setProperty("foo", (Object)42))),
    REMOVE_PROPERTY((FacadeMethod<Node>)new FacadeMethod("Object removeProperty( String key )", n -> n.removeProperty("foo"))),
    GET_PROPERTY_KEYS((FacadeMethod<Node>)new FacadeMethod("Iterable<String> getPropertyKeys()", n -> FacadeMethod.consume((Iterable)n.getPropertyKeys()))),
    DELETE((FacadeMethod<Node>)new FacadeMethod("void delete()", Node::delete)),
    GET_RELATIONSHIPS((FacadeMethod<Node>)new FacadeMethod("Iterable<Relationship> getRelationships()", n -> FacadeMethod.consume((Iterable)n.getRelationships()))),
    HAS_RELATIONSHIP((FacadeMethod<Node>)new FacadeMethod("boolean hasRelationship()", Node::hasRelationship)),
    GET_RELATIONSHIPS_BY_TYPE((FacadeMethod<Node>)new FacadeMethod("Iterable<Relationship> getRelationships( RelationshipType... types )", n -> FacadeMethod.consume((Iterable)n.getRelationships(new RelationshipType[]{FacadeMethod.FOO, FacadeMethod.BAR})))),
    GET_RELATIONSHIPS_BY_DIRECTION_AND_TYPES((FacadeMethod<Node>)new FacadeMethod("Iterable<Relationship> getRelationships( Direction direction, RelationshipType... types )", n -> FacadeMethod.consume((Iterable)n.getRelationships(Direction.BOTH, new RelationshipType[]{FacadeMethod.FOO, FacadeMethod.BAR})))),
    HAS_RELATIONSHIP_BY_TYPE((FacadeMethod<Node>)new FacadeMethod("boolean hasRelationship( RelationshipType... types )", n -> n.hasRelationship(new RelationshipType[]{FacadeMethod.FOO}))),
    HAS_RELATIONSHIP_BY_DIRECTION_AND_TYPE((FacadeMethod<Node>)new FacadeMethod("boolean hasRelationship( Direction direction, RelationshipType... types )", n -> n.hasRelationship(Direction.BOTH, new RelationshipType[]{FacadeMethod.FOO}))),
    GET_RELATIONSHIPS_BY_DIRECTION((FacadeMethod<Node>)new FacadeMethod("Iterable<Relationship> getRelationships( Direction dir )", n -> FacadeMethod.consume((Iterable)n.getRelationships(Direction.BOTH)))),
    HAS_RELATIONSHIP_BY_DIRECTION((FacadeMethod<Node>)new FacadeMethod("boolean hasRelationship( Direction dir )", n -> n.hasRelationship(Direction.BOTH))),
    GET_RELATIONSHIPS_BY_TYPE_AND_DIRECTION((FacadeMethod<Node>)new FacadeMethod("Iterable<Relationship> getRelationships( RelationshipType type, Direction dir )", n -> FacadeMethod.consume((Iterable)n.getRelationships(FacadeMethod.FOO, Direction.BOTH)))),
    HAS_RELATIONSHIP_BY_TYPE_AND_DIRECTION((FacadeMethod<Node>)new FacadeMethod("boolean hasRelationship( RelationshipType type, Direction dir )", n -> n.hasRelationship(FacadeMethod.FOO, Direction.BOTH))),
    GET_SINGLE_RELATIONSHIP((FacadeMethod<Node>)new FacadeMethod("Relationship getSingleRelationship( RelationshipType type, Direction dir )", n -> n.getSingleRelationship(FacadeMethod.FOO, Direction.BOTH))),
    CREATE_RELATIONSHIP_TO((FacadeMethod<Node>)new FacadeMethod("Relationship createRelationshipTo( Node otherNode, RelationshipType type )", n -> n.createRelationshipTo(n, FacadeMethod.FOO))),
    ADD_LABEL((FacadeMethod<Node>)new FacadeMethod("void addLabel( Label label )", n -> n.addLabel(FacadeMethod.QUUX))),
    REMOVE_LABEL((FacadeMethod<Node>)new FacadeMethod("void removeLabel( Label label )", n -> n.removeLabel(FacadeMethod.QUUX))),
    HAS_LABEL((FacadeMethod<Node>)new FacadeMethod("boolean hasLabel( Label label )", n -> n.hasLabel(FacadeMethod.QUUX))),
    GET_LABELS((FacadeMethod<Node>)new FacadeMethod("ResourceIterable<Label> getLabels()", n -> FacadeMethod.consume((Iterable)n.getLabels())));

    private final FacadeMethod<Node> facadeMethod;

    private NodeFacadeMethods(FacadeMethod<Node> facadeMethod) {
        this.facadeMethod = facadeMethod;
    }

    @Override
    public void accept(Node node) {
        this.facadeMethod.accept((Object)node);
    }

    public String toString() {
        return this.facadeMethod.toString();
    }
}

