/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class CancelIndexPopulationIT {
    private static final Label LABEL = TestLabels.LABEL_ONE;
    private static final String KEY = "key";
    @Rule
    public final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();

    @Test
    public void shouldKeepIndexInPopulatingStateBetweenRestarts() throws InterruptedException, IOException {
        Monitors monitors = (Monitors)this.db.getDependencyResolver().resolveDependency(Monitors.class);
        Barrier.Control barrier = new Barrier.Control();
        monitors.addMonitorListener((Object)this.populationCompletionBlocker(barrier), new String[0]);
        this.createRelevantNode();
        this.createIndex();
        barrier.await();
        this.db.restartDatabase(new String[0]);
        Assert.assertEquals((Object)Schema.IndexState.ONLINE, (Object)this.awaitAndGetIndexState());
    }

    private Schema.IndexState awaitAndGetIndexState() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition indexDefinition = (IndexDefinition)Iterables.first((Iterable)this.db.schema().getIndexes(LABEL));
            this.db.schema().awaitIndexOnline(indexDefinition, 1L, TimeUnit.MINUTES);
            Schema.IndexState indexState = this.db.schema().getIndexState(indexDefinition);
            tx.success();
            Schema.IndexState indexState2 = indexState;
            return indexState2;
        }
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(LABEL).on(KEY).create();
            tx.success();
        }
    }

    private void createRelevantNode() {
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)"value");
            tx.success();
        }
    }

    private IndexingService.MonitorAdapter populationCompletionBlocker(final Barrier.Control barrier) {
        return new IndexingService.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                barrier.reached();
            }

            public void populationCancelled() {
                barrier.release();
            }
        };
    }
}

