/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.test.Race;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class UpdateDeletedIndexIT {
    private static final TestLabels LABEL = TestLabels.LABEL_ONE;
    private static final String KEY = "key";
    private static final int NODES = 100;
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();

    @Test
    public void shouldHandleUpdateRemovalOfLabelConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation(nodeId -> this.db.getNodeById(nodeId).removeLabel((Label)LABEL));
    }

    @Test
    public void shouldHandleDeleteNodeConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation(nodeId -> this.db.getNodeById(nodeId).delete());
    }

    @Test
    public void shouldHandleRemovePropertyConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation(nodeId -> this.db.getNodeById(nodeId).removeProperty(KEY));
    }

    @Test
    public void shouldHandleNodeDetachDeleteConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation(nodeId -> {
            ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            txBridge.getKernelTransactionBoundToThisThread(true).dataWrite().nodeDetachDelete(nodeId);
        });
    }

    private void shouldHandleIndexDropConcurrentlyWithOperation(NodeOperation operation) throws Throwable {
        long[] nodes = this.createNodes();
        IndexDefinition indexDefinition = this.createIndex();
        Race race = new Race();
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                indexDefinition.drop();
                tx.success();
            }
        }, 1);
        for (int i = 0; i < 100; ++i) {
            long nodeId = nodes[i];
            race.addContestant(Race.throwing(() -> {
                try (Transaction tx = this.db.beginTx();){
                    operation.run(nodeId);
                    tx.success();
                }
            }));
        }
        race.go();
    }

    private long[] createNodes() {
        long[] nodes = new long[100];
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node node = this.db.createNode(new Label[]{LABEL});
                node.setProperty(KEY, (Object)i);
                nodes[i] = node.getId();
            }
            tx.success();
        }
        return nodes;
    }

    private IndexDefinition createIndex() {
        IndexDefinition indexDefinition;
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                this.db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)i);
            }
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            indexDefinition = this.db.schema().indexFor((Label)LABEL).on(KEY).create();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_6 = null;
        try {
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return indexDefinition;
    }

    private static interface NodeOperation {
        public void run(long var1) throws Exception;
    }
}

