/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.ClassGuardedAdversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.annotations.ReporterFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.AdversarialPageCacheGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RecoveryIT {
    private static final String[] TOKENS = new String[]{"Token1", "Token2", "Token3", "Token4", "Token5"};
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final RandomRule random = new RandomRule();
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.fileSystemRule).around((TestRule)this.directory);

    @Test
    public void idGeneratorsRebuildAfterRecovery() throws IOException {
        GraphDatabaseService database = this.startDatabase(this.directory.databaseDir());
        int numberOfNodes = 10;
        try (Transaction transaction = database.beginTx();){
            for (int nodeIndex = 0; nodeIndex < numberOfNodes; ++nodeIndex) {
                database.createNode();
            }
            transaction.success();
        }
        File restoreDbStoreDir = this.copyTransactionLogs();
        GraphDatabaseService recoveredDatabase = this.startDatabase(restoreDbStoreDir);
        try (Transaction tx = recoveredDatabase.beginTx();){
            Assert.assertEquals((long)numberOfNodes, (long)Iterables.count((Iterable)recoveredDatabase.getAllNodes()));
            recoveredDatabase.createNode();
        }
        database.shutdown();
        recoveredDatabase.shutdown();
    }

    @Test
    public void reportProgressOnRecovery() throws IOException {
        GraphDatabaseService database = this.startDatabase(this.directory.databaseDir());
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                database.createNode();
                transaction.success();
                continue;
            }
        }
        File restoreDbStoreDir = this.copyTransactionLogs();
        GraphDatabaseService recoveredDatabase = this.startDatabase(restoreDbStoreDir);
        try (Transaction transaction = recoveredDatabase.beginTx();){
            Assert.assertEquals((long)10L, (long)Iterables.count((Iterable)recoveredDatabase.getAllNodes()));
        }
        this.logProvider.rawMessageMatcher().assertContains("10% completed");
        this.logProvider.rawMessageMatcher().assertContains("100% completed");
        database.shutdown();
        recoveredDatabase.shutdown();
    }

    @Test
    public void shouldRecoverIdsCorrectlyWhenWeCreateAndDeleteANodeInTheSameRecoveryRun() throws IOException {
        Node node;
        GraphDatabaseService database = this.startDatabase(this.directory.databaseDir());
        Label testLabel = Label.label((String)"testLabel");
        String propertyToDelete = "propertyToDelete";
        String validPropertyName = "validProperty";
        try (Transaction transaction = database.beginTx();){
            node = database.createNode();
            node.addLabel(testLabel);
            transaction.success();
        }
        transaction = database.beginTx();
        var6_6 = null;
        try {
            node = RecoveryIT.findNodeByLabel(database, testLabel);
            node.setProperty("propertyToDelete", (Object)RecoveryIT.createLongString());
            node.setProperty("validProperty", (Object)RecoveryIT.createLongString());
            transaction.success();
        }
        catch (Throwable node2) {
            var6_6 = node2;
            throw node2;
        }
        finally {
            if (transaction != null) {
                if (var6_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable node2) {
                        var6_6.addSuppressed(node2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = database.beginTx();
        var6_6 = null;
        try {
            node = RecoveryIT.findNodeByLabel(database, testLabel);
            node.removeProperty("propertyToDelete");
            transaction.success();
        }
        catch (Throwable node3) {
            var6_6 = node3;
            throw node3;
        }
        finally {
            if (transaction != null) {
                if (var6_6 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable node3) {
                        var6_6.addSuppressed(node3);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        File restoreDbStoreDir = this.copyTransactionLogs();
        GraphDatabaseService recoveredDatabase = this.startDatabase(restoreDbStoreDir);
        try (Transaction ignored = recoveredDatabase.beginTx();){
            Node node4 = RecoveryIT.findNodeByLabel(recoveredDatabase, testLabel);
            Assert.assertFalse((boolean)node4.hasProperty("propertyToDelete"));
            Assert.assertTrue((boolean)node4.hasProperty("validProperty"));
        }
        database.shutdown();
        recoveredDatabase.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void recoveryShouldFixPartiallyAppliedSchemaIndexUpdates() {
        Label label = Label.label((String)"Foo");
        String property = "Bar";
        ClassGuardedAdversary adversary = new ClassGuardedAdversary((Adversary)new CountingAdversary(1, true), new Class[]{Command.RelationshipCommand.class});
        adversary.disable();
        File databaseDir = this.directory.databaseDir();
        GraphDatabaseService db = AdversarialPageCacheGraphDatabaseFactory.create((FileSystemAbstraction)this.fileSystemRule.get(), (Adversary)adversary).newEmbeddedDatabaseBuilder(databaseDir).newGraphDatabase();
        try {
            Throwable throwable;
            Transaction tx;
            try (Transaction tx2 = db.beginTx();){
                db.schema().constraintFor(label).assertPropertyIsUnique(property).create();
                tx2.success();
            }
            long relationshipId = RecoveryIT.createRelationship(db);
            TransactionFailureException txFailure = null;
            try {
                tx = db.beginTx();
                throwable = null;
                try {
                    Node node = db.createNode(new Label[]{label});
                    node.setProperty(property, (Object)"B");
                    db.getRelationshipById(relationshipId).delete();
                    tx.success();
                    adversary.enable();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (TransactionFailureException e) {
                txFailure = e;
            }
            Assert.assertNotNull((Object)((Object)txFailure));
            adversary.disable();
            RecoveryIT.healthOf(db).healed();
            tx = db.beginTx();
            throwable = null;
            try {
                Assert.assertNotNull((Object)RecoveryIT.findNode(db, label, property, "B"));
                Assert.assertNotNull((Object)db.getRelationshipById(relationshipId));
                tx.success();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            RecoveryIT.healthOf(db).panic(txFailure.getCause());
            File databaseDirectory = ((GraphDatabaseAPI)db).databaseLayout().databaseDirectory();
            db.shutdown();
            db = this.startDatabase(databaseDirectory);
            try (Transaction tx3 = db.beginTx();){
                Assert.assertNotNull((Object)RecoveryIT.findNode(db, label, property, "B"));
                RecoveryIT.assertRelationshipNotExist(db, relationshipId);
                tx3.success();
            }
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void shouldSeeSameIndexUpdatesDuringRecoveryAsFromNormalIndexApplication() throws Exception {
        File storeDir = this.directory.absolutePath();
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        UpdateCapturingIndexProvider updateCapturingIndexProvider = new UpdateCapturingIndexProvider(IndexProvider.EMPTY, new HashMap());
        GraphDatabaseAPI db = RecoveryIT.startDatabase(storeDir, fs, updateCapturingIndexProvider);
        TestLabels label = TestLabels.LABEL_ONE;
        String key1 = "key1";
        String key2 = "key2";
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor((Label)label).on(key1).create();
            db.schema().indexFor((Label)label).on(key1).on(key2).create();
            tx.success();
        }
        tx = db.beginTx();
        var9_9 = null;
        try {
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        RecoveryIT.checkPoint((GraphDatabaseService)db);
        this.produceRandomNodePropertyAndLabelUpdates((GraphDatabaseService)db, this.random.intBetween(20, 40), (Label)label, key1, key2);
        RecoveryIT.checkPoint((GraphDatabaseService)db);
        Map<Long, Collection<IndexEntryUpdate<?>>> updatesAtLastCheckPoint = updateCapturingIndexProvider.snapshot();
        this.produceRandomNodePropertyAndLabelUpdates((GraphDatabaseService)db, this.random.intBetween(40, 100), (Label)label, key1, key2);
        RecoveryIT.flush((GraphDatabaseService)db);
        EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        Map<Long, Collection<IndexEntryUpdate<?>>> updatesAtCrash = updateCapturingIndexProvider.snapshot();
        UpdateCapturingIndexProvider recoveredUpdateCapturingIndexProvider = new UpdateCapturingIndexProvider(IndexProvider.EMPTY, updatesAtLastCheckPoint);
        long lastCommittedTxIdBeforeRecovered = RecoveryIT.lastCommittedTxId((GraphDatabaseService)db);
        db.shutdown();
        fs.close();
        db = RecoveryIT.startDatabase(storeDir, crashedFs, recoveredUpdateCapturingIndexProvider);
        long lastCommittedTxIdAfterRecovered = RecoveryIT.lastCommittedTxId((GraphDatabaseService)db);
        Map<Long, Collection<IndexEntryUpdate<?>>> updatesAfterRecovery = recoveredUpdateCapturingIndexProvider.snapshot();
        Assert.assertEquals((long)lastCommittedTxIdBeforeRecovered, (long)lastCommittedTxIdAfterRecovered);
        this.assertSameUpdates(updatesAtCrash, updatesAfterRecovery);
        db.shutdown();
        crashedFs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSeeTheSameRecordsAtCheckpointAsAfterReverseRecovery() throws Exception {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fs).newImpermanentDatabase(this.directory.databaseDir());
        this.produceRandomGraphUpdates(db, 100);
        RecoveryIT.checkPoint(db);
        EphemeralFileSystemAbstraction checkPointFs = fs.snapshot();
        this.produceRandomGraphUpdates(db, 100);
        RecoveryIT.flush(db);
        final EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        db.shutdown();
        fs.close();
        Monitors monitors = new Monitors();
        final AtomicReference pageCache = new AtomicReference();
        final AtomicReference reversedFs = new AtomicReference();
        monitors.addMonitorListener((Object)new RecoveryMonitor(){

            public void reverseStoreRecoveryCompleted(long checkpointTxId) {
                try {
                    ((PageCache)pageCache.get()).flushAndForce();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                reversedFs.set(crashedFs.snapshot());
            }
        }, new String[0]);
        new TestGraphDatabaseFactory(){

            protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final File storeDir, final TestGraphDatabaseFactoryState state) {
                return new GraphDatabaseBuilder.DatabaseCreator(){

                    public GraphDatabaseService newDatabase(@Nonnull Config config) {
                        TestGraphDatabaseFactory.TestGraphDatabaseFacadeFactory factory = new TestGraphDatabaseFactory.TestGraphDatabaseFacadeFactory(state, true){

                            protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                                PlatformModule platform = super.createPlatform(storeDir, config, dependencies);
                                pageCache.set(platform.pageCache);
                                return platform;
                            }
                        };
                        return factory.newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies()));
                    }
                };
            }
        }.setFileSystem((FileSystemAbstraction)crashedFs).setMonitors(monitors).newImpermanentDatabase(this.directory.databaseDir()).shutdown();
        fs.close();
        try {
            RecoveryIT.assertSameStoreContents(checkPointFs, (EphemeralFileSystemAbstraction)reversedFs.get(), this.directory.databaseLayout());
        }
        finally {
            checkPointFs.close();
            ((EphemeralFileSystemAbstraction)reversedFs.get()).close();
        }
    }

    private static long lastCommittedTxId(GraphDatabaseService db) {
        return ((TransactionIdStore)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
    }

    private static void assertSameStoreContents(EphemeralFileSystemAbstraction fs1, EphemeralFileSystemAbstraction fs2, DatabaseLayout databaseLayout) {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        VersionContextSupplier contextSupplier = EmptyVersionContextSupplier.EMPTY;
        try (ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
             PageCache pageCache1 = new ConfiguringPageCacheFactory((FileSystemAbstraction)fs1, Config.defaults(), PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), contextSupplier, (JobScheduler)jobScheduler).getOrCreatePageCache();
             PageCache pageCache2 = new ConfiguringPageCacheFactory((FileSystemAbstraction)fs2, Config.defaults(), PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), contextSupplier, (JobScheduler)jobScheduler).getOrCreatePageCache();
             NeoStores store1 = new StoreFactory(databaseLayout, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fs1), pageCache1, (FileSystemAbstraction)fs1, (LogProvider)logProvider, contextSupplier).openAllNeoStores();
             NeoStores store2 = new StoreFactory(databaseLayout, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fs2), pageCache2, (FileSystemAbstraction)fs2, (LogProvider)logProvider, contextSupplier).openAllNeoStores();){
            for (StoreType storeType : StoreType.values()) {
                if (!storeType.isRecordStore()) continue;
                RecoveryIT.assertSameStoreContents(store1.getRecordStore(storeType), store2.getRecordStore(storeType));
            }
        }
    }

    private static <RECORD extends AbstractBaseRecord> void assertSameStoreContents(RecordStore<RECORD> store1, RecordStore<RECORD> store2) {
        long highId1 = store1.getHighId();
        long highId2 = store2.getHighId();
        long maxHighId = Long.max(highId1, highId2);
        AbstractBaseRecord record1 = store1.newRecord();
        AbstractBaseRecord record2 = store2.newRecord();
        for (long id = (long)store1.getNumberOfReservedLowIds(); id < maxHighId; ++id) {
            store1.getRecord(id, record1, RecordLoad.CHECK);
            store2.getRecord(id, record2, RecordLoad.CHECK);
            Assert.assertEquals((Object)record1, (Object)record2);
        }
    }

    private static void flush(GraphDatabaseService db) {
        ((StorageEngine)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(StorageEngine.class)).flushAndForce(IOLimiter.UNLIMITED);
    }

    private static void checkPoint(GraphDatabaseService db) throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Manual trigger"));
    }

    private void produceRandomGraphUpdates(GraphDatabaseService db, int numberOfTransactions) {
        Throwable throwable;
        ArrayList<Node> nodes = new ArrayList<Node>();
        try (Transaction tx = db.beginTx();){
            throwable = null;
            try (ResourceIterator allNodes = db.getAllNodes().iterator();){
                while (allNodes.hasNext()) {
                    nodes.add((Node)allNodes.next());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            tx.success();
        }
        for (int i = 0; i < numberOfTransactions; ++i) {
            int transactionSize = this.random.intBetween(1, 30);
            throwable = null;
            try (Transaction tx = db.beginTx();){
                for (int j = 0; j < transactionSize; ++j) {
                    float operationType = this.random.nextFloat();
                    float operation = this.random.nextFloat();
                    if ((double)operationType < 0.5) {
                        if ((double)operation < 0.5) {
                            Node node2 = db.createNode(this.random.nextBoolean() ? (Label[])ArrayUtil.array((Object[])new Label[]{this.randomLabel()}) : new Label[]{});
                            if (!this.random.nextBoolean()) continue;
                            node2.setProperty(this.randomKey(), this.random.nextValueAsObject());
                            continue;
                        }
                        if (nodes.isEmpty()) continue;
                        Relationship relationship2 = ((Node)this.random.among(nodes)).createRelationshipTo((Node)this.random.among(nodes), this.randomRelationshipType());
                        if (!this.random.nextBoolean()) continue;
                        relationship2.setProperty(this.randomKey(), this.random.nextValueAsObject());
                        continue;
                    }
                    if ((double)operationType < 0.8) {
                        if ((double)operation < 0.25) {
                            this.random.among(nodes, node -> node.addLabel(this.randomLabel()));
                            continue;
                        }
                        if ((double)operation < 0.5) {
                            this.random.among(nodes, node -> node.removeLabel(this.randomLabel()));
                            continue;
                        }
                        if ((double)operation < 0.75) {
                            this.random.among(nodes, node -> node.setProperty(this.randomKey(), this.random.nextValueAsObject()));
                            continue;
                        }
                        this.onRandomRelationship(nodes, relationship -> relationship.setProperty(this.randomKey(), this.random.nextValueAsObject()));
                        continue;
                    }
                    if ((double)operation < 0.25) {
                        this.random.among(nodes, node -> node.removeProperty(this.randomKey()));
                        continue;
                    }
                    if ((double)operation < 0.5) {
                        this.onRandomRelationship(nodes, relationship -> relationship.removeProperty(this.randomKey()));
                        continue;
                    }
                    if ((double)operation < 0.9) {
                        this.onRandomRelationship(nodes, Relationship::delete);
                        continue;
                    }
                    this.random.among(nodes, node -> {
                        for (Relationship relationship : node.getRelationships()) {
                            relationship.delete();
                        }
                        node.delete();
                        nodes.remove(node);
                    });
                }
                tx.success();
                continue;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    private void onRandomRelationship(List<Node> nodes, Consumer<Relationship> action) {
        this.random.among(nodes, node -> this.random.among(Iterables.asList((Iterable)node.getRelationships()), action));
    }

    private RelationshipType randomRelationshipType() {
        return RelationshipType.withName((String)((String)this.random.among((Object[])TOKENS)));
    }

    private String randomKey() {
        return (String)this.random.among((Object[])TOKENS);
    }

    private Label randomLabel() {
        return Label.label((String)((String)this.random.among((Object[])TOKENS)));
    }

    private void assertSameUpdates(Map<Long, Collection<IndexEntryUpdate<?>>> updatesAtCrash, Map<Long, Collection<IndexEntryUpdate<?>>> recoveredUpdatesSnapshot) {
        Map<Long, Map<Long, Collection<IndexEntryUpdate<?>>>> crashUpdatesPerNode = RecoveryIT.splitPerNode(updatesAtCrash);
        Map<Long, Map<Long, Collection<IndexEntryUpdate<?>>>> recoveredUpdatesPerNode = RecoveryIT.splitPerNode(recoveredUpdatesSnapshot);
        Assert.assertEquals(crashUpdatesPerNode, recoveredUpdatesPerNode);
    }

    private static Map<Long, Map<Long, Collection<IndexEntryUpdate<?>>>> splitPerNode(Map<Long, Collection<IndexEntryUpdate<?>>> updates) {
        HashMap result = new HashMap();
        updates.forEach((indexId, indexUpdates) -> result.put((Long)indexId, RecoveryIT.splitPerNode(indexUpdates)));
        return result;
    }

    private static Map<Long, Collection<IndexEntryUpdate<?>>> splitPerNode(Collection<IndexEntryUpdate<?>> updates) {
        HashMap perNode = new HashMap();
        updates.forEach(update -> perNode.computeIfAbsent(update.getEntityId(), nodeId -> new ArrayList()).add(update));
        return perNode;
    }

    private void produceRandomNodePropertyAndLabelUpdates(GraphDatabaseService db, int numberOfTransactions, Label label, String ... keys) {
        Throwable throwable;
        ArrayList<Object> nodes = new ArrayList<Object>();
        try (Transaction tx = db.beginTx();){
            throwable = null;
            try (ResourceIterator allNodes = db.getAllNodes().iterator();){
                while (allNodes.hasNext()) {
                    nodes.add(allNodes.next());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            tx.success();
        }
        for (int i = 0; i < numberOfTransactions; ++i) {
            int transactionSize = this.random.intBetween(1, 30);
            throwable = null;
            try (Transaction tx = db.beginTx();){
                for (int j = 0; j < transactionSize; ++j) {
                    float operation = this.random.nextFloat();
                    if ((double)operation < 0.1) {
                        if (nodes.isEmpty()) continue;
                        ((Node)nodes.remove(this.random.nextInt(nodes.size()))).delete();
                        continue;
                    }
                    if ((double)operation < 0.3) {
                        Node node2 = db.createNode(this.random.nextBoolean() ? (Label[])ArrayUtil.array((Object[])new Label[]{label}) : new Label[]{});
                        for (String key : keys) {
                            if (!this.random.nextBoolean()) continue;
                            node2.setProperty(key, this.random.nextValueAsObject());
                        }
                        nodes.add(node2);
                        continue;
                    }
                    if ((double)operation < 0.4) {
                        this.random.among(nodes, node -> node.removeLabel(label));
                        continue;
                    }
                    if ((double)operation < 0.6) {
                        this.random.among(nodes, node -> node.addLabel(label));
                        continue;
                    }
                    if ((double)operation < 0.85) {
                        this.random.among(nodes, node -> node.setProperty((String)this.random.among((Object[])keys), this.random.nextValueAsObject()));
                        continue;
                    }
                    this.random.among(nodes, node -> node.removeProperty((String)this.random.among((Object[])keys)));
                }
                tx.success();
                continue;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    private static Node findNodeByLabel(GraphDatabaseService database, Label testLabel) {
        try (ResourceIterator nodes = database.findNodes(testLabel);){
            Node node = (Node)nodes.next();
            return node;
        }
    }

    private static Node findNode(GraphDatabaseService db, Label label, String property, String value) {
        try (ResourceIterator nodes = db.findNodes(label, property, (Object)value);){
            Node node = (Node)Iterators.single((Iterator)nodes);
            return node;
        }
    }

    private static long createRelationship(GraphDatabaseService db) {
        long relationshipId;
        try (Transaction tx = db.beginTx();){
            Node start = db.createNode(new Label[]{Label.label((String)(System.currentTimeMillis() + ""))});
            Node end = db.createNode(new Label[]{Label.label((String)(System.currentTimeMillis() + ""))});
            relationshipId = start.createRelationshipTo(end, RelationshipType.withName((String)"KNOWS")).getId();
            tx.success();
        }
        return relationshipId;
    }

    private static void assertRelationshipNotExist(GraphDatabaseService db, long id) {
        try {
            db.getRelationshipById(id);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
    }

    private static DatabaseHealth healthOf(GraphDatabaseService db) {
        DependencyResolver resolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        return (DatabaseHealth)resolver.resolveDependency(DatabaseHealth.class);
    }

    private static String createLongString() {
        Object[] strings = new String[(int)ByteUnit.kibiBytes((long)2L)];
        Arrays.fill(strings, "a");
        return Arrays.toString(strings);
    }

    private File copyTransactionLogs() throws IOException {
        File restoreDbStore = this.directory.storeDir("restore-db");
        File restoreDbStoreDir = this.directory.databaseDir(restoreDbStore);
        RecoveryIT.move(this.fileSystemRule.get(), this.directory.databaseDir(), restoreDbStoreDir);
        return restoreDbStoreDir;
    }

    private static void move(FileSystemAbstraction fs, File fromDirectory, File toDirectory) throws IOException {
        File[] logFiles;
        Assert.assertTrue((boolean)fs.isDirectory(fromDirectory));
        Assert.assertTrue((boolean)fs.isDirectory(toDirectory));
        LogFiles transactionLogFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)fromDirectory, (FileSystemAbstraction)fs).build();
        for (File logFile : logFiles = transactionLogFiles.logFiles()) {
            FileOperation.MOVE.perform(fs, logFile.getName(), fromDirectory, false, toDirectory, ExistingTargetStrategy.FAIL);
        }
    }

    private static GraphDatabaseAPI startDatabase(File storeDir, EphemeralFileSystemAbstraction fs, UpdateCapturingIndexProvider indexProvider) {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fs).setKernelExtensions(Collections.singletonList(new IndexExtensionFactory(indexProvider))).newImpermanentDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.default_schema_provider, indexProvider.getProviderDescriptor().name()).newGraphDatabase();
    }

    private GraphDatabaseService startDatabase(File storeDir) {
        return new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)this.logProvider).newEmbeddedDatabase(storeDir);
    }

    private static class IndexExtensionFactory
    extends KernelExtensionFactory<Dependencies> {
        private final IndexProvider indexProvider;

        IndexExtensionFactory(IndexProvider indexProvider) {
            super("customExtension");
            this.indexProvider = indexProvider;
        }

        public Lifecycle newInstance(KernelContext context, Dependencies dependencies) {
            return this.indexProvider;
        }

        static interface Dependencies {
        }
    }

    public class UpdateCapturingIndexUpdater
    implements IndexUpdater {
        private final IndexUpdater actual;
        private final Collection<IndexEntryUpdate<?>> updatesTarget;

        UpdateCapturingIndexUpdater(IndexUpdater actual, Collection<IndexEntryUpdate<?>> updatesTarget) {
            this.actual = actual;
            this.updatesTarget = updatesTarget;
        }

        public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
            this.actual.process(update);
            this.updatesTarget.add(update);
        }

        public void close() throws IndexEntryConflictException {
            this.actual.close();
        }
    }

    public class UpdateCapturingIndexAccessor
    implements IndexAccessor {
        private final IndexAccessor actual;
        private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

        UpdateCapturingIndexAccessor(IndexAccessor actual, Collection<IndexEntryUpdate<?>> initialUpdates) {
            this.actual = actual;
            if (initialUpdates != null) {
                this.updates.addAll(initialUpdates);
            }
        }

        public void drop() {
            this.actual.drop();
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return this.wrap(this.actual.newUpdater(mode));
        }

        private IndexUpdater wrap(IndexUpdater actual) {
            return new UpdateCapturingIndexUpdater(actual, this.updates);
        }

        public void force(IOLimiter ioLimiter) {
            this.actual.force(ioLimiter);
        }

        public void refresh() {
            this.actual.refresh();
        }

        public void close() {
            this.actual.close();
        }

        public IndexReader newReader() {
            return this.actual.newReader();
        }

        public BoundedIterable<Long> newAllEntriesReader() {
            return this.actual.newAllEntriesReader();
        }

        public ResourceIterator<File> snapshotFiles() {
            return this.actual.snapshotFiles();
        }

        public void verifyDeferredConstraints(NodePropertyAccessor propertyAccessor) throws IndexEntryConflictException {
            this.actual.verifyDeferredConstraints(propertyAccessor);
        }

        public boolean isDirty() {
            return this.actual.isDirty();
        }

        public Collection<IndexEntryUpdate<?>> snapshot() {
            return new ArrayList(this.updates);
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory) {
            return this.actual.consistencyCheck(reporterFactory);
        }
    }

    public class UpdateCapturingIndexProvider
    extends IndexProvider {
        private final IndexProvider actual;
        private final Map<Long, UpdateCapturingIndexAccessor> indexes;
        private final Map<Long, Collection<IndexEntryUpdate<?>>> initialUpdates;

        UpdateCapturingIndexProvider(IndexProvider actual, Map<Long, Collection<IndexEntryUpdate<?>>> initialUpdates) {
            super(actual);
            this.indexes = new ConcurrentHashMap<Long, UpdateCapturingIndexAccessor>();
            this.actual = actual;
            this.initialUpdates = initialUpdates;
        }

        public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory) {
            return this.actual.getPopulator(descriptor, samplingConfig, bufferFactory);
        }

        public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
            IndexAccessor actualAccessor = this.actual.getOnlineAccessor(descriptor, samplingConfig);
            return this.indexes.computeIfAbsent(descriptor.getId(), id -> new UpdateCapturingIndexAccessor(actualAccessor, this.initialUpdates.get(id)));
        }

        public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
            return this.actual.getPopulationFailure(descriptor);
        }

        public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
            return this.actual.getInitialState(descriptor);
        }

        public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
            return this.actual.getCapability(descriptor);
        }

        public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
            return this.actual.storeMigrationParticipant(fs, pageCache);
        }

        public Map<Long, Collection<IndexEntryUpdate<?>>> snapshot() {
            HashMap result = new HashMap();
            this.indexes.forEach((indexId, index) -> result.put((Long)indexId, index.snapshot()));
            return result;
        }
    }
}

