/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.util.FeatureToggles;

public class BlockBasedIndexPopulationMemoryUsageIT {
    private static final long TEST_BLOCK_SIZE = ByteUnit.kibiBytes((long)64L);
    private static final String[] KEYS = new String[]{"key1", "key2", "key3", "key4"};
    private static final Label[] LABELS = new Label[]{Label.label((String)"Label1"), Label.label((String)"Label2"), Label.label((String)"Label3"), Label.label((String)"Label4")};
    @Rule
    public final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();

    @BeforeClass
    public static void setUpFeatureToggles() {
        FeatureToggles.set(GenericNativeIndexPopulator.class, (String)"blockBasedPopulation", (Object)true);
        FeatureToggles.set(BlockBasedIndexPopulator.class, (String)"blockSize", (Object)TEST_BLOCK_SIZE);
    }

    @AfterClass
    public static void restoreFeatureToggles() {
        FeatureToggles.clear(GenericNativeIndexPopulator.class, (String)"blockBasedPopulation");
        FeatureToggles.clear(BlockBasedIndexPopulator.class, (String)"blockSize");
    }

    @Test
    public void shouldKeepMemoryConsumptionLowDuringPopulation() throws InterruptedException {
        IndexPopulationMemoryUsageMonitor monitor = new IndexPopulationMemoryUsageMonitor();
        ((Monitors)this.db.getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)monitor, new String[0]);
        this.someData();
        this.createLotsOfIndexesInOneTransaction();
        monitor.called.await();
        long targetMemoryConsumption = TEST_BLOCK_SIZE * 9L * 8L;
        Assert.assertThat((Object)monitor.peakDirectMemoryUsage, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(targetMemoryConsumption + 1L)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLotsOfIndexesInOneTransaction() {
        try (Transaction tx = this.db.beginTx();){
            for (Label label : LABELS) {
                for (String key : KEYS) {
                    this.db.schema().indexFor(label).on(key).create();
                }
            }
            tx.success();
        }
        while (true) {
            try {
                tx = this.db.beginTx();
                var2_3 = null;
                try {
                    this.db.schema().awaitIndexesOnline(1L, TimeUnit.SECONDS);
                    return;
                }
                catch (Throwable throwable) {
                    var2_3 = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (var2_3 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var2_3.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (IllegalStateException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    return;
                }
            }
        }
    }

    private void someData() throws InterruptedException {
        int threads = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        for (int i = 0; i < threads; ++i) {
            executor.submit(() -> {
                for (int t = 0; t < 100; ++t) {
                    try (Transaction tx = this.db.beginTx();){
                        for (int n = 0; n < 100; ++n) {
                            Node node = this.db.createNode(LABELS);
                            for (String key : KEYS) {
                                node.setProperty(key, (Object)String.format("some value %d", n));
                            }
                        }
                        tx.success();
                        continue;
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
        }
    }

    private static class IndexPopulationMemoryUsageMonitor
    extends IndexingService.MonitorAdapter {
        private volatile long peakDirectMemoryUsage;
        private final CountDownLatch called = new CountDownLatch(1);

        private IndexPopulationMemoryUsageMonitor() {
        }

        public void populationJobCompleted(long peakDirectMemoryUsage) {
            this.peakDirectMemoryUsage = peakDirectMemoryUsage;
            this.called.countDown();
        }
    }
}

