/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.internal.Version;

public class BuiltInProceduresIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Test
    public void listAllLabels() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("MyLabel");
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).id(), new Object[0], ProcedureCallContext.EMPTY);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyLabel"})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=360000L)
    public void listAllLabelsMustNotBlockOnConstraintCreatingTransaction() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("MyLabel");
        int propKey = transaction.tokenWrite().propertyKeyCreateForName("prop");
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        this.commit();
        CountDownLatch constraintLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        FutureTask<Void> createConstraintTask = new FutureTask<Void>(() -> {
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            try (Resource ignore = this.captureTransaction();){
                schemaWrite.uniquePropertyConstraintCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propKey}));
                constraintLatch.countDown();
                commitLatch.await();
            }
            this.rollback();
            return null;
        });
        Thread constraintCreator = new Thread(createConstraintTask);
        constraintCreator.start();
        constraintLatch.await();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).id(), new Object[0], ProcedureCallContext.EMPTY);
        try {
            MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyLabel"})));
        }
        finally {
            commitLatch.countDown();
        }
        createConstraintTask.get();
        constraintCreator.join();
    }

    @Test
    public void listPropertyKeys() throws Throwable {
        TokenWrite ops = this.tokenWriteInNewTransaction();
        ops.propertyKeyGetOrCreateForName("MyProp");
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "propertyKeys"})).id(), new Object[0], ProcedureCallContext.EMPTY);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyProp"})));
    }

    @Test
    public void listRelationshipTypes() throws Throwable {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType = transaction.tokenWrite().relationshipTypeGetOrCreateForName("MyRelType");
        long startNodeId = transaction.dataWrite().nodeCreate();
        long endNodeId = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().relationshipCreate(startNodeId, relType, endNodeId);
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "relationshipTypes"})).id(), new Object[0], ProcedureCallContext.EMPTY);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"MyRelType"})));
    }

    @Test
    public void listProcedures() throws Throwable {
        ProcedureHandle procedures = this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"dbms", "procedures"}));
        RawIterator stream = this.procs().procedureCallRead(procedures.id(), new Object[0], ProcedureCallContext.EMPTY);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.proc("dbms.listConfig", "(searchString =  :: STRING?) :: (name :: STRING?, description :: STRING?, value :: STRING?, dynamic :: BOOLEAN?)", "List the currently active config of Neo4j.", "DBMS"), this.proc("db.constraints", "() :: (description :: STRING?)", "List all constraints in the database.", "READ"), this.proc("db.indexes", "() :: (description :: STRING?, indexName :: STRING?, tokenNames :: LIST? OF STRING?, properties :: LIST? OF STRING?, state :: STRING?, type :: STRING?, progress :: FLOAT?, provider :: MAP?, id :: INTEGER?, failureMessage :: STRING?)", "List all indexes in the database.", "READ"), this.proc("db.awaitIndex", "(index :: STRING?, timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for an index to come online (for example: CALL db.awaitIndex(\":Person(name)\")).", "READ"), this.proc("db.awaitIndexes", "(timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for all indexes to come online (for example: CALL db.awaitIndexes(\"500\")).", "READ"), this.proc("db.resampleIndex", "(index :: STRING?) :: VOID", "Schedule resampling of an index (for example: CALL db.resampleIndex(\":Person(name)\")).", "READ"), this.proc("db.resampleOutdatedIndexes", "() :: VOID", "Schedule resampling of all outdated indexes.", "READ"), this.proc("db.propertyKeys", "() :: (propertyKey :: STRING?)", "List all property keys in the database.", "READ"), this.proc("db.labels", "() :: (label :: STRING?)", "List all labels in the database.", "READ"), this.proc("db.schema", "() :: (nodes :: LIST? OF NODE?, relationships :: LIST? OF RELATIONSHIP?)", "Show the schema of the data.", "READ"), this.proc("db.schema.visualization", "() :: (nodes :: LIST? OF NODE?, relationships :: LIST? OF RELATIONSHIP?)", "Visualize the schema of the data. Replaces db.schema.", "READ"), this.proc("db.schema.nodeTypeProperties", "() :: (nodeType :: STRING?, nodeLabels :: LIST? OF STRING?, propertyName :: STRING?, propertyTypes :: LIST? OF STRING?, mandatory :: BOOLEAN?)", "Show the derived property schema of the nodes in tabular form.", "READ"), this.proc("db.schema.relTypeProperties", "() :: (relType :: STRING?, propertyName :: STRING?, propertyTypes :: LIST? OF STRING?, mandatory :: BOOLEAN?)", "Show the derived property schema of the relationships in tabular form.", "READ"), this.proc("db.relationshipTypes", "() :: (relationshipType :: STRING?)", "List all relationship types in the database.", "READ"), this.proc("dbms.procedures", "() :: (name :: STRING?, signature :: STRING?, description :: STRING?, mode :: STRING?)", "List all procedures in the DBMS.", "DBMS"), this.proc("dbms.functions", "() :: (name :: STRING?, signature :: STRING?, description :: STRING?)", "List all user functions in the DBMS.", "DBMS"), this.proc("dbms.components", "() :: (name :: STRING?, versions :: LIST? OF STRING?, edition :: STRING?)", "List DBMS components and their versions.", "DBMS"), this.proc("dbms.queryJmx", "(query :: STRING?) :: (name :: STRING?, description :: STRING?, attributes :: MAP?)", "Query JMX management data by domain and name. For instance, \"org.neo4j:*\"", "DBMS"), this.proc("db.createLabel", "(newLabel :: STRING?) :: VOID", "Create a label", "WRITE"), this.proc("db.createProperty", "(newProperty :: STRING?) :: VOID", "Create a Property", "WRITE"), this.proc("db.createRelationshipType", "(newRelationshipType :: STRING?) :: VOID", "Create a RelationshipType", "WRITE"), this.proc("db.index.explicit.searchNodes", "(indexName :: STRING?, query :: ANY?) :: (node :: NODE?, weight :: FLOAT?)", "Search nodes in explicit index. Replaces `START n=node:nodes('key:foo*')`", "READ"), this.proc("db.index.explicit.seekNodes", "(indexName :: STRING?, key :: STRING?, value :: ANY?) :: (node :: NODE?)", "Get node from explicit index. Replaces `START n=node:nodes(key = 'A')`", "READ"), this.proc("db.index.explicit.searchRelationships", "(indexName :: STRING?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index. Replaces `START r=relationship:relIndex('key:foo*')`", "READ"), this.proc("db.index.explicit.auto.searchNodes", "(query :: ANY?) :: (node :: NODE?, weight :: FLOAT?)", "Search nodes in explicit automatic index. Replaces `START n=node:node_auto_index('key:foo*')`", "READ"), this.proc("db.index.explicit.auto.seekNodes", "(key :: STRING?, value :: ANY?) :: (node :: NODE?)", "Get node from explicit automatic index. Replaces `START n=node:node_auto_index(key = 'A')`", "READ"), this.proc("db.index.explicit.auto.searchRelationships", "(query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit automatic index. Replaces `START r=relationship:relationship_auto_index('key:foo*')`", "READ"), this.proc("db.index.explicit.auto.seekRelationships", "(key :: STRING?, value :: ANY?) :: (relationship :: RELATIONSHIP?)", "Get relationship from explicit automatic index. Replaces `START r=relationship:relationship_auto_index(key = 'A')`", "READ"), this.proc("db.index.explicit.addNode", "(indexName :: STRING?, node :: NODE?, key :: STRING?, value :: ANY?) :: (success :: BOOLEAN?)", "Add a node to an explicit index based on a specified key and value", "WRITE"), this.proc("db.index.explicit.addRelationship", "(indexName :: STRING?, relationship :: RELATIONSHIP?, key :: STRING?, value :: ANY?) :: (success :: BOOLEAN?)", "Add a relationship to an explicit index based on a specified key and value", "WRITE"), this.proc("db.index.explicit.removeNode", "(indexName :: STRING?, node :: NODE?, key =  <[9895b15e-8693-4a21-a58b-4b7b87e09b8e]>  :: STRING?) :: (success :: BOOLEAN?)", "Remove a node from an explicit index with an optional key", "WRITE"), this.proc("db.index.explicit.removeRelationship", "(indexName :: STRING?, relationship :: RELATIONSHIP?, key =  <[9895b15e-8693-4a21-a58b-4b7b87e09b8e]>  :: STRING?) :: (success :: BOOLEAN?)", "Remove a relationship from an explicit index with an optional key", "WRITE"), this.proc("db.index.explicit.drop", "(indexName :: STRING?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Remove an explicit index - YIELD type,name,config", "WRITE"), this.proc("db.index.explicit.forNodes", "(indexName :: STRING?, config = {} :: MAP?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Get or create a node explicit index - YIELD type,name,config", "WRITE"), this.proc("db.index.explicit.forRelationships", "(indexName :: STRING?, config = {} :: MAP?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Get or create a relationship explicit index - YIELD type,name,config", "WRITE"), this.proc("db.index.explicit.existsForNodes", "(indexName :: STRING?) :: (success :: BOOLEAN?)", "Check if a node explicit index exists", "READ"), this.proc("db.index.explicit.existsForRelationships", "(indexName :: STRING?) :: (success :: BOOLEAN?)", "Check if a relationship explicit index exists", "READ"), this.proc("db.index.explicit.list", "() :: (type :: STRING?, name :: STRING?, config :: MAP?)", "List all explicit indexes - YIELD type,name,config", "READ"), this.proc("db.index.explicit.seekRelationships", "(indexName :: STRING?, key :: STRING?, value :: ANY?) :: (relationship :: RELATIONSHIP?)", "Get relationship from explicit index. Replaces `START r=relationship:relIndex(key = 'A')`", "READ"), this.proc("db.index.explicit.searchRelationshipsBetween", "(indexName :: STRING?, in :: NODE?, out :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, starting at the node 'in' and ending at 'out'.", "READ"), this.proc("db.index.explicit.searchRelationshipsIn", "(indexName :: STRING?, in :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, starting at the node 'in'.", "READ"), this.proc("db.index.explicit.searchRelationshipsOut", "(indexName :: STRING?, out :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, ending at the node 'out'.", "READ"), this.proc("dbms.clearQueryCaches", "() :: (value :: STRING?)", "Clears all query caches.", "DBMS"), this.proc("db.createIndex", "(index :: STRING?, providerName :: STRING?) :: (index :: STRING?, providerName :: STRING?, status :: STRING?)", "Create a schema index with specified index provider (for example: CALL db.createIndex(\":Person(name)\", \"lucene+native-2.0\")) - YIELD index, providerName, status", "SCHEMA"), this.proc("db.createUniquePropertyConstraint", "(index :: STRING?, providerName :: STRING?) :: (index :: STRING?, providerName :: STRING?, status :: STRING?)", "Create a unique property constraint with index backed by specified index provider (for example: CALL db.createUniquePropertyConstraint(\":Person(name)\", \"lucene+native-2.0\")) - YIELD index, providerName, status", "SCHEMA"), this.proc("db.index.fulltext.awaitEventuallyConsistentIndexRefresh", "() :: VOID", "Wait for the updates from recently committed transactions to be applied to any eventually-consistent fulltext indexes.", "READ"), this.proc("db.index.fulltext.awaitIndex", "(index :: STRING?, timeOutSeconds = 300 :: INTEGER?) :: VOID", "Similar to db.awaitIndex(index, timeout), except instead of an index pattern, the index is specified by name. The name can be quoted by backticks, if necessary.", "READ"), this.proc("db.index.fulltext.createNodeIndex", "(indexName :: STRING?, labels :: LIST? OF STRING?, propertyNames :: LIST? OF STRING?, config = {} :: MAP?) :: VOID", (Matcher<String>)Matchers.startsWith((String)"Create a node fulltext index for the given labels and properties."), "SCHEMA"), this.proc("db.index.fulltext.createRelationshipIndex", "(indexName :: STRING?, relationshipTypes :: LIST? OF STRING?, propertyNames :: LIST? OF STRING?, config = {} :: MAP?) :: VOID", (Matcher<String>)Matchers.startsWith((String)"Create a relationship fulltext index for the given relationship types and properties."), "SCHEMA"), this.proc("db.index.fulltext.drop", "(indexName :: STRING?) :: VOID", "Drop the specified index.", "SCHEMA"), this.proc("db.index.fulltext.listAvailableAnalyzers", "() :: (analyzer :: STRING?, description :: STRING?)", "List the available analyzers that the fulltext indexes can be configured with.", "READ"), this.proc("db.index.fulltext.queryNodes", "(indexName :: STRING?, queryString :: STRING?) :: (node :: NODE?, score :: FLOAT?)", "Query the given fulltext index. Returns the matching nodes and their lucene query score, ordered by score.", "READ"), this.proc("db.index.fulltext.queryRelationships", "(indexName :: STRING?, queryString :: STRING?) :: (relationship :: RELATIONSHIP?, score :: FLOAT?)", "Query the given fulltext index. Returns the matching relationships and their lucene query score, ordered by score.", "READ"), this.proc("db.stats.retrieve", "(section :: STRING?, config = {} :: MAP?) :: (section :: STRING?, data :: MAP?)", "Retrieve statistical data about the current database. Valid sections are 'GRAPH COUNTS', 'TOKENS', 'QUERIES', 'META'", "READ"), this.proc("db.stats.retrieveAllAnonymized", "(graphToken :: STRING?, config = {} :: MAP?) :: (section :: STRING?, data :: MAP?)", "Retrieve all available statistical data about the current database, in an anonymized form.", "READ"), this.proc("db.stats.status", "() :: (section :: STRING?, status :: STRING?, data :: MAP?)", "Retrieve the status of all available collector daemons, for this database.", "READ"), this.proc("db.stats.collect", "(section :: STRING?, config = {} :: MAP?) :: (section :: STRING?, success :: BOOLEAN?, message :: STRING?)", "Start data collection of a given data section. Valid sections are 'QUERIES'", "READ"), this.proc("db.stats.stop", "(section :: STRING?) :: (section :: STRING?, success :: BOOLEAN?, message :: STRING?)", "Stop data collection of a given data section. Valid sections are 'QUERIES'", "READ"), this.proc("db.stats.clear", "(section :: STRING?) :: (section :: STRING?, success :: BOOLEAN?, message :: STRING?)", "Clear collected data of a given data section. Valid sections are 'QUERIES'", "READ")}));
        this.commit();
    }

    private Matcher<Object[]> proc(String procName, String procSignature, String description, String mode) {
        return IsEqual.equalTo((Object)new Object[]{procName, procName + procSignature, description, mode});
    }

    private Matcher<Object[]> proc(String procName, String procSignature, Matcher<String> description, String mode) {
        Matcher<String> desc = description;
        Matcher[] matchers = new Matcher[]{IsEqual.equalTo((Object)procName), IsEqual.equalTo((Object)(procName + procSignature)), desc, IsEqual.equalTo((Object)mode)};
        return Matchers.arrayContaining((Matcher[])matchers);
    }

    @Test
    public void failWhenCallingNonExistingProcedures() {
        try {
            this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "iDoNotExist"}), new Object[0], this.dependencyResolver, AnonymousContext.none().authorize(s -> -1, "graph.db"), this.resourceTracker, ProcedureCallContext.EMPTY);
            Assert.fail((String)"This should never get here");
        }
        catch (Exception e) {
            MatcherAssert.assertThat(e.getClass(), (Matcher)IsEqual.equalTo(ProcedureException.class));
        }
    }

    @Test
    public void listAllComponents() throws Throwable {
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"dbms", "components"})).id(), new Object[0], ProcedureCallContext.EMPTY);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{"Neo4j Kernel", Collections.singletonList(Version.getNeo4jVersion()), "community"})));
        this.commit();
    }

    @Test
    public void listAllIndexes() throws Throwable {
        Transaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int labelId2 = transaction.tokenWrite().labelGetOrCreateForName("Age");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        int propertyKeyId2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("bar");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor ageFooDescriptor = SchemaDescriptorFactory.forLabel((int)labelId2, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor personFooBarDescriptor = SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1, propertyKeyId2});
        transaction.schemaWrite().indexCreate((SchemaDescriptor)personFooDescriptor);
        transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)ageFooDescriptor);
        transaction.schemaWrite().indexCreate((SchemaDescriptor)personFooBarDescriptor);
        this.commit();
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.success();
        }
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"})).id(), new Object[0], ProcedureCallContext.EMPTY);
        HashSet<Object> result = new HashSet<Object>();
        while (stream.hasNext()) {
            result.add(stream.next());
        }
        IndexProviderMap indexProviderMap = (IndexProviderMap)this.db.getDependencyResolver().resolveDependency(IndexProviderMap.class);
        IndexingService indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        IndexProvider provider = indexProviderMap.getDefaultProvider();
        Map pdm = MapUtil.stringMap((String[])new String[]{"key", provider.getProviderDescriptor().getKey(), "version", provider.getProviderDescriptor().getVersion()});
        MatcherAssert.assertThat(result, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[][]{{"INDEX ON :Age(foo)", "index_1", Collections.singletonList("Age"), Collections.singletonList("foo"), "ONLINE", "node_unique_property", 100.0, pdm, indexingService.getIndexId((SchemaDescriptor)ageFooDescriptor), ""}, {"INDEX ON :Person(foo)", "Unnamed index", Collections.singletonList("Person"), Collections.singletonList("foo"), "ONLINE", "node_label_property", 100.0, pdm, indexingService.getIndexId((SchemaDescriptor)personFooDescriptor), ""}, {"INDEX ON :Person(foo, bar)", "Unnamed index", Collections.singletonList("Person"), Arrays.asList("foo", "bar"), "ONLINE", "node_label_property", 100.0, pdm, indexingService.getIndexId((SchemaDescriptor)personFooBarDescriptor), ""}}));
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=360000L)
    public void listAllIndexesMustNotBlockOnConstraintCreatingTransaction() throws Throwable {
        Transaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int labelId2 = transaction.tokenWrite().labelGetOrCreateForName("Age");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        int propertyKeyId2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("bar");
        int propertyKeyId3 = transaction.tokenWrite().propertyKeyGetOrCreateForName("baz");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor ageFooDescriptor = SchemaDescriptorFactory.forLabel((int)labelId2, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor personFooBarDescriptor = SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1, propertyKeyId2});
        LabelSchemaDescriptor personBazDescriptor = SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId3});
        transaction.schemaWrite().indexCreate((SchemaDescriptor)personFooDescriptor);
        transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)ageFooDescriptor);
        transaction.schemaWrite().indexCreate((SchemaDescriptor)personFooBarDescriptor);
        this.commit();
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.success();
        }
        CountDownLatch constraintLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        FutureTask<Void> createConstraintTask = new FutureTask<Void>(() -> {
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            try (Resource ignore = this.captureTransaction();){
                schemaWrite.uniquePropertyConstraintCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId1, (int[])new int[]{propertyKeyId3}));
                constraintLatch.countDown();
                commitLatch.await();
            }
            this.rollback();
            return null;
        });
        Thread constraintCreator = new Thread(createConstraintTask);
        constraintCreator.start();
        constraintLatch.await();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"})).id(), new Object[0], ProcedureCallContext.EMPTY);
        HashSet<Object> result = new HashSet<Object>();
        while (stream.hasNext()) {
            result.add(stream.next());
        }
        try {
            IndexProviderMap indexProviderMap = (IndexProviderMap)this.db.getDependencyResolver().resolveDependency(IndexProviderMap.class);
            IndexingService indexing = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
            IndexProvider provider = indexProviderMap.getDefaultProvider();
            Map pdm = MapUtil.stringMap((String[])new String[]{"key", provider.getProviderDescriptor().getKey(), "version", provider.getProviderDescriptor().getVersion()});
            MatcherAssert.assertThat(result, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[][]{{"INDEX ON :Age(foo)", "index_1", Collections.singletonList("Age"), Collections.singletonList("foo"), "ONLINE", "node_unique_property", 100.0, pdm, indexing.getIndexId((SchemaDescriptor)ageFooDescriptor), ""}, {"INDEX ON :Person(foo)", "Unnamed index", Collections.singletonList("Person"), Collections.singletonList("foo"), "ONLINE", "node_label_property", 100.0, pdm, indexing.getIndexId((SchemaDescriptor)personFooDescriptor), ""}, {"INDEX ON :Person(foo, bar)", "Unnamed index", Collections.singletonList("Person"), Arrays.asList("foo", "bar"), "ONLINE", "node_label_property", 100.0, pdm, indexing.getIndexId((SchemaDescriptor)personFooBarDescriptor), ""}, {"INDEX ON :Person(baz)", "Unnamed index", Collections.singletonList("Person"), Collections.singletonList("baz"), "POPULATING", "node_unique_property", 100.0, pdm, indexing.getIndexId((SchemaDescriptor)personBazDescriptor), ""}}));
            this.commit();
        }
        finally {
            commitLatch.countDown();
        }
        createConstraintTask.get();
        constraintCreator.join();
    }
}

