/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class CompositeUniquenessConstraintValidationIT {
    @ClassRule
    public static ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    @Rule
    public final TestName testName = new TestName();
    private final int numberOfProps;
    private final Object[] aValues;
    private final Object[] bValues;
    private static final int label = 1;
    private Transaction transaction;
    private GraphDatabaseAPI graphDatabaseAPI;
    protected Kernel kernel;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<TestParams> parameterValues() {
        return Arrays.asList(CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(10), CompositeUniquenessConstraintValidationIT.values(10.0)), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(10, 20), CompositeUniquenessConstraintValidationIT.values(10, 20)), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(10L, 20L), CompositeUniquenessConstraintValidationIT.values(10, 20)), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(10, 20), CompositeUniquenessConstraintValidationIT.values(10L, 20L)), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(10, 20), CompositeUniquenessConstraintValidationIT.values(10.0, 20.0)), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(10, 20), CompositeUniquenessConstraintValidationIT.values(10.0, 20.0)), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(new int[]{1, 2}, "v2"), CompositeUniquenessConstraintValidationIT.values(new int[]{1, 2}, "v2")), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values("a", "b", "c"), CompositeUniquenessConstraintValidationIT.values("a", "b", "c")), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(285414114323346805L), CompositeUniquenessConstraintValidationIT.values(285414114323346805L)), CompositeUniquenessConstraintValidationIT.param(CompositeUniquenessConstraintValidationIT.values(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), CompositeUniquenessConstraintValidationIT.values(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0)));
    }

    private static TestParams param(Object[] l, Object[] r) {
        return new TestParams(l, r);
    }

    private static Object[] values(Object ... values) {
        return values;
    }

    public CompositeUniquenessConstraintValidationIT(TestParams params) {
        assert (params.lhs.length == params.rhs.length);
        this.aValues = params.lhs;
        this.bValues = params.rhs;
        this.numberOfProps = this.aValues.length;
    }

    @Before
    public void setup() throws Exception {
        this.graphDatabaseAPI = dbRule.getGraphDatabaseAPI();
        this.kernel = (Kernel)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(Kernel.class);
        this.newTransaction();
        this.transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])this.propertyIds()));
        this.commit();
    }

    @After
    public void clean() throws Exception {
        if (this.transaction != null) {
            this.transaction.close();
        }
        this.newTransaction();
        this.transaction.schemaWrite().constraintDrop((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])this.propertyIds()));
        this.commit();
        try (Transaction tx = this.kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
             NodeCursor node = tx.cursors().allocateNodeCursor();){
            tx.dataRead().allNodesScan(node);
            while (node.next()) {
                tx.dataWrite().nodeDelete(node.nodeReference());
            }
            tx.success();
        }
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteNode() throws Exception {
        long node = this.createNodeWithLabelAndProps(1, this.aValues);
        this.newTransaction();
        this.transaction.dataWrite().nodeDelete(node);
        long newNode = this.createLabeledNode(1);
        this.setProperties(newNode, this.aValues);
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel() throws Exception {
        long node = this.createNodeWithLabelAndProps(1, this.aValues);
        this.newTransaction();
        this.transaction.dataWrite().nodeRemoveLabel(node, 1);
        long newNode = this.createLabeledNode(1);
        this.setProperties(newNode, this.aValues);
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty() throws Exception {
        long node = this.createNodeWithLabelAndProps(1, this.aValues);
        this.newTransaction();
        this.transaction.dataWrite().nodeRemoveProperty(node, 0);
        long newNode = this.createLabeledNode(1);
        this.setProperties(newNode, this.aValues);
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty() throws Exception {
        long node = this.createNodeWithLabelAndProps(1, this.aValues);
        this.newTransaction();
        this.transaction.dataWrite().nodeSetProperty(node, 0, Values.of((Object)"Alive!"));
        long newNode = this.createLabeledNode(1);
        this.setProperties(newNode, this.aValues);
        this.commit();
    }

    @Test
    public void shouldPreventConflictingDataInTx() throws Throwable {
        this.newTransaction();
        long n1 = this.createLabeledNode(1);
        long n2 = this.createLabeledNode(1);
        this.setProperties(n1, this.aValues);
        int lastPropertyOffset = this.numberOfProps - 1;
        for (int prop = 0; prop < lastPropertyOffset; ++prop) {
            this.setProperty(n2, prop, this.aValues[prop]);
        }
        org.neo4j.test.assertion.Assert.assertException(() -> this.setProperty(n2, lastPropertyOffset, this.aValues[lastPropertyOffset]), UniquePropertyValueValidationException.class);
        this.commit();
    }

    @Test
    public void shouldEnforceOnSetProperty() throws Exception {
        this.createNodeWithLabelAndProps(1, this.aValues);
        this.newTransaction();
        long node = this.createLabeledNode(1);
        int lastPropertyOffset = this.numberOfProps - 1;
        for (int prop = 0; prop < lastPropertyOffset; ++prop) {
            this.setProperty(node, prop, this.aValues[prop]);
        }
        org.neo4j.test.assertion.Assert.assertException(() -> this.setProperty(node, lastPropertyOffset, this.aValues[lastPropertyOffset]), UniquePropertyValueValidationException.class);
        this.commit();
    }

    @Test
    public void shouldEnforceOnSetLabel() throws Exception {
        this.createNodeWithLabelAndProps(1, this.aValues);
        this.newTransaction();
        long node = this.createNode();
        this.setProperties(node, this.bValues);
        org.neo4j.test.assertion.Assert.assertException(() -> this.addLabel(node, 1), UniquePropertyValueValidationException.class);
        this.commit();
    }

    @Test
    public void shouldEnforceOnSetPropertyInTx() throws Exception {
        this.newTransaction();
        long aNode = this.createLabeledNode(1);
        this.setProperties(aNode, this.aValues);
        long nodeB = this.createLabeledNode(1);
        int lastPropertyOffset = this.numberOfProps - 1;
        for (int prop = 0; prop < lastPropertyOffset; ++prop) {
            this.setProperty(nodeB, prop, this.bValues[prop]);
        }
        org.neo4j.test.assertion.Assert.assertException(() -> this.setProperty(nodeB, lastPropertyOffset, this.bValues[lastPropertyOffset]), UniquePropertyValueValidationException.class);
        this.commit();
    }

    @Test
    public void shouldEnforceOnSetLabelInTx() throws Exception {
        this.createNodeWithLabelAndProps(1, this.aValues);
        this.newTransaction();
        long nodeB = this.createNode();
        this.setProperties(nodeB, this.bValues);
        org.neo4j.test.assertion.Assert.assertException(() -> this.addLabel(nodeB, 1), UniquePropertyValueValidationException.class);
        this.commit();
    }

    private void newTransaction() throws KernelException {
        if (this.transaction != null) {
            Assert.fail((String)"tx already opened");
        }
        this.transaction = this.kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
    }

    protected void commit() throws TransactionFailureException {
        this.transaction.success();
        try {
            this.transaction.close();
        }
        finally {
            this.transaction = null;
        }
    }

    private long createLabeledNode(int labelId) throws KernelException {
        long node = this.transaction.dataWrite().nodeCreate();
        this.transaction.dataWrite().nodeAddLabel(node, labelId);
        return node;
    }

    private void addLabel(long nodeId, int labelId) throws KernelException {
        this.transaction.dataWrite().nodeAddLabel(nodeId, labelId);
    }

    private void setProperty(long nodeId, int propertyId, Object value) throws KernelException {
        this.transaction.dataWrite().nodeSetProperty(nodeId, propertyId, Values.of((Object)value));
    }

    private long createNode() throws KernelException {
        return this.transaction.dataWrite().nodeCreate();
    }

    private long createNodeWithLabelAndProps(int labelId, Object[] propertyValues) throws KernelException {
        this.newTransaction();
        long nodeId = this.createNode();
        this.addLabel(nodeId, labelId);
        for (int prop = 0; prop < this.numberOfProps; ++prop) {
            this.setProperty(nodeId, prop, propertyValues[prop]);
        }
        this.commit();
        return nodeId;
    }

    private void setProperties(long nodeId, Object[] propertyValues) throws KernelException {
        for (int prop = 0; prop < propertyValues.length; ++prop) {
            this.setProperty(nodeId, prop, propertyValues[prop]);
        }
    }

    private int[] propertyIds() {
        int[] props = new int[this.numberOfProps];
        for (int i = 0; i < this.numberOfProps; ++i) {
            props[i] = i;
        }
        return props;
    }

    static class TestParams {
        private final Object[] lhs;
        private final Object[] rhs;

        TestParams(Object[] lhs, Object[] rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public String toString() {
            return String.format("lhs=%s, rhs=%s", ArrayUtils.toString((Object)this.lhs), ArrayUtils.toString((Object)this.rhs));
        }
    }
}

