/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.storable.Values;

public class UniquenessConstraintValidationIT
extends KernelIntegrationTest {
    @Test
    public void shouldEnforceOnSetProperty() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = this.createLabeledNode(transaction, "Label1");
        try {
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
            transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)"value1"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(transaction)), (Matcher)CoreMatchers.containsString((String)"`key1` = 'value1'"));
        }
        this.commit();
    }

    @Test
    public void roundingErrorsFromLongToDoubleShouldNotPreventTxFromCommitting() throws Exception {
        long propertyValue = 285414114323346805L;
        long firstNode = this.constrainedNode("label1", "key1", propertyValue);
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = this.createLabeledNode(transaction, "label1");
        Assert.assertNotEquals((long)firstNode, (long)node);
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)(++propertyValue)));
        this.commit();
    }

    @Test
    public void shouldEnforceUniquenessConstraintOnAddLabelForNumberPropertyOnNodeNotFromTransaction() throws Exception {
        this.constrainedNode("Label1", "key1", 1);
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = this.createNode(transaction, "key1", 1);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        try {
            int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
            transaction.dataWrite().nodeAddLabel(node, label);
            Assert.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(transaction)), (Matcher)CoreMatchers.containsString((String)"`key1` = 1"));
        }
        this.commit();
    }

    @Test
    public void shouldEnforceUniquenessConstraintOnAddLabelForStringProperty() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = this.createNode(transaction, "key1", "value1");
        try {
            int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
            transaction.dataWrite().nodeAddLabel(node, label);
            Assert.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(transaction)), (Matcher)CoreMatchers.containsString((String)"`key1` = 'value1'"));
        }
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteNode() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        transaction.dataWrite().nodeDelete(node);
        this.createLabeledNode(transaction, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
        transaction.dataWrite().nodeRemoveLabel(node, label);
        this.createLabeledNode(transaction, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int key = transaction.tokenRead().propertyKey("key1");
        transaction.dataWrite().nodeRemoveProperty(node, key);
        this.createLabeledNode(transaction, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)"value2"));
        this.createLabeledNode(transaction, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldPreventConflictingDataInSameTransaction() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        this.createLabeledNode(transaction, "Label1", "key1", "value2");
        try {
            this.createLabeledNode(transaction, "Label1", "key1", "value2");
            Assert.fail((String)"expected exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(transaction)), (Matcher)CoreMatchers.containsString((String)"`key1` = 'value2'"));
        }
        this.commit();
    }

    @Test
    public void shouldAllowNoopPropertyUpdate() throws KernelException {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int key = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
        transaction.dataWrite().nodeSetProperty(node, key, Values.of((Object)"value1"));
        this.commit();
    }

    @Test
    public void shouldAllowNoopLabelUpdate() throws KernelException {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
        transaction.dataWrite().nodeAddLabel(node, label);
        this.commit();
    }

    @Test
    public void shouldAllowCreationOfNonConflictingData() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        this.createNode(transaction, "key1", "value1");
        this.createLabeledNode(transaction, "Label2", "key1", "value1");
        this.createLabeledNode(transaction, "Label1", "key1", "value2");
        this.createLabeledNode(transaction, "Label1", "key2", "value1");
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        Assert.assertEquals((String)"number of nodes", (long)5L, (long)this.countNodes(transaction));
        this.rollback();
    }

    @Test
    public void unrelatedNodesWithSamePropertyShouldNotInterfereWithUniquenessCheck() throws Exception {
        this.createConstraint("Person", "id");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long ourNode = this.createLabeledNode(transaction, "Person", "id", 1);
        this.createLabeledNode(transaction, "Item", "id", 2);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        TokenRead tokenRead = transaction.tokenRead();
        int person = tokenRead.nodeLabel("Person");
        int propId = tokenRead.propertyKey("id");
        IndexReference idx = transaction.schemaRead().index(person, new int[]{propId});
        this.createLabeledNode(transaction, "Item", "id", 2);
        Assert.assertThat((Object)transaction.dataRead().lockingNodeUniqueIndexSeek(idx, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propId, (Object)Values.of((Object)1))}), (Matcher)Matchers.equalTo((Object)ourNode));
        this.commit();
    }

    @Test
    public void addingUniqueNodeWithUnrelatedValueShouldNotAffectLookup() throws Exception {
        this.createConstraint("Person", "id");
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long ourNode = this.createLabeledNode(transaction, "Person", "id", 1);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        TokenRead tokenRead = transaction.tokenRead();
        int person = tokenRead.nodeLabel("Person");
        int propId = tokenRead.propertyKey("id");
        IndexReference idx = transaction.schemaRead().index(person, new int[]{propId});
        this.createLabeledNode(transaction, "Person", "id", 2);
        Assert.assertThat((Object)transaction.dataRead().lockingNodeUniqueIndexSeek(idx, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propId, (Object)Values.of((Object)1))}), (Matcher)Matchers.equalTo((Object)ourNode));
        this.commit();
    }

    private TokenNameLookup tokenLookup(Transaction transaction) {
        return new SilentTokenNameLookup(transaction.tokenRead());
    }

    private long createLabeledNode(Transaction transaction, String label) throws KernelException {
        long node = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName(label);
        transaction.dataWrite().nodeAddLabel(node, labelId);
        return node;
    }

    private long createNode(Transaction transaction, String key, Object value) throws KernelException {
        long node = transaction.dataWrite().nodeCreate();
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)value));
        return node;
    }

    private long createLabeledNode(Transaction transaction, String label, String key, Object value) throws KernelException {
        long node = this.createLabeledNode(transaction, label);
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)value));
        return node;
    }

    private long constrainedNode(String labelName, String propertyKey, Object propertyValue) throws KernelException {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName(labelName);
        long node = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().nodeAddLabel(node, label);
        int key = transaction.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
        transaction.dataWrite().nodeSetProperty(node, key, Values.of((Object)propertyValue));
        this.commit();
        this.createConstraint(labelName, propertyKey);
        return node;
    }

    private void createConstraint(String label, String propertyKey) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName(label);
        int propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName(propertyKey);
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        schemaWrite.uniquePropertyConstraintCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}));
        this.commit();
    }
}

