/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.time.ZoneId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.Value;

public class TestCombinedPropertyTypes
extends AbstractNeo4jTestCase {
    private Node node1;

    @Before
    public void createInitialNode() {
        this.node1 = this.getGraphDb().createNode();
    }

    @After
    public void deleteInitialNode() {
        this.node1.delete();
    }

    @Override
    protected boolean restartGraphDbBetweenTests() {
        return true;
    }

    @Test
    public void testDateTypeOrdinalDayWithPrecedingInLinedLong() {
        this.testDateTypeWithPrecedingInLinedLong((Value)DateValue.ordinalDate((int)4800, (int)1));
    }

    @Test
    public void testDateTypeOrdinalDayWithPrecedingNotInLinedLong() {
        this.testDateTypeWithPrecedingNotInLinedLong((Value)DateValue.ordinalDate((int)4800, (int)1));
    }

    @Test
    public void testLocalTimeWithPrecedingInLinedLong() {
        this.testDateTypeWithPrecedingInLinedLong((Value)LocalTimeValue.parse((CharSequence)"13:45:02"));
    }

    @Test
    public void testLocalTimeWithPrecedingNotInLinedLong() {
        this.testDateTypeWithPrecedingNotInLinedLong((Value)LocalTimeValue.parse((CharSequence)"13:45:02"));
    }

    @Test
    public void testDateTimeWithPrecedingInLinedLong() {
        this.testDateTypeWithPrecedingInLinedLong((Value)DateTimeValue.datetime((DateValue)DateValue.parse((CharSequence)"2018-04-01"), (LocalTimeValue)LocalTimeValue.parse((CharSequence)"01:02:03"), (ZoneId)ZoneId.of("Europe/Stockholm")));
    }

    @Test
    public void testDateTimeWithPrecedingNotInLinedLong() {
        this.testDateTypeWithPrecedingNotInLinedLong((Value)DateTimeValue.datetime((DateValue)DateValue.parse((CharSequence)"2018-04-01"), (LocalTimeValue)LocalTimeValue.parse((CharSequence)"01:02:03"), (ZoneId)ZoneId.of("Europe/Stockholm")));
    }

    private void testDateTypeWithPrecedingInLinedLong(Value value) {
        this.node1.setProperty("l1", (Object)255);
        String key = "dt";
        this.node1.setProperty(key, (Object)value);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)value.asObjectCopy(), (Object)property);
    }

    private void testDateTypeWithPrecedingNotInLinedLong(Value value) {
        this.node1.setProperty("l1", (Object)Long.MAX_VALUE);
        String key = "dt";
        this.node1.setProperty(key, (Object)value);
        this.newTransaction();
        Object property = this.node1.getProperty(key);
        Assert.assertEquals((Object)value.asObjectCopy(), (Object)property);
    }
}

