/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class TestExceptionTypeOnInvalidIds {
    private static final long SMALL_POSITIVE_INTEGER = 5L;
    private static final long SMALL_NEGATIVE_INTEGER = -5L;
    private static final long BIG_POSITIVE_INTEGER = Integer.MAX_VALUE;
    private static final long BIG_NEGATIVE_INTEGER = Integer.MIN_VALUE;
    private static final long SMALL_POSITIVE_LONG = 0x80000000L;
    private static final long SMALL_NEGATIVE_LONG = Integer.MAX_VALUE;
    private static final long BIG_POSITIVE_LONG = Long.MAX_VALUE;
    private static final long BIG_NEGATIVE_LONG = Long.MIN_VALUE;
    private static GraphDatabaseService graphdb;
    private static GraphDatabaseService graphDbReadOnly;
    private Transaction tx;
    @ClassRule
    public static final TestDirectory testDirectory;

    @BeforeClass
    public static void createDatabase() {
        graphdb = new TestGraphDatabaseFactory().newEmbeddedDatabase(testDirectory.storeDir());
        File databaseDirectory = testDirectory.databaseLayout("read_only").databaseDirectory();
        new TestGraphDatabaseFactory().newEmbeddedDatabase(databaseDirectory).shutdown();
        graphDbReadOnly = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(databaseDirectory).setConfig(GraphDatabaseSettings.read_only, "true").newGraphDatabase();
    }

    @AfterClass
    public static void destroyDatabase() {
        graphDbReadOnly.shutdown();
        graphDbReadOnly = null;
        graphdb.shutdown();
        graphdb = null;
    }

    @Before
    public void startTransaction() {
        this.tx = graphdb.beginTx();
    }

    @After
    public void endTransaction() {
        this.tx.close();
        this.tx = null;
    }

    @Test(expected=NotFoundException.class)
    public void getNodeBySmallPositiveInteger() {
        TestExceptionTypeOnInvalidIds.getNodeById(5L);
        TestExceptionTypeOnInvalidIds.getNodeByIdReadOnly(5L);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeBySmallNegativeInteger() {
        TestExceptionTypeOnInvalidIds.getNodeById(-5L);
        TestExceptionTypeOnInvalidIds.getNodeByIdReadOnly(-5L);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeByBigPositiveInteger() {
        TestExceptionTypeOnInvalidIds.getNodeById(Integer.MAX_VALUE);
        TestExceptionTypeOnInvalidIds.getNodeByIdReadOnly(Integer.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeByBigNegativeInteger() {
        TestExceptionTypeOnInvalidIds.getNodeById(Integer.MIN_VALUE);
        TestExceptionTypeOnInvalidIds.getNodeByIdReadOnly(Integer.MIN_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeBySmallPositiveLong() {
        TestExceptionTypeOnInvalidIds.getNodeById(0x80000000L);
        TestExceptionTypeOnInvalidIds.getNodeByIdReadOnly(0x80000000L);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeBySmallNegativeLong() {
        TestExceptionTypeOnInvalidIds.getNodeById(Integer.MAX_VALUE);
        TestExceptionTypeOnInvalidIds.getNodeByIdReadOnly(Integer.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeByBigPositiveLong() {
        TestExceptionTypeOnInvalidIds.getNodeById(Long.MAX_VALUE);
        TestExceptionTypeOnInvalidIds.getNodeByIdReadOnly(Long.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getNodeByBigNegativeLong() {
        TestExceptionTypeOnInvalidIds.getNodeById(Long.MIN_VALUE);
        TestExceptionTypeOnInvalidIds.getNodeByIdReadOnly(Long.MIN_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipBySmallPositiveInteger() {
        TestExceptionTypeOnInvalidIds.getRelationshipById(5L);
        TestExceptionTypeOnInvalidIds.getRelationshipByIdReadOnly(5L);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipBySmallNegativeInteger() {
        TestExceptionTypeOnInvalidIds.getRelationshipById(-5L);
        TestExceptionTypeOnInvalidIds.getRelationshipByIdReadOnly(5L);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipByBigPositiveInteger() {
        TestExceptionTypeOnInvalidIds.getRelationshipById(Integer.MAX_VALUE);
        TestExceptionTypeOnInvalidIds.getRelationshipByIdReadOnly(Integer.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipByBigNegativeInteger() {
        TestExceptionTypeOnInvalidIds.getRelationshipById(Integer.MIN_VALUE);
        TestExceptionTypeOnInvalidIds.getRelationshipByIdReadOnly(Integer.MIN_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipBySmallPositiveLong() {
        TestExceptionTypeOnInvalidIds.getRelationshipById(0x80000000L);
        TestExceptionTypeOnInvalidIds.getRelationshipByIdReadOnly(0x80000000L);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipBySmallNegativeLong() {
        TestExceptionTypeOnInvalidIds.getRelationshipById(Integer.MAX_VALUE);
        TestExceptionTypeOnInvalidIds.getRelationshipByIdReadOnly(Integer.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipByBigPositiveLong() {
        TestExceptionTypeOnInvalidIds.getRelationshipById(Long.MAX_VALUE);
        TestExceptionTypeOnInvalidIds.getRelationshipByIdReadOnly(Long.MAX_VALUE);
    }

    @Test(expected=NotFoundException.class)
    public void getRelationshipByBigNegativeLong() {
        TestExceptionTypeOnInvalidIds.getRelationshipById(Long.MIN_VALUE);
        TestExceptionTypeOnInvalidIds.getRelationshipByIdReadOnly(Long.MIN_VALUE);
    }

    private static void getNodeById(long index) {
        Node value = graphdb.getNodeById(index);
        Assert.fail((String)String.format("Returned Node [0x%x] for index 0x%x (int value: 0x%x)", value.getId(), index, (int)index));
    }

    private static void getNodeByIdReadOnly(long index) {
        Node value = graphDbReadOnly.getNodeById(index);
        Assert.fail((String)String.format("Returned Node [0x%x] for index 0x%x (int value: 0x%x)", value.getId(), index, (int)index));
    }

    private static void getRelationshipById(long index) {
        Relationship value = graphdb.getRelationshipById(index);
        Assert.fail((String)String.format("Returned Relationship [0x%x] for index 0x%x (int value: 0x%x)", value.getId(), index, (int)index));
    }

    private static void getRelationshipByIdReadOnly(long index) {
        Relationship value = graphDbReadOnly.getRelationshipById(index);
        Assert.fail((String)String.format("Returned Relationship [0x%x] for index 0x%x (int value: 0x%x)", value.getId(), index, (int)index));
    }

    static {
        testDirectory = TestDirectory.testDirectory();
    }
}

