/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestLengthyArrayPacking
extends AbstractNeo4jTestCase {
    private static final String SOME_MIXED_CHARS = "abc421#\u00a4\u00e5\u00e4\u00f6(/&\u20ac";
    private static final String SOME_LATIN_1_CHARS = "abcdefghijklmnopqrstuvwxyz";
    private final DynamicRecordCounter ARRAY_RECORD_COUNTER = new ArrayRecordCounter();
    private final DynamicRecordCounter STRING_RECORD_COUNTER = new StringRecordCounter();

    @Test
    public void bitPackingOfLengthyArrays() {
        long arrayRecordsBefore = this.dynamicArrayRecordsInUse();
        int[] arrayWhichUnpackedWouldFillTwoDynamicRecords = new int[40];
        for (int i = 0; i < arrayWhichUnpackedWouldFillTwoDynamicRecords.length; ++i) {
            arrayWhichUnpackedWouldFillTwoDynamicRecords[i] = i * i;
        }
        Node node = this.getGraphDb().createNode();
        String key = "the array";
        node.setProperty(key, (Object)arrayWhichUnpackedWouldFillTwoDynamicRecords);
        this.newTransaction();
        Assert.assertEquals((long)(arrayRecordsBefore + 1L), (long)this.dynamicArrayRecordsInUse());
        Assert.assertTrue((boolean)Arrays.equals(arrayWhichUnpackedWouldFillTwoDynamicRecords, (int[])node.getProperty(key)));
    }

    @Test
    public void makeSureLongLatin1StringUsesOneBytePerChar() {
        String string = this.stringOfLength(SOME_LATIN_1_CHARS, 239);
        this.makeSureRightAmountOfDynamicRecordsUsed(string, 2, this.STRING_RECORD_COUNTER);
    }

    @Test
    public void makeSureLongUtf8StringUsesLessThanTwoBytesPerChar() {
        String string = this.stringOfLength(SOME_MIXED_CHARS, 130);
        this.makeSureRightAmountOfDynamicRecordsUsed(string, 2, this.STRING_RECORD_COUNTER);
    }

    @Test
    public void makeSureLongLatin1StringArrayUsesOneBytePerChar() {
        String[] stringArray = new String[5];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.stringOfLength(SOME_LATIN_1_CHARS, 19);
        }
        this.makeSureRightAmountOfDynamicRecordsUsed(stringArray, 1, this.ARRAY_RECORD_COUNTER);
    }

    @Test
    public void makeSureLongUtf8StringArrayUsesLessThanTwoBytePerChar() {
        String[] stringArray = new String[7];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.stringOfLength(SOME_MIXED_CHARS, 20);
        }
        this.makeSureRightAmountOfDynamicRecordsUsed(stringArray, 2, this.ARRAY_RECORD_COUNTER);
    }

    private void makeSureRightAmountOfDynamicRecordsUsed(Object value, int expectedAddedDynamicRecords, DynamicRecordCounter recordCounter) {
        long stringRecordsBefore = recordCounter.count();
        Node node = this.getGraphDb().createNode();
        node.setProperty("name", value);
        this.newTransaction();
        long stringRecordsAfter = recordCounter.count();
        Assert.assertEquals((long)(stringRecordsBefore + (long)expectedAddedDynamicRecords), (long)stringRecordsAfter);
    }

    private String stringOfLength(String possibilities, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(possibilities.charAt(i % possibilities.length()));
        }
        return builder.toString();
    }

    private class StringRecordCounter
    implements DynamicRecordCounter {
        private StringRecordCounter() {
        }

        @Override
        public long count() {
            return TestLengthyArrayPacking.this.dynamicStringRecordsInUse();
        }
    }

    private class ArrayRecordCounter
    implements DynamicRecordCounter {
        private ArrayRecordCounter() {
        }

        @Override
        public long count() {
            return TestLengthyArrayPacking.this.dynamicArrayRecordsInUse();
        }
    }

    private static interface DynamicRecordCounter {
        public long count();
    }
}

