/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.TestDirectory;

public class TestReadOnlyNeo4j {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void testSimple() {
        File databaseDir = this.testDirectory.databaseDir();
        FileSystemAbstraction fs = this.testDirectory.getFileSystem();
        DbRepresentation someData = this.createSomeData(databaseDir, fs);
        GraphDatabaseService readGraphDb = new TestGraphDatabaseFactory().setFileSystem(fs).newEmbeddedDatabaseBuilder(databaseDir).setConfig(GraphDatabaseSettings.read_only, "true").newGraphDatabase();
        Assert.assertEquals((Object)someData, (Object)DbRepresentation.of((GraphDatabaseService)readGraphDb));
        try (Transaction tx = readGraphDb.beginTx();){
            readGraphDb.createNode();
            tx.success();
            Assert.fail((String)"Should have failed");
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
        readGraphDb.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void databaseNotStartInReadOnlyModeWithMissingIndex() throws IOException {
        File databaseDir = this.testDirectory.databaseDir();
        FileSystemAbstraction fs = this.testDirectory.getFileSystem();
        this.createIndex(databaseDir, fs);
        this.deleteIndexFolder(databaseDir, fs);
        GraphDatabaseService readGraphDb = null;
        try {
            readGraphDb = new TestGraphDatabaseFactory().setFileSystem(fs).newImpermanentDatabaseBuilder(databaseDir).setConfig(GraphDatabaseSettings.read_only, "true").newGraphDatabase();
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            Throwable rootCause = Exceptions.rootCause((Throwable)e);
            Assert.assertTrue((boolean)(rootCause instanceof IllegalStateException));
            Assert.assertTrue((boolean)rootCause.getMessage().contains("Some indexes need to be rebuilt. This is not allowed in read only mode. Please start db in writable mode to rebuild indexes. Indexes needing rebuild:"));
        }
        finally {
            if (readGraphDb != null) {
                readGraphDb.shutdown();
            }
        }
    }

    @Test
    public void testReadOnlyOperationsAndNoTransaction() {
        FileSystemAbstraction fs = this.testDirectory.getFileSystem();
        File databaseDir = this.testDirectory.databaseDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(fs).newImpermanentDatabase(databaseDir);
        Transaction tx = db.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"TEST"));
        node1.setProperty("key1", (Object)"value1");
        rel.setProperty("key1", (Object)"value1");
        tx.success();
        tx.close();
        try {
            db.createNode();
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
        try {
            node1.createRelationshipTo(node2, RelationshipType.withName((String)"TEST2"));
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
        try {
            node1.setProperty("key1", (Object)"value2");
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
        try {
            rel.removeProperty("key1");
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
        Transaction transaction = db.beginTx();
        Assert.assertEquals((Object)node1, (Object)db.getNodeById(node1.getId()));
        Assert.assertEquals((Object)node2, (Object)db.getNodeById(node2.getId()));
        Assert.assertEquals((Object)rel, (Object)db.getRelationshipById(rel.getId()));
        Assert.assertThat((Object)node1, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"key1").withValue((Object)"value1")));
        Relationship loadedRel = node1.getSingleRelationship(RelationshipType.withName((String)"TEST"), Direction.OUTGOING);
        Assert.assertEquals((Object)rel, (Object)loadedRel);
        Assert.assertThat((Object)loadedRel, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"key1").withValue((Object)"value1")));
        transaction.close();
        db.shutdown();
    }

    private void deleteIndexFolder(File databaseDir, FileSystemAbstraction fs) throws IOException {
        fs.deleteRecursively(IndexDirectoryStructure.baseSchemaIndexFolder((File)databaseDir));
    }

    private void createIndex(File databaseDir, FileSystemAbstraction fs) {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(fs).newEmbeddedDatabase(databaseDir);
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(Label.label((String)"label")).on("prop").create();
            tx.success();
        }
        tx = db.beginTx();
        var5_5 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
    }

    private DbRepresentation createSomeData(File databaseDir, FileSystemAbstraction fs) {
        RelationshipType type = RelationshipType.withName((String)"KNOWS");
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(fs).newImpermanentDatabase(databaseDir);
        try (Transaction tx = db.beginTx();){
            Node prevNode = db.createNode();
            for (int i = 0; i < 100; ++i) {
                Node node = db.createNode();
                Relationship rel = prevNode.createRelationshipTo(node, type);
                node.setProperty("someKey" + i % 10, (Object)(i % 15));
                rel.setProperty("since", (Object)System.currentTimeMillis());
            }
            tx.success();
        }
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)db);
        db.shutdown();
        return result;
    }
}

