/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.GraphTransactionRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class TestShortStringProperties {
    @ClassRule
    public static DatabaseRule graphdb = new ImpermanentDatabaseRule();
    @Rule
    public GraphTransactionRule tx = new GraphTransactionRule(graphdb);
    private static final String LONG_STRING = "this is a really long string, believe me!";

    public void commit() {
        this.tx.success();
    }

    private void newTx() {
        this.tx.success();
        this.tx.begin();
    }

    @Test
    public void canAddMultipleShortStringsToTheSameNode() {
        Node node = graphdb.getGraphDatabaseAPI().createNode();
        node.setProperty("key", (Object)"value");
        node.setProperty("reverse", (Object)"esrever");
        this.commit();
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), (Matcher)Neo4jMatchers.hasProperty((String)"key").withValue((Object)"value")));
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), (Matcher)Neo4jMatchers.hasProperty((String)"reverse").withValue((Object)"esrever")));
    }

    @Test
    public void canAddShortStringToRelationship() {
        GraphDatabaseAPI db = graphdb.getGraphDatabaseAPI();
        Relationship rel = db.createNode().createRelationshipTo(db.createNode(), RelationshipType.withName((String)"REL_TYPE"));
        rel.setProperty("type", (Object)"dimsedut");
        this.commit();
        Assert.assertThat((Object)rel, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"type").withValue((Object)"dimsedut")));
    }

    @Test
    public void canUpdateShortStringInplace() {
        Node node = graphdb.getGraphDatabaseAPI().createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.setProperty("key", (Object)"other");
        this.commit();
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), (Matcher)Neo4jMatchers.hasProperty((String)"key").withValue((Object)"other")));
    }

    @Test
    public void canReplaceLongStringWithShortString() {
        Node node = graphdb.getGraphDatabaseAPI().createNode();
        node.setProperty("key", (Object)LONG_STRING);
        this.newTx();
        Assert.assertEquals((Object)LONG_STRING, (Object)node.getProperty("key"));
        node.setProperty("key", (Object)"value");
        this.commit();
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), (Matcher)Neo4jMatchers.hasProperty((String)"key").withValue((Object)"value")));
    }

    @Test
    public void canReplaceShortStringWithLongString() {
        Node node = graphdb.getGraphDatabaseAPI().createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.setProperty("key", (Object)LONG_STRING);
        this.commit();
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), (Matcher)Neo4jMatchers.hasProperty((String)"key").withValue((Object)LONG_STRING)));
    }

    @Test
    public void canRemoveShortStringProperty() {
        GraphDatabaseAPI db = graphdb.getGraphDatabaseAPI();
        Node node = db.createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.removeProperty("key");
        this.commit();
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)"key"))));
    }
}

