/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={EphemeralFileSystemExtension.class, TestDirectoryExtension.class})
class TestIndexImplOnNeo {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseService db;

    TestIndexImplOnNeo() {
    }

    @BeforeEach
    void createDb() {
        this.db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).newImpermanentDatabase(this.testDirectory.databaseDir());
    }

    private void restartDb() {
        this.shutdownDb();
        this.createDb();
    }

    @AfterEach
    void shutdownDb() {
        this.db.shutdown();
    }

    @Test
    void createIndexWithProviderThatUsesNeoAsDataSource() {
        Index index;
        String indexName = "inneo";
        Assertions.assertFalse((boolean)this.indexExists(indexName));
        Map config = MapUtil.stringMap((String[])new String[]{"provider", "test-dummy-neo-index", "config1", "A value", "another config", "Another value"});
        try (Transaction transaction = this.db.beginTx();){
            index = this.db.index().forNodes(indexName, config);
            transaction.success();
        }
        var5_4 = null;
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertTrue((boolean)this.indexExists(indexName));
            Assertions.assertEquals((Object)config, (Object)this.db.index().getConfiguration(index));
            try (IndexHits indexHits = index.get("key", (Object)"something else");){
                Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)indexHits));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        this.restartDb();
        tx = this.db.beginTx();
        var5_4 = null;
        try {
            Assertions.assertTrue((boolean)this.indexExists(indexName));
            Assertions.assertEquals((Object)config, (Object)this.db.index().getConfiguration(index));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private boolean indexExists(String indexName) {
        try (Transaction transaction = this.db.beginTx();){
            boolean exists = this.db.index().existsForNodes(indexName);
            transaction.success();
            boolean bl = exists;
            return bl;
        }
    }
}

